/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CreateSender;
import software.xdev.brevo.model.CreateSenderModel;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetIps;
import software.xdev.brevo.model.GetIpsFromSender;
import software.xdev.brevo.model.GetSendersList;
import software.xdev.brevo.model.Otp;
import software.xdev.brevo.model.UpdateSender;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class SendersApi extends BaseApi {

  public SendersApi() {
    super(Configuration.getDefaultApiClient());
  }

  public SendersApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create a new sender
   * 
   * @param sender sender&#39;s name (optional)
   * @return CreateSenderModel
   * @throws ApiException if fails to make API call
   */
  public CreateSenderModel createSender(@jakarta.annotation.Nullable CreateSender sender) throws ApiException {
    return this.createSender(sender, Collections.emptyMap());
  }


  /**
   * Create a new sender
   * 
   * @param sender sender&#39;s name (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateSenderModel
   * @throws ApiException if fails to make API call
   */
  public CreateSenderModel createSender(@jakarta.annotation.Nullable CreateSender sender, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sender;
    
    // create path and map variables
    String localVarPath = "/senders";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateSenderModel> localVarReturnType = new TypeReference<CreateSenderModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a sender
   * 
   * @param senderId Id of the sender (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteSender(@jakarta.annotation.Nonnull Long senderId) throws ApiException {
    this.deleteSender(senderId, Collections.emptyMap());
  }


  /**
   * Delete a sender
   * 
   * @param senderId Id of the sender (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteSender(@jakarta.annotation.Nonnull Long senderId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'senderId' is set
    if (senderId == null) {
      throw new ApiException(400, "Missing the required parameter 'senderId' when calling deleteSender");
    }
    
    // create path and map variables
    String localVarPath = "/senders/{senderId}"
      .replaceAll("\\{" + "senderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(senderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get all the dedicated IPs for your account
   * 
   * @return GetIps
   * @throws ApiException if fails to make API call
   */
  public GetIps getIps() throws ApiException {
    return this.getIps(Collections.emptyMap());
  }


  /**
   * Get all the dedicated IPs for your account
   * 
   * @param additionalHeaders additionalHeaders for this call
   * @return GetIps
   * @throws ApiException if fails to make API call
   */
  public GetIps getIps(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/senders/ips";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetIps> localVarReturnType = new TypeReference<GetIps>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all the dedicated IPs for a sender
   * 
   * @param senderId Id of the sender (required)
   * @return GetIpsFromSender
   * @throws ApiException if fails to make API call
   */
  public GetIpsFromSender getIpsFromSender(@jakarta.annotation.Nonnull Long senderId) throws ApiException {
    return this.getIpsFromSender(senderId, Collections.emptyMap());
  }


  /**
   * Get all the dedicated IPs for a sender
   * 
   * @param senderId Id of the sender (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetIpsFromSender
   * @throws ApiException if fails to make API call
   */
  public GetIpsFromSender getIpsFromSender(@jakarta.annotation.Nonnull Long senderId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'senderId' is set
    if (senderId == null) {
      throw new ApiException(400, "Missing the required parameter 'senderId' when calling getIpsFromSender");
    }
    
    // create path and map variables
    String localVarPath = "/senders/{senderId}/ips"
      .replaceAll("\\{" + "senderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(senderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetIpsFromSender> localVarReturnType = new TypeReference<GetIpsFromSender>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of all your senders
   * 
   * @param ip Filter your senders for a specific ip. **Available for dedicated IP usage only**  (optional)
   * @param domain Filter your senders for a specific domain (optional)
   * @return GetSendersList
   * @throws ApiException if fails to make API call
   */
  public GetSendersList getSenders(@jakarta.annotation.Nullable String ip, @jakarta.annotation.Nullable String domain) throws ApiException {
    return this.getSenders(ip, domain, Collections.emptyMap());
  }


  /**
   * Get the list of all your senders
   * 
   * @param ip Filter your senders for a specific ip. **Available for dedicated IP usage only**  (optional)
   * @param domain Filter your senders for a specific domain (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSendersList
   * @throws ApiException if fails to make API call
   */
  public GetSendersList getSenders(@jakarta.annotation.Nullable String ip, @jakarta.annotation.Nullable String domain, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/senders";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("ip", ip));
    localVarQueryParams.addAll(apiClient.parameterToPair("domain", domain));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSendersList> localVarReturnType = new TypeReference<GetSendersList>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update a sender
   * 
   * @param senderId Id of the sender (required)
   * @param sender sender&#39;s name (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateSender(@jakarta.annotation.Nonnull Long senderId, @jakarta.annotation.Nullable UpdateSender sender) throws ApiException {
    this.updateSender(senderId, sender, Collections.emptyMap());
  }


  /**
   * Update a sender
   * 
   * @param senderId Id of the sender (required)
   * @param sender sender&#39;s name (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateSender(@jakarta.annotation.Nonnull Long senderId, @jakarta.annotation.Nullable UpdateSender sender, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sender;
    
    // verify the required parameter 'senderId' is set
    if (senderId == null) {
      throw new ApiException(400, "Missing the required parameter 'senderId' when calling updateSender");
    }
    
    // create path and map variables
    String localVarPath = "/senders/{senderId}"
      .replaceAll("\\{" + "senderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(senderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Validate Sender using OTP
   * 
   * @param senderId Id of the sender (required)
   * @param sender otp (optional)
   * @throws ApiException if fails to make API call
   */
  public void validateSenderByOTP(@jakarta.annotation.Nonnull Long senderId, @jakarta.annotation.Nullable Otp sender) throws ApiException {
    this.validateSenderByOTP(senderId, sender, Collections.emptyMap());
  }


  /**
   * Validate Sender using OTP
   * 
   * @param senderId Id of the sender (required)
   * @param sender otp (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void validateSenderByOTP(@jakarta.annotation.Nonnull Long senderId, @jakarta.annotation.Nullable Otp sender, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sender;
    
    // verify the required parameter 'senderId' is set
    if (senderId == null) {
      throw new ApiException(400, "Missing the required parameter 'senderId' when calling validateSenderByOTP");
    }
    
    // create path and map variables
    String localVarPath = "/senders/{senderId}/validate"
      .replaceAll("\\{" + "senderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(senderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
