/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.MainAttributeRewardPayload;
import software.xdev.brevo.model.MainCodeCountHttpResponse;
import software.xdev.brevo.model.MainCreateRedeemPayload;
import software.xdev.brevo.model.MainCreateRewardPayload;
import software.xdev.brevo.model.MainCreateRewardResponse;
import software.xdev.brevo.model.MainErrorResponse;
import software.xdev.brevo.model.MainModelContactRewardsResp;
import software.xdev.brevo.model.MainRedeem;
import software.xdev.brevo.model.MainReward;
import software.xdev.brevo.model.MainRewardAttribution;
import software.xdev.brevo.model.MainRewardPage;
import software.xdev.brevo.model.MainRewardValidate;
import software.xdev.brevo.model.MainValidateRewardPayload;
import java.util.UUID;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class RewardApi extends BaseApi {

  public RewardApi() {
    super(Configuration.getDefaultApiClient());
  }

  public RewardApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Complete redeem voucher request
   * Completes voucher redeem request.
   * @param pid Loyalty Program ID (required)
   * @param tid Redeem transaction ID (required)
   * @return MainRedeem
   * @throws ApiException if fails to make API call
   */
  public MainRedeem completeRedeemTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull String tid) throws ApiException {
    return this.completeRedeemTransaction(pid, tid, Collections.emptyMap());
  }


  /**
   * Complete redeem voucher request
   * Completes voucher redeem request.
   * @param pid Loyalty Program ID (required)
   * @param tid Redeem transaction ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainRedeem
   * @throws ApiException if fails to make API call
   */
  public MainRedeem completeRedeemTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull String tid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling completeRedeemTransaction");
    }
    
    // verify the required parameter 'tid' is set
    if (tid == null) {
      throw new ApiException(400, "Missing the required parameter 'tid' when calling completeRedeemTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/rewards/redeem/{tid}/complete"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "tid" + "\\}", apiClient.escapeString(apiClient.parameterToString(tid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainRedeem> localVarReturnType = new TypeReference<MainRedeem>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a reward
   * Creates a new reward in the loyalty program.
   * @param pid Loyalty Program ID (required)
   * @param mainCreateRewardPayload  (required)
   * @return MainCreateRewardResponse
   * @throws ApiException if fails to make API call
   */
  public MainCreateRewardResponse createReward(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainCreateRewardPayload mainCreateRewardPayload) throws ApiException {
    return this.createReward(pid, mainCreateRewardPayload, Collections.emptyMap());
  }


  /**
   * Create a reward
   * Creates a new reward in the loyalty program.
   * @param pid Loyalty Program ID (required)
   * @param mainCreateRewardPayload  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainCreateRewardResponse
   * @throws ApiException if fails to make API call
   */
  public MainCreateRewardResponse createReward(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainCreateRewardPayload mainCreateRewardPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = mainCreateRewardPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling createReward");
    }
    
    // verify the required parameter 'mainCreateRewardPayload' is set
    if (mainCreateRewardPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'mainCreateRewardPayload' when calling createReward");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/offers"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainCreateRewardResponse> localVarReturnType = new TypeReference<MainCreateRewardResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a voucher
   * Create a voucher and attribute it to a specific membership.
   * @param pid Loyalty Program ID (required)
   * @param mainAttributeRewardPayload  (required)
   * @return MainRewardAttribution
   * @throws ApiException if fails to make API call
   */
  public MainRewardAttribution createVoucher(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainAttributeRewardPayload mainAttributeRewardPayload) throws ApiException {
    return this.createVoucher(pid, mainAttributeRewardPayload, Collections.emptyMap());
  }


  /**
   * Create a voucher
   * Create a voucher and attribute it to a specific membership.
   * @param pid Loyalty Program ID (required)
   * @param mainAttributeRewardPayload  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainRewardAttribution
   * @throws ApiException if fails to make API call
   */
  public MainRewardAttribution createVoucher(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainAttributeRewardPayload mainAttributeRewardPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = mainAttributeRewardPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling createVoucher");
    }
    
    // verify the required parameter 'mainAttributeRewardPayload' is set
    if (mainAttributeRewardPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'mainAttributeRewardPayload' when calling createVoucher");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/rewards/attribute"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainRewardAttribution> localVarReturnType = new TypeReference<MainRewardAttribution>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get code count
   * Get code count
   * @param pid Loyalty Program ID (required)
   * @param cpid Code Pool ID (required)
   * @return MainCodeCountHttpResponse
   * @throws ApiException if fails to make API call
   */
  public MainCodeCountHttpResponse getCodeCount(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID cpid) throws ApiException {
    return this.getCodeCount(pid, cpid, Collections.emptyMap());
  }


  /**
   * Get code count
   * Get code count
   * @param pid Loyalty Program ID (required)
   * @param cpid Code Pool ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainCodeCountHttpResponse
   * @throws ApiException if fails to make API call
   */
  public MainCodeCountHttpResponse getCodeCount(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID cpid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getCodeCount");
    }
    
    // verify the required parameter 'cpid' is set
    if (cpid == null) {
      throw new ApiException(400, "Missing the required parameter 'cpid' when calling getCodeCount");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/code-pools/{cpid}/codes-count"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "cpid" + "\\}", apiClient.escapeString(apiClient.parameterToString(cpid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainCodeCountHttpResponse> localVarReturnType = new TypeReference<MainCodeCountHttpResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Reward Page API
   * Returns a reward page
   * @param pid Loyalty Program ID (required)
   * @param limit Page size (optional, default to 25)
   * @param offset Pagination offset (optional, default to 0)
   * @param state State of the reward (optional, default to all)
   * @param version Version (optional, default to draft)
   * @return MainRewardPage
   * @throws ApiException if fails to make API call
   */
  public MainRewardPage loyaltyOfferProgramsPidOffersGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String state, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.loyaltyOfferProgramsPidOffersGet(pid, limit, offset, state, version, Collections.emptyMap());
  }


  /**
   * Get Reward Page API
   * Returns a reward page
   * @param pid Loyalty Program ID (required)
   * @param limit Page size (optional, default to 25)
   * @param offset Pagination offset (optional, default to 0)
   * @param state State of the reward (optional, default to all)
   * @param version Version (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainRewardPage
   * @throws ApiException if fails to make API call
   */
  public MainRewardPage loyaltyOfferProgramsPidOffersGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String state, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyOfferProgramsPidOffersGet");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/offers"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("state", state));
    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainRewardPage> localVarReturnType = new TypeReference<MainRewardPage>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get reward information
   * Returns reward information.
   * @param pid Loyalty Program ID (required)
   * @param rid Reward ID (required)
   * @param version Version (optional, default to draft)
   * @return MainReward
   * @throws ApiException if fails to make API call
   */
  public MainReward loyaltyOfferProgramsPidRewardsRidGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID rid, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.loyaltyOfferProgramsPidRewardsRidGet(pid, rid, version, Collections.emptyMap());
  }


  /**
   * Get reward information
   * Returns reward information.
   * @param pid Loyalty Program ID (required)
   * @param rid Reward ID (required)
   * @param version Version (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainReward
   * @throws ApiException if fails to make API call
   */
  public MainReward loyaltyOfferProgramsPidRewardsRidGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID rid, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyOfferProgramsPidRewardsRidGet");
    }
    
    // verify the required parameter 'rid' is set
    if (rid == null) {
      throw new ApiException(400, "Missing the required parameter 'rid' when calling loyaltyOfferProgramsPidRewardsRidGet");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/rewards/{rid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "rid" + "\\}", apiClient.escapeString(apiClient.parameterToString(rid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainReward> localVarReturnType = new TypeReference<MainReward>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get voucher for a contact
   * Get voucher for a contact
   * @param pid Loyalty Program ID (required)
   * @param contactId Contact ID (required)
   * @param limit Page size (optional, default to 25)
   * @param offset Pagination offset (optional, default to 0)
   * @param sort Sort order (optional, default to desc)
   * @param sortField Sort field (optional, default to updatedAt)
   * @param metadataKeyValue Metadata value for a Key filter (optional)
   * @param rewardId Reward ID (optional)
   * @return MainModelContactRewardsResp
   * @throws ApiException if fails to make API call
   */
  public MainModelContactRewardsResp loyaltyOfferProgramsPidVouchersGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull Integer contactId, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String metadataKeyValue, @jakarta.annotation.Nullable String rewardId) throws ApiException {
    return this.loyaltyOfferProgramsPidVouchersGet(pid, contactId, limit, offset, sort, sortField, metadataKeyValue, rewardId, Collections.emptyMap());
  }


  /**
   * Get voucher for a contact
   * Get voucher for a contact
   * @param pid Loyalty Program ID (required)
   * @param contactId Contact ID (required)
   * @param limit Page size (optional, default to 25)
   * @param offset Pagination offset (optional, default to 0)
   * @param sort Sort order (optional, default to desc)
   * @param sortField Sort field (optional, default to updatedAt)
   * @param metadataKeyValue Metadata value for a Key filter (optional)
   * @param rewardId Reward ID (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainModelContactRewardsResp
   * @throws ApiException if fails to make API call
   */
  public MainModelContactRewardsResp loyaltyOfferProgramsPidVouchersGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull Integer contactId, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String metadataKeyValue, @jakarta.annotation.Nullable String rewardId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyOfferProgramsPidVouchersGet");
    }
    
    // verify the required parameter 'contactId' is set
    if (contactId == null) {
      throw new ApiException(400, "Missing the required parameter 'contactId' when calling loyaltyOfferProgramsPidVouchersGet");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/vouchers"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortField", sortField));
    localVarQueryParams.addAll(apiClient.parameterToPair("contactId", contactId));
    localVarQueryParams.addAll(apiClient.parameterToPair("metadata_key_value", metadataKeyValue));
    localVarQueryParams.addAll(apiClient.parameterToPair("rewardId", rewardId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainModelContactRewardsResp> localVarReturnType = new TypeReference<MainModelContactRewardsResp>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create redeem voucher request
   * Creates a request to redeem a voucher.
   * @param pid Loyalty Program ID (required)
   * @param mainCreateRedeemPayload  (required)
   * @return MainRedeem
   * @throws ApiException if fails to make API call
   */
  public MainRedeem redeemVoucher(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainCreateRedeemPayload mainCreateRedeemPayload) throws ApiException {
    return this.redeemVoucher(pid, mainCreateRedeemPayload, Collections.emptyMap());
  }


  /**
   * Create redeem voucher request
   * Creates a request to redeem a voucher.
   * @param pid Loyalty Program ID (required)
   * @param mainCreateRedeemPayload  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainRedeem
   * @throws ApiException if fails to make API call
   */
  public MainRedeem redeemVoucher(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainCreateRedeemPayload mainCreateRedeemPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = mainCreateRedeemPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling redeemVoucher");
    }
    
    // verify the required parameter 'mainCreateRedeemPayload' is set
    if (mainCreateRedeemPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'mainCreateRedeemPayload' when calling redeemVoucher");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/rewards/redeem"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainRedeem> localVarReturnType = new TypeReference<MainRedeem>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Revoke vouchers
   * Revoke attributed vouchers.
   * @param pid Loyalty Program ID (required)
   * @param attributedRewardIds Reward Attribution IDs (comma seperated) (optional)
   * @throws ApiException if fails to make API call
   */
  public void revokeVouchers(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String attributedRewardIds) throws ApiException {
    this.revokeVouchers(pid, attributedRewardIds, Collections.emptyMap());
  }


  /**
   * Revoke vouchers
   * Revoke attributed vouchers.
   * @param pid Loyalty Program ID (required)
   * @param attributedRewardIds Reward Attribution IDs (comma seperated) (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void revokeVouchers(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String attributedRewardIds, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling revokeVouchers");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/rewards/revoke"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("attributedRewardIds", attributedRewardIds));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Validate a reward
   * Validates a reward.
   * @param pid Loyalty Program ID (required)
   * @param mainValidateRewardPayload  (required)
   * @return MainRewardValidate
   * @throws ApiException if fails to make API call
   */
  public MainRewardValidate validateReward(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainValidateRewardPayload mainValidateRewardPayload) throws ApiException {
    return this.validateReward(pid, mainValidateRewardPayload, Collections.emptyMap());
  }


  /**
   * Validate a reward
   * Validates a reward.
   * @param pid Loyalty Program ID (required)
   * @param mainValidateRewardPayload  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return MainRewardValidate
   * @throws ApiException if fails to make API call
   */
  public MainRewardValidate validateReward(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull MainValidateRewardPayload mainValidateRewardPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = mainValidateRewardPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling validateReward");
    }
    
    // verify the required parameter 'mainValidateRewardPayload' is set
    if (mainValidateRewardPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'mainValidateRewardPayload' when calling validateReward");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/offer/programs/{pid}/rewards/validate"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MainRewardValidate> localVarReturnType = new TypeReference<MainRewardValidate>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
