/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.AddSubscriptionMemberPayload;
import software.xdev.brevo.model.CreateLoyaltyProgramPayload;
import software.xdev.brevo.model.CreateSubscriptionPayload;
import software.xdev.brevo.model.ErrorResponse;
import software.xdev.brevo.model.LoyaltyProgram;
import software.xdev.brevo.model.LoyaltyProgramPage;
import software.xdev.brevo.model.PatchLoyaltyProgramPayload;
import software.xdev.brevo.model.Subscription;
import software.xdev.brevo.model.SubscriptionHandlerInfo;
import software.xdev.brevo.model.SubscriptionMember;
import java.util.UUID;
import software.xdev.brevo.model.UpdateLoyaltyProgramPayload;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ProgramApi extends BaseApi {

  public ProgramApi() {
    super(Configuration.getDefaultApiClient());
  }

  public ProgramApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create loyalty program
   * Creates loyalty program
   * @param createLoyaltyProgramPayload Payload for creating a new loyalty program. (required)
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram createNewLP(@jakarta.annotation.Nonnull CreateLoyaltyProgramPayload createLoyaltyProgramPayload) throws ApiException {
    return this.createNewLP(createLoyaltyProgramPayload, Collections.emptyMap());
  }


  /**
   * Create loyalty program
   * Creates loyalty program
   * @param createLoyaltyProgramPayload Payload for creating a new loyalty program. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram createNewLP(@jakarta.annotation.Nonnull CreateLoyaltyProgramPayload createLoyaltyProgramPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createLoyaltyProgramPayload;
    
    // verify the required parameter 'createLoyaltyProgramPayload' is set
    if (createLoyaltyProgramPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createLoyaltyProgramPayload' when calling createNewLP");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete subscription member
   * Deletes member from a subscription
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param memberContactIds Comma-separated list of member contact IDs to delete from the subscription. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteContactMembers(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull String memberContactIds) throws ApiException {
    this.deleteContactMembers(pid, memberContactIds, Collections.emptyMap());
  }


  /**
   * Delete subscription member
   * Deletes member from a subscription
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param memberContactIds Comma-separated list of member contact IDs to delete from the subscription. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteContactMembers(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull String memberContactIds, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteContactMembers");
    }
    
    // verify the required parameter 'memberContactIds' is set
    if (memberContactIds == null) {
      throw new ApiException(400, "Missing the required parameter 'memberContactIds' when calling deleteContactMembers");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}/subscription-members"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("memberContactIds", memberContactIds));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete Loyalty Program
   * Deletes Loyalty Program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid) throws ApiException {
    this.deleteLoyaltyProgram(pid, Collections.emptyMap());
  }


  /**
   * Delete Loyalty Program
   * Deletes Loyalty Program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteLoyaltyProgram");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get loyalty program list
   * Returns list of loyalty programs
   * @param limit Number of documents per page (optional)
   * @param offset Index of the first document in the page (optional)
   * @param sortField Sort documents by field (optional)
   * @param sort Sort documents by field (optional)
   * @return LoyaltyProgramPage
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgramPage getLPList(@jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getLPList(limit, offset, sortField, sort, Collections.emptyMap());
  }


  /**
   * Get loyalty program list
   * Returns list of loyalty programs
   * @param limit Number of documents per page (optional)
   * @param offset Index of the first document in the page (optional)
   * @param sortField Sort documents by field (optional)
   * @param sort Sort documents by field (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return LoyaltyProgramPage
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgramPage getLPList(@jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort_field", sortField));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<LoyaltyProgramPage> localVarReturnType = new TypeReference<LoyaltyProgramPage>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get loyalty program Info
   * Returns loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram getLoyaltyProgramInfo(@jakarta.annotation.Nonnull UUID pid) throws ApiException {
    return this.getLoyaltyProgramInfo(pid, Collections.emptyMap());
  }


  /**
   * Get loyalty program Info
   * Returns loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram getLoyaltyProgramInfo(@jakarta.annotation.Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getLoyaltyProgramInfo");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Subscription Data
   * Get Information of balances, tiers, rewards and subscription members for a subscription
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param contactId The contact ID to filter by. (optional)
   * @param params A list of filter parameters for querying the subscription info. (optional)
   * @param loyaltySubscriptionId The loyalty subscription ID to filter by. (optional)
   * @return SubscriptionHandlerInfo
   * @throws ApiException if fails to make API call
   */
  public SubscriptionHandlerInfo getParameterSubscriptionInfo(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String contactId, @jakarta.annotation.Nullable String params, @jakarta.annotation.Nullable String loyaltySubscriptionId) throws ApiException {
    return this.getParameterSubscriptionInfo(pid, contactId, params, loyaltySubscriptionId, Collections.emptyMap());
  }


  /**
   * Get Subscription Data
   * Get Information of balances, tiers, rewards and subscription members for a subscription
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param contactId The contact ID to filter by. (optional)
   * @param params A list of filter parameters for querying the subscription info. (optional)
   * @param loyaltySubscriptionId The loyalty subscription ID to filter by. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return SubscriptionHandlerInfo
   * @throws ApiException if fails to make API call
   */
  public SubscriptionHandlerInfo getParameterSubscriptionInfo(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable String contactId, @jakarta.annotation.Nullable String params, @jakarta.annotation.Nullable String loyaltySubscriptionId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getParameterSubscriptionInfo");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}/account-info"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("contactId", contactId));
    localVarQueryParams.addAll(apiClient.parameterToPair("params", params));
    localVarQueryParams.addAll(apiClient.parameterToPair("loyaltySubscriptionId", loyaltySubscriptionId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<SubscriptionHandlerInfo> localVarReturnType = new TypeReference<SubscriptionHandlerInfo>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Partially update loyalty program
   * Partially updates loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param patchLoyaltyProgramPayload Loyalty Program Payload (required)
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram partiallyUpdateLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull PatchLoyaltyProgramPayload patchLoyaltyProgramPayload) throws ApiException {
    return this.partiallyUpdateLoyaltyProgram(pid, patchLoyaltyProgramPayload, Collections.emptyMap());
  }


  /**
   * Partially update loyalty program
   * Partially updates loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param patchLoyaltyProgramPayload Loyalty Program Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram partiallyUpdateLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull PatchLoyaltyProgramPayload patchLoyaltyProgramPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = patchLoyaltyProgramPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling partiallyUpdateLoyaltyProgram");
    }
    
    // verify the required parameter 'patchLoyaltyProgramPayload' is set
    if (patchLoyaltyProgramPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'patchLoyaltyProgramPayload' when calling partiallyUpdateLoyaltyProgram");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PATCH",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Publish loyalty program
   * Publishes loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @throws ApiException if fails to make API call
   */
  public void publishLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid) throws ApiException {
    this.publishLoyaltyProgram(pid, Collections.emptyMap());
  }


  /**
   * Publish loyalty program
   * Publishes loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void publishLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling publishLoyaltyProgram");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}/publish"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create subscription member
   * Add member to a subscription
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param addSubscriptionMemberPayload Payload for adding a subscription member. (required)
   * @return SubscriptionMember
   * @throws ApiException if fails to make API call
   */
  public SubscriptionMember subscribeMemberToASubscription(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull AddSubscriptionMemberPayload addSubscriptionMemberPayload) throws ApiException {
    return this.subscribeMemberToASubscription(pid, addSubscriptionMemberPayload, Collections.emptyMap());
  }


  /**
   * Create subscription member
   * Add member to a subscription
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param addSubscriptionMemberPayload Payload for adding a subscription member. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return SubscriptionMember
   * @throws ApiException if fails to make API call
   */
  public SubscriptionMember subscribeMemberToASubscription(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull AddSubscriptionMemberPayload addSubscriptionMemberPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = addSubscriptionMemberPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling subscribeMemberToASubscription");
    }
    
    // verify the required parameter 'addSubscriptionMemberPayload' is set
    if (addSubscriptionMemberPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'addSubscriptionMemberPayload' when calling subscribeMemberToASubscription");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}/subscription-members"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<SubscriptionMember> localVarReturnType = new TypeReference<SubscriptionMember>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create subscription
   * Subscribes to a loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param createSubscriptionPayload Create Subscription Payload (required)
   * @return Subscription
   * @throws ApiException if fails to make API call
   */
  public Subscription subscribeToLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateSubscriptionPayload createSubscriptionPayload) throws ApiException {
    return this.subscribeToLoyaltyProgram(pid, createSubscriptionPayload, Collections.emptyMap());
  }


  /**
   * Create subscription
   * Subscribes to a loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param createSubscriptionPayload Create Subscription Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Subscription
   * @throws ApiException if fails to make API call
   */
  public Subscription subscribeToLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateSubscriptionPayload createSubscriptionPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createSubscriptionPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling subscribeToLoyaltyProgram");
    }
    
    // verify the required parameter 'createSubscriptionPayload' is set
    if (createSubscriptionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createSubscriptionPayload' when calling subscribeToLoyaltyProgram");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}/subscriptions"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Subscription> localVarReturnType = new TypeReference<Subscription>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update loyalty program
   * Updates loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param updateLoyaltyProgramPayload Update Loyalty Program Payload (required)
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram updateLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UpdateLoyaltyProgramPayload updateLoyaltyProgramPayload) throws ApiException {
    return this.updateLoyaltyProgram(pid, updateLoyaltyProgramPayload, Collections.emptyMap());
  }


  /**
   * Update loyalty program
   * Updates loyalty program
   * @param pid Loyalty Program ID. A unique identifier for the loyalty program. (required)
   * @param updateLoyaltyProgramPayload Update Loyalty Program Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return LoyaltyProgram
   * @throws ApiException if fails to make API call
   */
  public LoyaltyProgram updateLoyaltyProgram(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UpdateLoyaltyProgramPayload updateLoyaltyProgramPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateLoyaltyProgramPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling updateLoyaltyProgram");
    }
    
    // verify the required parameter 'updateLoyaltyProgramPayload' is set
    if (updateLoyaltyProgramPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'updateLoyaltyProgramPayload' when calling updateLoyaltyProgram");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/config/programs/{pid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<LoyaltyProgram> localVarReturnType = new TypeReference<LoyaltyProgram>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
