/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.Note;
import software.xdev.brevo.model.NoteData;
import software.xdev.brevo.model.NoteId;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class NotesApi extends BaseApi {

  public NotesApi() {
    super(Configuration.getDefaultApiClient());
  }

  public NotesApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Get all notes
   * 
   * @param entity Filter by note entity type (optional)
   * @param entityIds Filter by note entity IDs (optional)
   * @param dateFrom dateFrom to date range filter type (timestamp in milliseconds) (optional)
   * @param dateTo dateTo to date range filter type (timestamp in milliseconds) (optional)
   * @param offset Index of the first document of the page (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param sort Sort the results in the ascending/descending order. Default order is **descending** by creation if &#x60;sort&#x60; is not passed (optional)
   * @return List&lt;Note&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Note> crmNotesGet(@jakarta.annotation.Nullable String entity, @jakarta.annotation.Nullable String entityIds, @jakarta.annotation.Nullable Integer dateFrom, @jakarta.annotation.Nullable Integer dateTo, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.crmNotesGet(entity, entityIds, dateFrom, dateTo, offset, limit, sort, Collections.emptyMap());
  }


  /**
   * Get all notes
   * 
   * @param entity Filter by note entity type (optional)
   * @param entityIds Filter by note entity IDs (optional)
   * @param dateFrom dateFrom to date range filter type (timestamp in milliseconds) (optional)
   * @param dateTo dateTo to date range filter type (timestamp in milliseconds) (optional)
   * @param offset Index of the first document of the page (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param sort Sort the results in the ascending/descending order. Default order is **descending** by creation if &#x60;sort&#x60; is not passed (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;Note&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Note> crmNotesGet(@jakarta.annotation.Nullable String entity, @jakarta.annotation.Nullable String entityIds, @jakarta.annotation.Nullable Integer dateFrom, @jakarta.annotation.Nullable Integer dateTo, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/crm/notes";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("entity", entity));
    localVarQueryParams.addAll(apiClient.parameterToPair("entityIds", entityIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateFrom", dateFrom));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateTo", dateTo));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<List<Note>> localVarReturnType = new TypeReference<List<Note>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a note
   * 
   * @param id Note ID to delete (required)
   * @throws ApiException if fails to make API call
   */
  public void crmNotesIdDelete(@jakarta.annotation.Nonnull String id) throws ApiException {
    this.crmNotesIdDelete(id, Collections.emptyMap());
  }


  /**
   * Delete a note
   * 
   * @param id Note ID to delete (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void crmNotesIdDelete(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmNotesIdDelete");
    }
    
    // create path and map variables
    String localVarPath = "/crm/notes/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get a note
   * 
   * @param id Note ID to get (required)
   * @return Note
   * @throws ApiException if fails to make API call
   */
  public Note crmNotesIdGet(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.crmNotesIdGet(id, Collections.emptyMap());
  }


  /**
   * Get a note
   * 
   * @param id Note ID to get (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Note
   * @throws ApiException if fails to make API call
   */
  public Note crmNotesIdGet(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmNotesIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/crm/notes/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Note> localVarReturnType = new TypeReference<Note>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update a note
   * 
   * @param id Note ID to update (required)
   * @param noteData Note data to update a note. (required)
   * @throws ApiException if fails to make API call
   */
  public void crmNotesIdPatch(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull NoteData noteData) throws ApiException {
    this.crmNotesIdPatch(id, noteData, Collections.emptyMap());
  }


  /**
   * Update a note
   * 
   * @param id Note ID to update (required)
   * @param noteData Note data to update a note. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void crmNotesIdPatch(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull NoteData noteData, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = noteData;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmNotesIdPatch");
    }
    
    // verify the required parameter 'noteData' is set
    if (noteData == null) {
      throw new ApiException(400, "Missing the required parameter 'noteData' when calling crmNotesIdPatch");
    }
    
    // create path and map variables
    String localVarPath = "/crm/notes/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PATCH",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create a note
   * 
   * @param noteData Note data to create a note. (required)
   * @return NoteId
   * @throws ApiException if fails to make API call
   */
  public NoteId crmNotesPost(@jakarta.annotation.Nonnull NoteData noteData) throws ApiException {
    return this.crmNotesPost(noteData, Collections.emptyMap());
  }


  /**
   * Create a note
   * 
   * @param noteData Note data to create a note. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return NoteId
   * @throws ApiException if fails to make API call
   */
  public NoteId crmNotesPost(@jakarta.annotation.Nonnull NoteData noteData, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = noteData;
    
    // verify the required parameter 'noteData' is set
    if (noteData == null) {
      throw new ApiException(400, "Missing the required parameter 'noteData' when calling crmNotesPost");
    }
    
    // create path and map variables
    String localVarPath = "/crm/notes";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<NoteId> localVarReturnType = new TypeReference<NoteId>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
