/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CorporateGroupDetailsResponse;
import software.xdev.brevo.model.CorporateGroupIdPutRequest;
import software.xdev.brevo.model.CorporateGroupPost201Response;
import software.xdev.brevo.model.CorporateGroupPostRequest;
import software.xdev.brevo.model.CorporateGroupUnlinkGroupIdSubAccountsPutRequest;
import software.xdev.brevo.model.CorporateIpGet200ResponseInner;
import software.xdev.brevo.model.CorporateSsoTokenPostRequest;
import software.xdev.brevo.model.CorporateSubAccountIpAssociatePostRequest;
import software.xdev.brevo.model.CorporateSubAccountIpDissociatePutRequest;
import software.xdev.brevo.model.CorporateSubAccountKeyPostRequest;
import software.xdev.brevo.model.CorporateSubAccountSsoTokenPostRequest;
import software.xdev.brevo.model.CorporateUserEmailPermissionsPutRequest;
import software.xdev.brevo.model.CorporateUserInvitationActionEmailPut200Response;
import software.xdev.brevo.model.CreateApiKeyResponse;
import software.xdev.brevo.model.CreateSubAccount;
import software.xdev.brevo.model.CreateSubAccountResponse;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetAccountActivity;
import software.xdev.brevo.model.GetCorporateInvitedUsersList;
import software.xdev.brevo.model.GetCorporateUserPermission;
import software.xdev.brevo.model.GetSsoToken;
import software.xdev.brevo.model.GetSubAccountGroups200ResponseInner;
import software.xdev.brevo.model.InviteAdminUser;
import software.xdev.brevo.model.MasterDetailsResponse;
import software.xdev.brevo.model.SubAccountAppsToggleRequest;
import software.xdev.brevo.model.SubAccountDetailsResponse;
import software.xdev.brevo.model.SubAccountUpdatePlanRequest;
import software.xdev.brevo.model.SubAccountsResponse;
import software.xdev.brevo.model.SubAccountsUpdatePlanRequest;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class MasterAccountApi extends BaseApi {

  public MasterAccountApi() {
    super(Configuration.getDefaultApiClient());
  }

  public MasterAccountApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Delete a group
   * This endpoint allows you to delete a group of sub-organizations. When a group is deleted, the sub-organizations are no longer part of this group. The users associated with the group are no longer associated with the group once deleted.
   * @param id Id of the group (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateGroupIdDelete(@jakarta.annotation.Nonnull String id) throws ApiException {
    this.corporateGroupIdDelete(id, Collections.emptyMap());
  }


  /**
   * Delete a group
   * This endpoint allows you to delete a group of sub-organizations. When a group is deleted, the sub-organizations are no longer part of this group. The users associated with the group are no longer associated with the group once deleted.
   * @param id Id of the group (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateGroupIdDelete(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateGroupIdDelete");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/group/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * GET a group details
   * This endpoint allows you to retrieve a specific group’s information such as the list of sub-organizations and the user associated with the group.
   * @param id Id of the group of sub-organization (required)
   * @return CorporateGroupDetailsResponse
   * @throws ApiException if fails to make API call
   */
  public CorporateGroupDetailsResponse corporateGroupIdGet(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.corporateGroupIdGet(id, Collections.emptyMap());
  }


  /**
   * GET a group details
   * This endpoint allows you to retrieve a specific group’s information such as the list of sub-organizations and the user associated with the group.
   * @param id Id of the group of sub-organization (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CorporateGroupDetailsResponse
   * @throws ApiException if fails to make API call
   */
  public CorporateGroupDetailsResponse corporateGroupIdGet(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateGroupIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/group/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CorporateGroupDetailsResponse> localVarReturnType = new TypeReference<CorporateGroupDetailsResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update a group of sub-accounts
   * This endpoint allows to update a group of sub-accounts
   * @param id Id of the group (required)
   * @param corporateGroupIdPutRequest Group details to be updated. (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateGroupIdPut(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull CorporateGroupIdPutRequest corporateGroupIdPutRequest) throws ApiException {
    this.corporateGroupIdPut(id, corporateGroupIdPutRequest, Collections.emptyMap());
  }


  /**
   * Update a group of sub-accounts
   * This endpoint allows to update a group of sub-accounts
   * @param id Id of the group (required)
   * @param corporateGroupIdPutRequest Group details to be updated. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateGroupIdPut(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nonnull CorporateGroupIdPutRequest corporateGroupIdPutRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateGroupIdPutRequest;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateGroupIdPut");
    }
    
    // verify the required parameter 'corporateGroupIdPutRequest' is set
    if (corporateGroupIdPutRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'corporateGroupIdPutRequest' when calling corporateGroupIdPut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/group/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create a group of sub-accounts
   * This endpoint allows to create a group of sub-accounts
   * @param corporateGroupPostRequest  (optional)
   * @return CorporateGroupPost201Response
   * @throws ApiException if fails to make API call
   */
  public CorporateGroupPost201Response corporateGroupPost(@jakarta.annotation.Nullable CorporateGroupPostRequest corporateGroupPostRequest) throws ApiException {
    return this.corporateGroupPost(corporateGroupPostRequest, Collections.emptyMap());
  }


  /**
   * Create a group of sub-accounts
   * This endpoint allows to create a group of sub-accounts
   * @param corporateGroupPostRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CorporateGroupPost201Response
   * @throws ApiException if fails to make API call
   */
  public CorporateGroupPost201Response corporateGroupPost(@jakarta.annotation.Nullable CorporateGroupPostRequest corporateGroupPostRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateGroupPostRequest;
    
    // create path and map variables
    String localVarPath = "/corporate/group";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CorporateGroupPost201Response> localVarReturnType = new TypeReference<CorporateGroupPost201Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete sub-account from group
   * This endpoint allows you to remove a sub-organization from a group.
   * @param groupId Group id (required)
   * @param corporateGroupUnlinkGroupIdSubAccountsPutRequest List of sub-account ids (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateGroupUnlinkGroupIdSubAccountsPut(@jakarta.annotation.Nonnull String groupId, @jakarta.annotation.Nonnull CorporateGroupUnlinkGroupIdSubAccountsPutRequest corporateGroupUnlinkGroupIdSubAccountsPutRequest) throws ApiException {
    this.corporateGroupUnlinkGroupIdSubAccountsPut(groupId, corporateGroupUnlinkGroupIdSubAccountsPutRequest, Collections.emptyMap());
  }


  /**
   * Delete sub-account from group
   * This endpoint allows you to remove a sub-organization from a group.
   * @param groupId Group id (required)
   * @param corporateGroupUnlinkGroupIdSubAccountsPutRequest List of sub-account ids (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateGroupUnlinkGroupIdSubAccountsPut(@jakarta.annotation.Nonnull String groupId, @jakarta.annotation.Nonnull CorporateGroupUnlinkGroupIdSubAccountsPutRequest corporateGroupUnlinkGroupIdSubAccountsPutRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateGroupUnlinkGroupIdSubAccountsPutRequest;
    
    // verify the required parameter 'groupId' is set
    if (groupId == null) {
      throw new ApiException(400, "Missing the required parameter 'groupId' when calling corporateGroupUnlinkGroupIdSubAccountsPut");
    }
    
    // verify the required parameter 'corporateGroupUnlinkGroupIdSubAccountsPutRequest' is set
    if (corporateGroupUnlinkGroupIdSubAccountsPutRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'corporateGroupUnlinkGroupIdSubAccountsPutRequest' when calling corporateGroupUnlinkGroupIdSubAccountsPut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/group/unlink/{groupId}/subAccounts"
      .replaceAll("\\{" + "groupId" + "\\}", apiClient.escapeString(apiClient.parameterToString(groupId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * List of all IPs
   * This endpoint allows you to retrieve the list of active IPs on your Admin account
   * @return List&lt;CorporateIpGet200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<CorporateIpGet200ResponseInner> corporateIpGet() throws ApiException {
    return this.corporateIpGet(Collections.emptyMap());
  }


  /**
   * List of all IPs
   * This endpoint allows you to retrieve the list of active IPs on your Admin account
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;CorporateIpGet200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<CorporateIpGet200ResponseInner> corporateIpGet(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/corporate/ip";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<List<CorporateIpGet200ResponseInner>> localVarReturnType = new TypeReference<List<CorporateIpGet200ResponseInner>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the details of requested master account
   * This endpoint will provide the details of the master account.
   * @return MasterDetailsResponse
   * @throws ApiException if fails to make API call
   */
  public MasterDetailsResponse corporateMasterAccountGet() throws ApiException {
    return this.corporateMasterAccountGet(Collections.emptyMap());
  }


  /**
   * Get the details of requested master account
   * This endpoint will provide the details of the master account.
   * @param additionalHeaders additionalHeaders for this call
   * @return MasterDetailsResponse
   * @throws ApiException if fails to make API call
   */
  public MasterDetailsResponse corporateMasterAccountGet(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/corporate/masterAccount";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<MasterDetailsResponse> localVarReturnType = new TypeReference<MasterDetailsResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Generate SSO token to access admin account
   * This endpoint generates an SSO token to authenticate and access the admin account using the endpoint https://account-app.brevo.com/account/login/corporate/sso/[token], where [token] will be replaced by the actual token.
   * @param corporateSsoTokenPostRequest  (optional)
   * @return GetSsoToken
   * @throws ApiException if fails to make API call
   */
  public GetSsoToken corporateSsoTokenPost(@jakarta.annotation.Nullable CorporateSsoTokenPostRequest corporateSsoTokenPostRequest) throws ApiException {
    return this.corporateSsoTokenPost(corporateSsoTokenPostRequest, Collections.emptyMap());
  }


  /**
   * Generate SSO token to access admin account
   * This endpoint generates an SSO token to authenticate and access the admin account using the endpoint https://account-app.brevo.com/account/login/corporate/sso/[token], where [token] will be replaced by the actual token.
   * @param corporateSsoTokenPostRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSsoToken
   * @throws ApiException if fails to make API call
   */
  public GetSsoToken corporateSsoTokenPost(@jakarta.annotation.Nullable CorporateSsoTokenPostRequest corporateSsoTokenPostRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateSsoTokenPostRequest;
    
    // create path and map variables
    String localVarPath = "/corporate/ssoToken";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSsoToken> localVarReturnType = new TypeReference<GetSsoToken>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of all the sub-accounts of the master account.
   * This endpoint will provide the list all the sub-accounts of the master account.
   * @param offset Index of the first sub-account in the page (required)
   * @param limit Number of sub-accounts to be displayed on each page (required)
   * @return SubAccountsResponse
   * @throws ApiException if fails to make API call
   */
  public SubAccountsResponse corporateSubAccountGet(@jakarta.annotation.Nonnull Integer offset, @jakarta.annotation.Nonnull Integer limit) throws ApiException {
    return this.corporateSubAccountGet(offset, limit, Collections.emptyMap());
  }


  /**
   * Get the list of all the sub-accounts of the master account.
   * This endpoint will provide the list all the sub-accounts of the master account.
   * @param offset Index of the first sub-account in the page (required)
   * @param limit Number of sub-accounts to be displayed on each page (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return SubAccountsResponse
   * @throws ApiException if fails to make API call
   */
  public SubAccountsResponse corporateSubAccountGet(@jakarta.annotation.Nonnull Integer offset, @jakarta.annotation.Nonnull Integer limit, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'offset' is set
    if (offset == null) {
      throw new ApiException(400, "Missing the required parameter 'offset' when calling corporateSubAccountGet");
    }
    
    // verify the required parameter 'limit' is set
    if (limit == null) {
      throw new ApiException(400, "Missing the required parameter 'limit' when calling corporateSubAccountGet");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<SubAccountsResponse> localVarReturnType = new TypeReference<SubAccountsResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Enable/disable sub-account application(s)
   * API endpoints for the Corporate owner to enable/disable applications on the sub-account
   * @param id Id of the sub-account organization (mandatory) (required)
   * @param subAccountAppsToggleRequest List of applications to activate or deactivate on a sub-account (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIdApplicationsTogglePut(@jakarta.annotation.Nonnull Long id, @jakarta.annotation.Nonnull SubAccountAppsToggleRequest subAccountAppsToggleRequest) throws ApiException {
    this.corporateSubAccountIdApplicationsTogglePut(id, subAccountAppsToggleRequest, Collections.emptyMap());
  }


  /**
   * Enable/disable sub-account application(s)
   * API endpoints for the Corporate owner to enable/disable applications on the sub-account
   * @param id Id of the sub-account organization (mandatory) (required)
   * @param subAccountAppsToggleRequest List of applications to activate or deactivate on a sub-account (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIdApplicationsTogglePut(@jakarta.annotation.Nonnull Long id, @jakarta.annotation.Nonnull SubAccountAppsToggleRequest subAccountAppsToggleRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = subAccountAppsToggleRequest;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdApplicationsTogglePut");
    }
    
    // verify the required parameter 'subAccountAppsToggleRequest' is set
    if (subAccountAppsToggleRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'subAccountAppsToggleRequest' when calling corporateSubAccountIdApplicationsTogglePut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/{id}/applications/toggle"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete a sub-account
   * 
   * @param id Id of the sub-account organization to be deleted (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIdDelete(@jakarta.annotation.Nonnull Long id) throws ApiException {
    this.corporateSubAccountIdDelete(id, Collections.emptyMap());
  }


  /**
   * Delete a sub-account
   * 
   * @param id Id of the sub-account organization to be deleted (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIdDelete(@jakarta.annotation.Nonnull Long id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdDelete");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get sub-account details
   * This endpoint will provide the details for the specified sub-account company
   * @param id Id of the sub-account organization (required)
   * @return SubAccountDetailsResponse
   * @throws ApiException if fails to make API call
   */
  public SubAccountDetailsResponse corporateSubAccountIdGet(@jakarta.annotation.Nonnull Long id) throws ApiException {
    return this.corporateSubAccountIdGet(id, Collections.emptyMap());
  }


  /**
   * Get sub-account details
   * This endpoint will provide the details for the specified sub-account company
   * @param id Id of the sub-account organization (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return SubAccountDetailsResponse
   * @throws ApiException if fails to make API call
   */
  public SubAccountDetailsResponse corporateSubAccountIdGet(@jakarta.annotation.Nonnull Long id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<SubAccountDetailsResponse> localVarReturnType = new TypeReference<SubAccountDetailsResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update sub-account plan
   * This endpoint will update the sub-account plan. On the Corporate solution new version v2, you can set an unlimited number of credits in your sub-organization. Please pass the value “-1\&quot; to set the consumable in unlimited mode.
   * @param id Id of the sub-account organization (required)
   * @param subAccountUpdatePlanRequest Values to update a sub-account plan (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIdPlanPut(@jakarta.annotation.Nonnull Long id, @jakarta.annotation.Nonnull SubAccountUpdatePlanRequest subAccountUpdatePlanRequest) throws ApiException {
    this.corporateSubAccountIdPlanPut(id, subAccountUpdatePlanRequest, Collections.emptyMap());
  }


  /**
   * Update sub-account plan
   * This endpoint will update the sub-account plan. On the Corporate solution new version v2, you can set an unlimited number of credits in your sub-organization. Please pass the value “-1\&quot; to set the consumable in unlimited mode.
   * @param id Id of the sub-account organization (required)
   * @param subAccountUpdatePlanRequest Values to update a sub-account plan (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIdPlanPut(@jakarta.annotation.Nonnull Long id, @jakarta.annotation.Nonnull SubAccountUpdatePlanRequest subAccountUpdatePlanRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = subAccountUpdatePlanRequest;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling corporateSubAccountIdPlanPut");
    }
    
    // verify the required parameter 'subAccountUpdatePlanRequest' is set
    if (subAccountUpdatePlanRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'subAccountUpdatePlanRequest' when calling corporateSubAccountIdPlanPut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/{id}/plan"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Associate an IP to sub-accounts
   * This endpoint allows to associate an IP to sub-accounts
   * @param corporateSubAccountIpAssociatePostRequest  (optional)
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object corporateSubAccountIpAssociatePost(@jakarta.annotation.Nullable CorporateSubAccountIpAssociatePostRequest corporateSubAccountIpAssociatePostRequest) throws ApiException {
    return this.corporateSubAccountIpAssociatePost(corporateSubAccountIpAssociatePostRequest, Collections.emptyMap());
  }


  /**
   * Associate an IP to sub-accounts
   * This endpoint allows to associate an IP to sub-accounts
   * @param corporateSubAccountIpAssociatePostRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Object
   * @throws ApiException if fails to make API call
   */
  public Object corporateSubAccountIpAssociatePost(@jakarta.annotation.Nullable CorporateSubAccountIpAssociatePostRequest corporateSubAccountIpAssociatePostRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateSubAccountIpAssociatePostRequest;
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/ip/associate";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Object> localVarReturnType = new TypeReference<Object>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Dissociate an IP to sub-accounts
   * This endpoint allows to dissociate an IP from sub-accounts
   * @param corporateSubAccountIpDissociatePutRequest  (optional)
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIpDissociatePut(@jakarta.annotation.Nullable CorporateSubAccountIpDissociatePutRequest corporateSubAccountIpDissociatePutRequest) throws ApiException {
    this.corporateSubAccountIpDissociatePut(corporateSubAccountIpDissociatePutRequest, Collections.emptyMap());
  }


  /**
   * Dissociate an IP to sub-accounts
   * This endpoint allows to dissociate an IP from sub-accounts
   * @param corporateSubAccountIpDissociatePutRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountIpDissociatePut(@jakarta.annotation.Nullable CorporateSubAccountIpDissociatePutRequest corporateSubAccountIpDissociatePutRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateSubAccountIpDissociatePutRequest;
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/ip/dissociate";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create an API key for a sub-account
   * This endpoint will generate an API v3 key for a sub account
   * @param corporateSubAccountKeyPostRequest  (optional)
   * @return CreateApiKeyResponse
   * @throws ApiException if fails to make API call
   */
  public CreateApiKeyResponse corporateSubAccountKeyPost(@jakarta.annotation.Nullable CorporateSubAccountKeyPostRequest corporateSubAccountKeyPostRequest) throws ApiException {
    return this.corporateSubAccountKeyPost(corporateSubAccountKeyPostRequest, Collections.emptyMap());
  }


  /**
   * Create an API key for a sub-account
   * This endpoint will generate an API v3 key for a sub account
   * @param corporateSubAccountKeyPostRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateApiKeyResponse
   * @throws ApiException if fails to make API call
   */
  public CreateApiKeyResponse corporateSubAccountKeyPost(@jakarta.annotation.Nullable CorporateSubAccountKeyPostRequest corporateSubAccountKeyPostRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateSubAccountKeyPostRequest;
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/key";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateApiKeyResponse> localVarReturnType = new TypeReference<CreateApiKeyResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a new sub-account under a master account.
   * This endpoint will create a new sub-account under a master account
   * @param createSubAccount Request body with sub-account organization name (required)
   * @return CreateSubAccountResponse
   * @throws ApiException if fails to make API call
   */
  public CreateSubAccountResponse corporateSubAccountPost(@jakarta.annotation.Nonnull CreateSubAccount createSubAccount) throws ApiException {
    return this.corporateSubAccountPost(createSubAccount, Collections.emptyMap());
  }


  /**
   * Create a new sub-account under a master account.
   * This endpoint will create a new sub-account under a master account
   * @param createSubAccount Request body with sub-account organization name (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateSubAccountResponse
   * @throws ApiException if fails to make API call
   */
  public CreateSubAccountResponse corporateSubAccountPost(@jakarta.annotation.Nonnull CreateSubAccount createSubAccount, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createSubAccount;
    
    // verify the required parameter 'createSubAccount' is set
    if (createSubAccount == null) {
      throw new ApiException(400, "Missing the required parameter 'createSubAccount' when calling corporateSubAccountPost");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateSubAccountResponse> localVarReturnType = new TypeReference<CreateSubAccountResponse>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Generate SSO token to access sub-account
   * This endpoint generates an sso token to authenticate and access a sub-account of the master using the account endpoint https://account-app.brevo.com/account/login/sub-account/sso/[token], where [token] will be replaced by the actual token.
   * @param corporateSubAccountSsoTokenPostRequest  (optional)
   * @return GetSsoToken
   * @throws ApiException if fails to make API call
   */
  public GetSsoToken corporateSubAccountSsoTokenPost(@jakarta.annotation.Nullable CorporateSubAccountSsoTokenPostRequest corporateSubAccountSsoTokenPostRequest) throws ApiException {
    return this.corporateSubAccountSsoTokenPost(corporateSubAccountSsoTokenPostRequest, Collections.emptyMap());
  }


  /**
   * Generate SSO token to access sub-account
   * This endpoint generates an sso token to authenticate and access a sub-account of the master using the account endpoint https://account-app.brevo.com/account/login/sub-account/sso/[token], where [token] will be replaced by the actual token.
   * @param corporateSubAccountSsoTokenPostRequest  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSsoToken
   * @throws ApiException if fails to make API call
   */
  public GetSsoToken corporateSubAccountSsoTokenPost(@jakarta.annotation.Nullable CorporateSubAccountSsoTokenPostRequest corporateSubAccountSsoTokenPostRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateSubAccountSsoTokenPostRequest;
    
    // create path and map variables
    String localVarPath = "/corporate/subAccount/ssoToken";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSsoToken> localVarReturnType = new TypeReference<GetSsoToken>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update sub-accounts plan
   * This endpoint will update multiple sub-accounts plan. On the Corporate solution new version v2, you can set an unlimited number of credits in your sub-organization. Please pass the value “-1\&quot; to set the consumable in unlimited mode.
   * @param subAccountsUpdatePlanRequest Values to update sub-accounts plan (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountsPlanPut(@jakarta.annotation.Nonnull SubAccountsUpdatePlanRequest subAccountsUpdatePlanRequest) throws ApiException {
    this.corporateSubAccountsPlanPut(subAccountsUpdatePlanRequest, Collections.emptyMap());
  }


  /**
   * Update sub-accounts plan
   * This endpoint will update multiple sub-accounts plan. On the Corporate solution new version v2, you can set an unlimited number of credits in your sub-organization. Please pass the value “-1\&quot; to set the consumable in unlimited mode.
   * @param subAccountsUpdatePlanRequest Values to update sub-accounts plan (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateSubAccountsPlanPut(@jakarta.annotation.Nonnull SubAccountsUpdatePlanRequest subAccountsUpdatePlanRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = subAccountsUpdatePlanRequest;
    
    // verify the required parameter 'subAccountsUpdatePlanRequest' is set
    if (subAccountsUpdatePlanRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'subAccountsUpdatePlanRequest' when calling corporateSubAccountsPlanPut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/subAccounts/plan";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Change admin user permissions
   * This endpoint will allow you to change the permissions of Admin users of your Admin account
   * @param email Email address of Admin user (required)
   * @param corporateUserEmailPermissionsPutRequest Values to update an admin user permissions (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateUserEmailPermissionsPut(@jakarta.annotation.Nonnull String email, @jakarta.annotation.Nonnull CorporateUserEmailPermissionsPutRequest corporateUserEmailPermissionsPutRequest) throws ApiException {
    this.corporateUserEmailPermissionsPut(email, corporateUserEmailPermissionsPutRequest, Collections.emptyMap());
  }


  /**
   * Change admin user permissions
   * This endpoint will allow you to change the permissions of Admin users of your Admin account
   * @param email Email address of Admin user (required)
   * @param corporateUserEmailPermissionsPutRequest Values to update an admin user permissions (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateUserEmailPermissionsPut(@jakarta.annotation.Nonnull String email, @jakarta.annotation.Nonnull CorporateUserEmailPermissionsPutRequest corporateUserEmailPermissionsPutRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = corporateUserEmailPermissionsPutRequest;
    
    // verify the required parameter 'email' is set
    if (email == null) {
      throw new ApiException(400, "Missing the required parameter 'email' when calling corporateUserEmailPermissionsPut");
    }
    
    // verify the required parameter 'corporateUserEmailPermissionsPutRequest' is set
    if (corporateUserEmailPermissionsPutRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'corporateUserEmailPermissionsPutRequest' when calling corporateUserEmailPermissionsPut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/user/{email}/permissions"
      .replaceAll("\\{" + "email" + "\\}", apiClient.escapeString(apiClient.parameterToString(email)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Resend / cancel admin user invitation
   * This endpoint will allow the user to: - Resend an admin user invitation - Cancel an admin user invitation 
   * @param action Action to be performed (cancel / resend) (required)
   * @param email Email address of the recipient (required)
   * @return CorporateUserInvitationActionEmailPut200Response
   * @throws ApiException if fails to make API call
   */
  public CorporateUserInvitationActionEmailPut200Response corporateUserInvitationActionEmailPut(@jakarta.annotation.Nonnull String action, @jakarta.annotation.Nonnull String email) throws ApiException {
    return this.corporateUserInvitationActionEmailPut(action, email, Collections.emptyMap());
  }


  /**
   * Resend / cancel admin user invitation
   * This endpoint will allow the user to: - Resend an admin user invitation - Cancel an admin user invitation 
   * @param action Action to be performed (cancel / resend) (required)
   * @param email Email address of the recipient (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CorporateUserInvitationActionEmailPut200Response
   * @throws ApiException if fails to make API call
   */
  public CorporateUserInvitationActionEmailPut200Response corporateUserInvitationActionEmailPut(@jakarta.annotation.Nonnull String action, @jakarta.annotation.Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'action' is set
    if (action == null) {
      throw new ApiException(400, "Missing the required parameter 'action' when calling corporateUserInvitationActionEmailPut");
    }
    
    // verify the required parameter 'email' is set
    if (email == null) {
      throw new ApiException(400, "Missing the required parameter 'email' when calling corporateUserInvitationActionEmailPut");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/user/invitation/{action}/{email}"
      .replaceAll("\\{" + "action" + "\\}", apiClient.escapeString(apiClient.parameterToString(action)))
      .replaceAll("\\{" + "email" + "\\}", apiClient.escapeString(apiClient.parameterToString(email)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CorporateUserInvitationActionEmailPut200Response> localVarReturnType = new TypeReference<CorporateUserInvitationActionEmailPut200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Revoke an admin user
   * This endpoint allows to revoke/remove an invited member of your Admin account
   * @param email Email of the invited user (required)
   * @throws ApiException if fails to make API call
   */
  public void corporateUserRevokeEmailDelete(@jakarta.annotation.Nonnull String email) throws ApiException {
    this.corporateUserRevokeEmailDelete(email, Collections.emptyMap());
  }


  /**
   * Revoke an admin user
   * This endpoint allows to revoke/remove an invited member of your Admin account
   * @param email Email of the invited user (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void corporateUserRevokeEmailDelete(@jakarta.annotation.Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'email' is set
    if (email == null) {
      throw new ApiException(400, "Missing the required parameter 'email' when calling corporateUserRevokeEmailDelete");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/user/revoke/{email}"
      .replaceAll("\\{" + "email" + "\\}", apiClient.escapeString(apiClient.parameterToString(email)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get user activity logs
   * 
   * @param startDate Mandatory if endDate is used. Enter start date in UTC date (YYYY-MM-DD) format to filter the activity in your account. Maximum time period that can be selected is one month. Additionally, you can retrieve activity logs from the past 12 months from the date of your search. (optional)
   * @param endDate Mandatory if startDate is used. Enter end date in UTC date (YYYY-MM-DD) format to filter the activity in your account. Maximum time period that can be selected is one month. (optional)
   * @param email Enter the user&#39;s email address to filter their activity in the account. (optional)
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document in the page. (optional, default to 0)
   * @return GetAccountActivity
   * @throws ApiException if fails to make API call
   */
  public GetAccountActivity getAccountActivity(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable String email, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset) throws ApiException {
    return this.getAccountActivity(startDate, endDate, email, limit, offset, Collections.emptyMap());
  }


  /**
   * Get user activity logs
   * 
   * @param startDate Mandatory if endDate is used. Enter start date in UTC date (YYYY-MM-DD) format to filter the activity in your account. Maximum time period that can be selected is one month. Additionally, you can retrieve activity logs from the past 12 months from the date of your search. (optional)
   * @param endDate Mandatory if startDate is used. Enter end date in UTC date (YYYY-MM-DD) format to filter the activity in your account. Maximum time period that can be selected is one month. (optional)
   * @param email Enter the user&#39;s email address to filter their activity in the account. (optional)
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document in the page. (optional, default to 0)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetAccountActivity
   * @throws ApiException if fails to make API call
   */
  public GetAccountActivity getAccountActivity(@jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable String email, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/organization/activities";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("email", email));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetAccountActivity> localVarReturnType = new TypeReference<GetAccountActivity>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of all admin users
   * This endpoint allows you to list all Admin users of your Admin account
   * @return GetCorporateInvitedUsersList
   * @throws ApiException if fails to make API call
   */
  public GetCorporateInvitedUsersList getCorporateInvitedUsersList() throws ApiException {
    return this.getCorporateInvitedUsersList(Collections.emptyMap());
  }


  /**
   * Get the list of all admin users
   * This endpoint allows you to list all Admin users of your Admin account
   * @param additionalHeaders additionalHeaders for this call
   * @return GetCorporateInvitedUsersList
   * @throws ApiException if fails to make API call
   */
  public GetCorporateInvitedUsersList getCorporateInvitedUsersList(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/corporate/invited/users";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetCorporateInvitedUsersList> localVarReturnType = new TypeReference<GetCorporateInvitedUsersList>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Check admin user permissions
   * This endpoint will provide the list of admin user permissions
   * @param email Email of the invited user. (required)
   * @return GetCorporateUserPermission
   * @throws ApiException if fails to make API call
   */
  public GetCorporateUserPermission getCorporateUserPermission(@jakarta.annotation.Nonnull String email) throws ApiException {
    return this.getCorporateUserPermission(email, Collections.emptyMap());
  }


  /**
   * Check admin user permissions
   * This endpoint will provide the list of admin user permissions
   * @param email Email of the invited user. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetCorporateUserPermission
   * @throws ApiException if fails to make API call
   */
  public GetCorporateUserPermission getCorporateUserPermission(@jakarta.annotation.Nonnull String email, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'email' is set
    if (email == null) {
      throw new ApiException(400, "Missing the required parameter 'email' when calling getCorporateUserPermission");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/user/{email}/permissions"
      .replaceAll("\\{" + "email" + "\\}", apiClient.escapeString(apiClient.parameterToString(email)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetCorporateUserPermission> localVarReturnType = new TypeReference<GetCorporateUserPermission>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of groups
   * This endpoint allows you to list all groups created on your Admin account.
   * @return List&lt;GetSubAccountGroups200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<GetSubAccountGroups200ResponseInner> getSubAccountGroups() throws ApiException {
    return this.getSubAccountGroups(Collections.emptyMap());
  }


  /**
   * Get the list of groups
   * This endpoint allows you to list all groups created on your Admin account.
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;GetSubAccountGroups200ResponseInner&gt;
   * @throws ApiException if fails to make API call
   */
  public List<GetSubAccountGroups200ResponseInner> getSubAccountGroups(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/corporate/groups";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<List<GetSubAccountGroups200ResponseInner>> localVarReturnType = new TypeReference<List<GetSubAccountGroups200ResponseInner>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send invitation to an admin user
   * &#x60;This endpoint allows you to invite a member to manage the Admin account  Features and their respective permissions are as below:  - &#x60;my_plan&#x60;:   - \&quot;all\&quot; - &#x60;api&#x60;:   - \&quot;none\&quot; - &#x60;user_management&#x60;:   - \&quot;all\&quot; - &#x60;app_management&#x60; | Not available in ENTv2:   - \&quot;all\&quot; - &#x60;sub_organization_groups&#x60;   - \&quot;create\&quot;   - \&quot;edit_delete\&quot; - &#x60;create_sub_organizations&#x60;   - \&quot;all\&quot; - &#x60;manage_sub_organizations&#x60;   - \&quot;all\&quot; - &#x60;analytics&#x60;   - \&quot;download_data\&quot;   - \&quot;create_alerts\&quot;   - \&quot;my_looks\&quot;   - \&quot;explore_create\&quot; - &#x60;security&#x60;   - \&quot;all\&quot;  **Note**: - If &#x60;all_features_access: false&#x60; then only privileges are required otherwise if &#x60;true&#x60; then it&#39;s assumed that all permissions will be there for the invited admin user. 
   * @param inviteAdminUser Payload to send an invitation (required)
   * @return CorporateGroupPost201Response
   * @throws ApiException if fails to make API call
   */
  public CorporateGroupPost201Response inviteAdminUser(@jakarta.annotation.Nonnull InviteAdminUser inviteAdminUser) throws ApiException {
    return this.inviteAdminUser(inviteAdminUser, Collections.emptyMap());
  }


  /**
   * Send invitation to an admin user
   * &#x60;This endpoint allows you to invite a member to manage the Admin account  Features and their respective permissions are as below:  - &#x60;my_plan&#x60;:   - \&quot;all\&quot; - &#x60;api&#x60;:   - \&quot;none\&quot; - &#x60;user_management&#x60;:   - \&quot;all\&quot; - &#x60;app_management&#x60; | Not available in ENTv2:   - \&quot;all\&quot; - &#x60;sub_organization_groups&#x60;   - \&quot;create\&quot;   - \&quot;edit_delete\&quot; - &#x60;create_sub_organizations&#x60;   - \&quot;all\&quot; - &#x60;manage_sub_organizations&#x60;   - \&quot;all\&quot; - &#x60;analytics&#x60;   - \&quot;download_data\&quot;   - \&quot;create_alerts\&quot;   - \&quot;my_looks\&quot;   - \&quot;explore_create\&quot; - &#x60;security&#x60;   - \&quot;all\&quot;  **Note**: - If &#x60;all_features_access: false&#x60; then only privileges are required otherwise if &#x60;true&#x60; then it&#39;s assumed that all permissions will be there for the invited admin user. 
   * @param inviteAdminUser Payload to send an invitation (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CorporateGroupPost201Response
   * @throws ApiException if fails to make API call
   */
  public CorporateGroupPost201Response inviteAdminUser(@jakarta.annotation.Nonnull InviteAdminUser inviteAdminUser, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = inviteAdminUser;
    
    // verify the required parameter 'inviteAdminUser' is set
    if (inviteAdminUser == null) {
      throw new ApiException(400, "Missing the required parameter 'inviteAdminUser' when calling inviteAdminUser");
    }
    
    // create path and map variables
    String localVarPath = "/corporate/user/invitation/send";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CorporateGroupPost201Response> localVarReturnType = new TypeReference<CorporateGroupPost201Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
