/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.ErrorModel;
import java.io.File;
import software.xdev.brevo.model.FileData;
import software.xdev.brevo.model.FileDownloadableLink;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class FilesApi extends BaseApi {

  public FilesApi() {
    super(Configuration.getDefaultApiClient());
  }

  public FilesApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Get all files
   * 
   * @param entity Filter by file entity type (optional)
   * @param entityIds Filter by file entity IDs (optional)
   * @param dateFrom dateFrom to date range filter type (timestamp in milliseconds) (optional)
   * @param dateTo dateTo to date range filter type (timestamp in milliseconds) (optional)
   * @param offset Index of the first document of the page (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param sort Sort the results in the ascending/descending order. Default order is **descending** by creation if &#x60;sort&#x60; is not passed (optional)
   * @return List&lt;FileData&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileData> crmFilesGet(@jakarta.annotation.Nullable String entity, @jakarta.annotation.Nullable String entityIds, @jakarta.annotation.Nullable Integer dateFrom, @jakarta.annotation.Nullable Integer dateTo, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.crmFilesGet(entity, entityIds, dateFrom, dateTo, offset, limit, sort, Collections.emptyMap());
  }


  /**
   * Get all files
   * 
   * @param entity Filter by file entity type (optional)
   * @param entityIds Filter by file entity IDs (optional)
   * @param dateFrom dateFrom to date range filter type (timestamp in milliseconds) (optional)
   * @param dateTo dateTo to date range filter type (timestamp in milliseconds) (optional)
   * @param offset Index of the first document of the page (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param sort Sort the results in the ascending/descending order. Default order is **descending** by creation if &#x60;sort&#x60; is not passed (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return List&lt;FileData&gt;
   * @throws ApiException if fails to make API call
   */
  public List<FileData> crmFilesGet(@jakarta.annotation.Nullable String entity, @jakarta.annotation.Nullable String entityIds, @jakarta.annotation.Nullable Integer dateFrom, @jakarta.annotation.Nullable Integer dateTo, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/crm/files";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("entity", entity));
    localVarQueryParams.addAll(apiClient.parameterToPair("entityIds", entityIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateFrom", dateFrom));
    localVarQueryParams.addAll(apiClient.parameterToPair("dateTo", dateTo));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<List<FileData>> localVarReturnType = new TypeReference<List<FileData>>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get file details
   * 
   * @param id File id to get file data. (required)
   * @return FileData
   * @throws ApiException if fails to make API call
   */
  public FileData crmFilesIdDataGet(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.crmFilesIdDataGet(id, Collections.emptyMap());
  }


  /**
   * Get file details
   * 
   * @param id File id to get file data. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return FileData
   * @throws ApiException if fails to make API call
   */
  public FileData crmFilesIdDataGet(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmFilesIdDataGet");
    }
    
    // create path and map variables
    String localVarPath = "/crm/files/{id}/data"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<FileData> localVarReturnType = new TypeReference<FileData>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a file
   * 
   * @param id File id to delete. (required)
   * @throws ApiException if fails to make API call
   */
  public void crmFilesIdDelete(@jakarta.annotation.Nonnull String id) throws ApiException {
    this.crmFilesIdDelete(id, Collections.emptyMap());
  }


  /**
   * Delete a file
   * 
   * @param id File id to delete. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void crmFilesIdDelete(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmFilesIdDelete");
    }
    
    // create path and map variables
    String localVarPath = "/crm/files/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Download a file
   * 
   * @param id File id to download. (required)
   * @return FileDownloadableLink
   * @throws ApiException if fails to make API call
   */
  public FileDownloadableLink crmFilesIdGet(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.crmFilesIdGet(id, Collections.emptyMap());
  }


  /**
   * Download a file
   * 
   * @param id File id to download. (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return FileDownloadableLink
   * @throws ApiException if fails to make API call
   */
  public FileDownloadableLink crmFilesIdGet(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling crmFilesIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/crm/files/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<FileDownloadableLink> localVarReturnType = new TypeReference<FileDownloadableLink>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Upload a file
   * 
   * @param _file File data to create a file. (required)
   * @param dealId  (optional)
   * @param contactId  (optional)
   * @param companyId  (optional)
   * @return FileData
   * @throws ApiException if fails to make API call
   */
  public FileData crmFilesPost(@jakarta.annotation.Nonnull File _file, @jakarta.annotation.Nullable String dealId, @jakarta.annotation.Nullable Long contactId, @jakarta.annotation.Nullable String companyId) throws ApiException {
    return this.crmFilesPost(_file, dealId, contactId, companyId, Collections.emptyMap());
  }


  /**
   * Upload a file
   * 
   * @param _file File data to create a file. (required)
   * @param dealId  (optional)
   * @param contactId  (optional)
   * @param companyId  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return FileData
   * @throws ApiException if fails to make API call
   */
  public FileData crmFilesPost(@jakarta.annotation.Nonnull File _file, @jakarta.annotation.Nullable String dealId, @jakarta.annotation.Nullable Long contactId, @jakarta.annotation.Nullable String companyId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter '_file' is set
    if (_file == null) {
      throw new ApiException(400, "Missing the required parameter '_file' when calling crmFilesPost");
    }
    
    // create path and map variables
    String localVarPath = "/crm/files";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    if (_file != null)
      localVarFormParams.put("file", _file);
if (dealId != null)
      localVarFormParams.put("dealId", dealId);
if (contactId != null)
      localVarFormParams.put("contactId", contactId);
if (companyId != null)
      localVarFormParams.put("companyId", companyId);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<FileData> localVarReturnType = new TypeReference<FileData>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "multipart/form-data"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
