/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CreateExternalFeed;
import software.xdev.brevo.model.CreateExternalFeed201Response;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetAllExternalFeeds;
import software.xdev.brevo.model.GetExternalFeedByUUID;
import java.time.LocalDate;
import software.xdev.brevo.model.UpdateExternalFeed;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ExternalFeedsApi extends BaseApi {

  public ExternalFeedsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public ExternalFeedsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create an external feed
   * This endpoint will create an external feed.
   * @param createExternalFeed Values to create a feed (required)
   * @return CreateExternalFeed201Response
   * @throws ApiException if fails to make API call
   */
  public CreateExternalFeed201Response createExternalFeed(@jakarta.annotation.Nonnull CreateExternalFeed createExternalFeed) throws ApiException {
    return this.createExternalFeed(createExternalFeed, Collections.emptyMap());
  }


  /**
   * Create an external feed
   * This endpoint will create an external feed.
   * @param createExternalFeed Values to create a feed (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateExternalFeed201Response
   * @throws ApiException if fails to make API call
   */
  public CreateExternalFeed201Response createExternalFeed(@jakarta.annotation.Nonnull CreateExternalFeed createExternalFeed, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createExternalFeed;
    
    // verify the required parameter 'createExternalFeed' is set
    if (createExternalFeed == null) {
      throw new ApiException(400, "Missing the required parameter 'createExternalFeed' when calling createExternalFeed");
    }
    
    // create path and map variables
    String localVarPath = "/feeds";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateExternalFeed201Response> localVarReturnType = new TypeReference<CreateExternalFeed201Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete an external feed
   * This endpoint will delete an external feed.
   * @param uuid UUID of the feed to delete (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteExternalFeed(@jakarta.annotation.Nonnull String uuid) throws ApiException {
    this.deleteExternalFeed(uuid, Collections.emptyMap());
  }


  /**
   * Delete an external feed
   * This endpoint will delete an external feed.
   * @param uuid UUID of the feed to delete (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteExternalFeed(@jakarta.annotation.Nonnull String uuid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uuid' is set
    if (uuid == null) {
      throw new ApiException(400, "Missing the required parameter 'uuid' when calling deleteExternalFeed");
    }
    
    // create path and map variables
    String localVarPath = "/feeds/{uuid}"
      .replaceAll("\\{" + "uuid" + "\\}", apiClient.escapeString(apiClient.parameterToString(uuid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Fetch all external feeds
   * This endpoint can fetch all created external feeds.
   * @param search Can be used to filter records by search keyword on feed name (optional)
   * @param startDate Mandatory if &#x60;endDate&#x60; is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older than current date. (optional)
   * @param endDate Mandatory if &#x60;startDate&#x60; is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed. (optional, default to desc)
   * @param authType Filter the records by &#x60;authType&#x60; of the feed. (optional)
   * @param limit Number of documents returned per page. (optional, default to 50)
   * @param offset Index of the first document on the page. (optional, default to 0)
   * @return GetAllExternalFeeds
   * @throws ApiException if fails to make API call
   */
  public GetAllExternalFeeds getAllExternalFeeds(@jakarta.annotation.Nullable String search, @jakarta.annotation.Nullable LocalDate startDate, @jakarta.annotation.Nullable LocalDate endDate, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String authType, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset) throws ApiException {
    return this.getAllExternalFeeds(search, startDate, endDate, sort, authType, limit, offset, Collections.emptyMap());
  }


  /**
   * Fetch all external feeds
   * This endpoint can fetch all created external feeds.
   * @param search Can be used to filter records by search keyword on feed name (optional)
   * @param startDate Mandatory if &#x60;endDate&#x60; is used. Starting date (YYYY-MM-DD) from which you want to fetch the list. Can be maximum 30 days older than current date. (optional)
   * @param endDate Mandatory if &#x60;startDate&#x60; is used. Ending date (YYYY-MM-DD) till which you want to fetch the list. Maximum time period that can be selected is one month. (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed. (optional, default to desc)
   * @param authType Filter the records by &#x60;authType&#x60; of the feed. (optional)
   * @param limit Number of documents returned per page. (optional, default to 50)
   * @param offset Index of the first document on the page. (optional, default to 0)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetAllExternalFeeds
   * @throws ApiException if fails to make API call
   */
  public GetAllExternalFeeds getAllExternalFeeds(@jakarta.annotation.Nullable String search, @jakarta.annotation.Nullable LocalDate startDate, @jakarta.annotation.Nullable LocalDate endDate, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String authType, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/feeds";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("search", search));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("authType", authType));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetAllExternalFeeds> localVarReturnType = new TypeReference<GetAllExternalFeeds>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get an external feed by UUID
   * This endpoint will update an external feed.
   * @param uuid UUID of the feed to fetch (required)
   * @return GetExternalFeedByUUID
   * @throws ApiException if fails to make API call
   */
  public GetExternalFeedByUUID getExternalFeedByUUID(@jakarta.annotation.Nonnull String uuid) throws ApiException {
    return this.getExternalFeedByUUID(uuid, Collections.emptyMap());
  }


  /**
   * Get an external feed by UUID
   * This endpoint will update an external feed.
   * @param uuid UUID of the feed to fetch (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetExternalFeedByUUID
   * @throws ApiException if fails to make API call
   */
  public GetExternalFeedByUUID getExternalFeedByUUID(@jakarta.annotation.Nonnull String uuid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'uuid' is set
    if (uuid == null) {
      throw new ApiException(400, "Missing the required parameter 'uuid' when calling getExternalFeedByUUID");
    }
    
    // create path and map variables
    String localVarPath = "/feeds/{uuid}"
      .replaceAll("\\{" + "uuid" + "\\}", apiClient.escapeString(apiClient.parameterToString(uuid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetExternalFeedByUUID> localVarReturnType = new TypeReference<GetExternalFeedByUUID>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update an external feed
   * This endpoint will update an external feed.
   * @param uuid UUID of the feed to update (required)
   * @param updateExternalFeed Values to update a feed (required)
   * @throws ApiException if fails to make API call
   */
  public void updateExternalFeed(@jakarta.annotation.Nonnull String uuid, @jakarta.annotation.Nonnull UpdateExternalFeed updateExternalFeed) throws ApiException {
    this.updateExternalFeed(uuid, updateExternalFeed, Collections.emptyMap());
  }


  /**
   * Update an external feed
   * This endpoint will update an external feed.
   * @param uuid UUID of the feed to update (required)
   * @param updateExternalFeed Values to update a feed (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateExternalFeed(@jakarta.annotation.Nonnull String uuid, @jakarta.annotation.Nonnull UpdateExternalFeed updateExternalFeed, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateExternalFeed;
    
    // verify the required parameter 'uuid' is set
    if (uuid == null) {
      throw new ApiException(400, "Missing the required parameter 'uuid' when calling updateExternalFeed");
    }
    
    // verify the required parameter 'updateExternalFeed' is set
    if (updateExternalFeed == null) {
      throw new ApiException(400, "Missing the required parameter 'updateExternalFeed' when calling updateExternalFeed");
    }
    
    // create path and map variables
    String localVarPath = "/feeds/{uuid}"
      .replaceAll("\\{" + "uuid" + "\\}", apiClient.escapeString(apiClient.parameterToString(uuid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
