/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.AbTestCampaignResult;
import software.xdev.brevo.model.CreateEmailCampaign;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.EmailExportRecipients;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetEmailCampaign;
import software.xdev.brevo.model.GetEmailCampaigns;
import software.xdev.brevo.model.GetSharedTemplateUrl;
import software.xdev.brevo.model.PostSendFailed;
import software.xdev.brevo.model.SendReport;
import software.xdev.brevo.model.SendTestEmail;
import software.xdev.brevo.model.UpdateCampaignStatus;
import software.xdev.brevo.model.UpdateEmailCampaign;
import software.xdev.brevo.model.UploadImageModel;
import software.xdev.brevo.model.UploadImageToGallery;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class EmailCampaignsApi extends BaseApi {

  public EmailCampaignsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public EmailCampaignsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create an email campaign
   * 
   * @param createEmailCampaign Values to create a campaign (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createEmailCampaign(@jakarta.annotation.Nonnull CreateEmailCampaign createEmailCampaign) throws ApiException {
    return this.createEmailCampaign(createEmailCampaign, Collections.emptyMap());
  }


  /**
   * Create an email campaign
   * 
   * @param createEmailCampaign Values to create a campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createEmailCampaign(@jakarta.annotation.Nonnull CreateEmailCampaign createEmailCampaign, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createEmailCampaign;
    
    // verify the required parameter 'createEmailCampaign' is set
    if (createEmailCampaign == null) {
      throw new ApiException(400, "Missing the required parameter 'createEmailCampaign' when calling createEmailCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete an email campaign
   * 
   * @param campaignId id of the campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteEmailCampaign(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    this.deleteEmailCampaign(campaignId, Collections.emptyMap());
  }


  /**
   * Delete an email campaign
   * 
   * @param campaignId id of the campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteEmailCampaign(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling deleteEmailCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Export the recipients of an email campaign
   * 
   * @param campaignId Id of the campaign (required)
   * @param emailExportRecipients Values to send for a recipient export request (optional)
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId emailExportRecipients(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nullable EmailExportRecipients emailExportRecipients) throws ApiException {
    return this.emailExportRecipients(campaignId, emailExportRecipients, Collections.emptyMap());
  }


  /**
   * Export the recipients of an email campaign
   * 
   * @param campaignId Id of the campaign (required)
   * @param emailExportRecipients Values to send for a recipient export request (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId emailExportRecipients(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nullable EmailExportRecipients emailExportRecipients, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = emailExportRecipients;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling emailExportRecipients");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/exportRecipients"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get an A/B test email campaign results
   * Obtain winning version of an A/B test email campaign
   * @param campaignId Id of the A/B test campaign (required)
   * @return AbTestCampaignResult
   * @throws ApiException if fails to make API call
   */
  public AbTestCampaignResult getAbTestCampaignResult(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    return this.getAbTestCampaignResult(campaignId, Collections.emptyMap());
  }


  /**
   * Get an A/B test email campaign results
   * Obtain winning version of an A/B test email campaign
   * @param campaignId Id of the A/B test campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return AbTestCampaignResult
   * @throws ApiException if fails to make API call
   */
  public AbTestCampaignResult getAbTestCampaignResult(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getAbTestCampaignResult");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/abTestCampaignResult"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<AbTestCampaignResult> localVarReturnType = new TypeReference<AbTestCampaignResult>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get an email campaign report
   * 
   * @param campaignId Id of the campaign (required)
   * @param statistics Filter on the type of statistics required. Example **globalStats** value will only fetch globalStats info of the campaign in returned response. (optional)
   * @return GetEmailCampaign
   * @throws ApiException if fails to make API call
   */
  public GetEmailCampaign getEmailCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nullable String statistics) throws ApiException {
    return this.getEmailCampaign(campaignId, statistics, Collections.emptyMap());
  }


  /**
   * Get an email campaign report
   * 
   * @param campaignId Id of the campaign (required)
   * @param statistics Filter on the type of statistics required. Example **globalStats** value will only fetch globalStats info of the campaign in returned response. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetEmailCampaign
   * @throws ApiException if fails to make API call
   */
  public GetEmailCampaign getEmailCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nullable String statistics, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getEmailCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("statistics", statistics));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetEmailCampaign> localVarReturnType = new TypeReference<GetEmailCampaign>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Return all your created email campaigns
   * 
   * @param type Filter on the type of the campaigns (optional)
   * @param status Filter on the status of the campaign (optional)
   * @param statistics Filter on the type of statistics required. Example **globalStats** value will only fetch globalStats info of the campaign in returned response.This option only returns data for events occurred in the last 6 months.For older campaigns, it’s advisable to use the **Get Campaign Report** endpoint. (optional)
   * @param startDate **Mandatory if endDate is used**. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent email campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent email campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param excludeHtmlContent Use this flag to exclude htmlContent from the response body. If set to **true**, htmlContent field will be returned as empty string in the response body (optional)
   * @return GetEmailCampaigns
   * @throws ApiException if fails to make API call
   */
  public GetEmailCampaigns getEmailCampaigns(@jakarta.annotation.Nullable String type, @jakarta.annotation.Nullable String status, @jakarta.annotation.Nullable String statistics, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable Boolean excludeHtmlContent) throws ApiException {
    return this.getEmailCampaigns(type, status, statistics, startDate, endDate, limit, offset, sort, excludeHtmlContent, Collections.emptyMap());
  }


  /**
   * Return all your created email campaigns
   * 
   * @param type Filter on the type of the campaigns (optional)
   * @param status Filter on the status of the campaign (optional)
   * @param statistics Filter on the type of statistics required. Example **globalStats** value will only fetch globalStats info of the campaign in returned response.This option only returns data for events occurred in the last 6 months.For older campaigns, it’s advisable to use the **Get Campaign Report** endpoint. (optional)
   * @param startDate **Mandatory if endDate is used**. Starting (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent email campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to filter the sent email campaigns. **Prefer to pass your timezone in date-time format for accurate result** ( only available if either &#39;status&#39; not passed and if passed is set to &#39;sent&#39; )  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param excludeHtmlContent Use this flag to exclude htmlContent from the response body. If set to **true**, htmlContent field will be returned as empty string in the response body (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetEmailCampaigns
   * @throws ApiException if fails to make API call
   */
  public GetEmailCampaigns getEmailCampaigns(@jakarta.annotation.Nullable String type, @jakarta.annotation.Nullable String status, @jakarta.annotation.Nullable String statistics, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable Boolean excludeHtmlContent, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/emailCampaigns";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    localVarQueryParams.addAll(apiClient.parameterToPair("status", status));
    localVarQueryParams.addAll(apiClient.parameterToPair("statistics", statistics));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("excludeHtmlContent", excludeHtmlContent));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetEmailCampaigns> localVarReturnType = new TypeReference<GetEmailCampaigns>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get a shared template url
   * Get a unique URL to share &amp; import an email template from one Brevo account to another.
   * @param campaignId Id of the campaign or template (required)
   * @return GetSharedTemplateUrl
   * @throws ApiException if fails to make API call
   */
  public GetSharedTemplateUrl getSharedTemplateUrl(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    return this.getSharedTemplateUrl(campaignId, Collections.emptyMap());
  }


  /**
   * Get a shared template url
   * Get a unique URL to share &amp; import an email template from one Brevo account to another.
   * @param campaignId Id of the campaign or template (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSharedTemplateUrl
   * @throws ApiException if fails to make API call
   */
  public GetSharedTemplateUrl getSharedTemplateUrl(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling getSharedTemplateUrl");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/sharedUrl"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSharedTemplateUrl> localVarReturnType = new TypeReference<GetSharedTemplateUrl>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Send an email campaign immediately, based on campaignId
   * 
   * @param campaignId Id of the campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void sendEmailCampaignNow(@jakarta.annotation.Nonnull Long campaignId) throws ApiException {
    this.sendEmailCampaignNow(campaignId, Collections.emptyMap());
  }


  /**
   * Send an email campaign immediately, based on campaignId
   * 
   * @param campaignId Id of the campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendEmailCampaignNow(@jakarta.annotation.Nonnull Long campaignId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendEmailCampaignNow");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/sendNow"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Send the report of a campaign
   * A PDF will be sent to the specified email addresses
   * @param campaignId Id of the campaign (required)
   * @param sendReport Values for send a report (required)
   * @throws ApiException if fails to make API call
   */
  public void sendReport(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendReport sendReport) throws ApiException {
    this.sendReport(campaignId, sendReport, Collections.emptyMap());
  }


  /**
   * Send the report of a campaign
   * A PDF will be sent to the specified email addresses
   * @param campaignId Id of the campaign (required)
   * @param sendReport Values for send a report (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendReport(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendReport sendReport, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendReport;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendReport");
    }
    
    // verify the required parameter 'sendReport' is set
    if (sendReport == null) {
      throw new ApiException(400, "Missing the required parameter 'sendReport' when calling sendReport");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/sendReport"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Send an email campaign to your test list
   * 
   * @param campaignId Id of the campaign (required)
   * @param sendTestEmail  (required)
   * @throws ApiException if fails to make API call
   */
  public void sendTestEmail(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendTestEmail sendTestEmail) throws ApiException {
    this.sendTestEmail(campaignId, sendTestEmail, Collections.emptyMap());
  }


  /**
   * Send an email campaign to your test list
   * 
   * @param campaignId Id of the campaign (required)
   * @param sendTestEmail  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void sendTestEmail(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull SendTestEmail sendTestEmail, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = sendTestEmail;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling sendTestEmail");
    }
    
    // verify the required parameter 'sendTestEmail' is set
    if (sendTestEmail == null) {
      throw new ApiException(400, "Missing the required parameter 'sendTestEmail' when calling sendTestEmail");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/sendTest"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update an email campaign status
   * 
   * @param campaignId Id of the campaign (required)
   * @param updateCampaignStatus Status of the campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void updateCampaignStatus(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateCampaignStatus updateCampaignStatus) throws ApiException {
    this.updateCampaignStatus(campaignId, updateCampaignStatus, Collections.emptyMap());
  }


  /**
   * Update an email campaign status
   * 
   * @param campaignId Id of the campaign (required)
   * @param updateCampaignStatus Status of the campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateCampaignStatus(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateCampaignStatus updateCampaignStatus, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateCampaignStatus;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateCampaignStatus");
    }
    
    // verify the required parameter 'updateCampaignStatus' is set
    if (updateCampaignStatus == null) {
      throw new ApiException(400, "Missing the required parameter 'updateCampaignStatus' when calling updateCampaignStatus");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}/status"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update an email campaign
   * 
   * @param campaignId Id of the campaign (required)
   * @param updateEmailCampaign Values to update a campaign (required)
   * @throws ApiException if fails to make API call
   */
  public void updateEmailCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateEmailCampaign updateEmailCampaign) throws ApiException {
    this.updateEmailCampaign(campaignId, updateEmailCampaign, Collections.emptyMap());
  }


  /**
   * Update an email campaign
   * 
   * @param campaignId Id of the campaign (required)
   * @param updateEmailCampaign Values to update a campaign (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateEmailCampaign(@jakarta.annotation.Nonnull Long campaignId, @jakarta.annotation.Nonnull UpdateEmailCampaign updateEmailCampaign, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateEmailCampaign;
    
    // verify the required parameter 'campaignId' is set
    if (campaignId == null) {
      throw new ApiException(400, "Missing the required parameter 'campaignId' when calling updateEmailCampaign");
    }
    
    // verify the required parameter 'updateEmailCampaign' is set
    if (updateEmailCampaign == null) {
      throw new ApiException(400, "Missing the required parameter 'updateEmailCampaign' when calling updateEmailCampaign");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/{campaignId}"
      .replaceAll("\\{" + "campaignId" + "\\}", apiClient.escapeString(apiClient.parameterToString(campaignId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Upload an image to your account&#39;s image gallery
   * 
   * @param uploadImageToGallery Parameters to upload an image (required)
   * @return UploadImageModel
   * @throws ApiException if fails to make API call
   */
  public UploadImageModel uploadImageToGallery(@jakarta.annotation.Nonnull UploadImageToGallery uploadImageToGallery) throws ApiException {
    return this.uploadImageToGallery(uploadImageToGallery, Collections.emptyMap());
  }


  /**
   * Upload an image to your account&#39;s image gallery
   * 
   * @param uploadImageToGallery Parameters to upload an image (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return UploadImageModel
   * @throws ApiException if fails to make API call
   */
  public UploadImageModel uploadImageToGallery(@jakarta.annotation.Nonnull UploadImageToGallery uploadImageToGallery, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = uploadImageToGallery;
    
    // verify the required parameter 'uploadImageToGallery' is set
    if (uploadImageToGallery == null) {
      throw new ApiException(400, "Missing the required parameter 'uploadImageToGallery' when calling uploadImageToGallery");
    }
    
    // create path and map variables
    String localVarPath = "/emailCampaigns/images";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<UploadImageModel> localVarReturnType = new TypeReference<UploadImageModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
