/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import java.math.BigDecimal;
import software.xdev.brevo.model.CreateCategoryModel;
import software.xdev.brevo.model.CreateProductModel;
import software.xdev.brevo.model.CreateUpdateBatchCategory;
import software.xdev.brevo.model.CreateUpdateBatchCategoryModel;
import software.xdev.brevo.model.CreateUpdateBatchProducts;
import software.xdev.brevo.model.CreateUpdateBatchProductsModel;
import software.xdev.brevo.model.CreateUpdateCategory;
import software.xdev.brevo.model.CreateUpdateProduct;
import software.xdev.brevo.model.CreatedBatchId;
import software.xdev.brevo.model.EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response;
import software.xdev.brevo.model.EcommerceAttributionMetricsGet200Response;
import software.xdev.brevo.model.EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response;
import software.xdev.brevo.model.EcommerceConfigDisplayCurrencyGet200Response;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetCategories;
import software.xdev.brevo.model.GetCategoryDetails;
import software.xdev.brevo.model.GetProductDetails;
import software.xdev.brevo.model.GetProducts;
import java.time.OffsetDateTime;
import software.xdev.brevo.model.Order;
import software.xdev.brevo.model.OrderBatch;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class EcommerceApi extends BaseApi {

  public EcommerceApi() {
    super(Configuration.getDefaultApiClient());
  }

  public EcommerceApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create orders in batch
   * Create multiple orders at one time instead of one order at a time
   * @param orderBatch  (required)
   * @return CreatedBatchId
   * @throws ApiException if fails to make API call
   */
  public CreatedBatchId createBatchOrder(@jakarta.annotation.Nonnull OrderBatch orderBatch) throws ApiException {
    return this.createBatchOrder(orderBatch, Collections.emptyMap());
  }


  /**
   * Create orders in batch
   * Create multiple orders at one time instead of one order at a time
   * @param orderBatch  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreatedBatchId
   * @throws ApiException if fails to make API call
   */
  public CreatedBatchId createBatchOrder(@jakarta.annotation.Nonnull OrderBatch orderBatch, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = orderBatch;
    
    // verify the required parameter 'orderBatch' is set
    if (orderBatch == null) {
      throw new ApiException(400, "Missing the required parameter 'orderBatch' when calling createBatchOrder");
    }
    
    // create path and map variables
    String localVarPath = "/orders/status/batch";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreatedBatchId> localVarReturnType = new TypeReference<CreatedBatchId>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Managing the status of the order
   * Manages the transactional status of the order
   * @param order  (required)
   * @throws ApiException if fails to make API call
   */
  public void createOrder(@jakarta.annotation.Nonnull Order order) throws ApiException {
    this.createOrder(order, Collections.emptyMap());
  }


  /**
   * Managing the status of the order
   * Manages the transactional status of the order
   * @param order  (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void createOrder(@jakarta.annotation.Nonnull Order order, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = order;
    
    // verify the required parameter 'order' is set
    if (order == null) {
      throw new ApiException(400, "Missing the required parameter 'order' when calling createOrder");
    }
    
    // create path and map variables
    String localVarPath = "/orders/status";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create categories in batch
   * 
   * @param createUpdateBatchCategory Values to create a batch of categories (required)
   * @return CreateUpdateBatchCategoryModel
   * @throws ApiException if fails to make API call
   */
  public CreateUpdateBatchCategoryModel createUpdateBatchCategory(@jakarta.annotation.Nonnull CreateUpdateBatchCategory createUpdateBatchCategory) throws ApiException {
    return this.createUpdateBatchCategory(createUpdateBatchCategory, Collections.emptyMap());
  }


  /**
   * Create categories in batch
   * 
   * @param createUpdateBatchCategory Values to create a batch of categories (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateUpdateBatchCategoryModel
   * @throws ApiException if fails to make API call
   */
  public CreateUpdateBatchCategoryModel createUpdateBatchCategory(@jakarta.annotation.Nonnull CreateUpdateBatchCategory createUpdateBatchCategory, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createUpdateBatchCategory;
    
    // verify the required parameter 'createUpdateBatchCategory' is set
    if (createUpdateBatchCategory == null) {
      throw new ApiException(400, "Missing the required parameter 'createUpdateBatchCategory' when calling createUpdateBatchCategory");
    }
    
    // create path and map variables
    String localVarPath = "/categories/batch";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateUpdateBatchCategoryModel> localVarReturnType = new TypeReference<CreateUpdateBatchCategoryModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create products in batch
   * 
   * @param createUpdateBatchProducts Values to create a batch of products (required)
   * @return CreateUpdateBatchProductsModel
   * @throws ApiException if fails to make API call
   */
  public CreateUpdateBatchProductsModel createUpdateBatchProducts(@jakarta.annotation.Nonnull CreateUpdateBatchProducts createUpdateBatchProducts) throws ApiException {
    return this.createUpdateBatchProducts(createUpdateBatchProducts, Collections.emptyMap());
  }


  /**
   * Create products in batch
   * 
   * @param createUpdateBatchProducts Values to create a batch of products (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateUpdateBatchProductsModel
   * @throws ApiException if fails to make API call
   */
  public CreateUpdateBatchProductsModel createUpdateBatchProducts(@jakarta.annotation.Nonnull CreateUpdateBatchProducts createUpdateBatchProducts, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createUpdateBatchProducts;
    
    // verify the required parameter 'createUpdateBatchProducts' is set
    if (createUpdateBatchProducts == null) {
      throw new ApiException(400, "Missing the required parameter 'createUpdateBatchProducts' when calling createUpdateBatchProducts");
    }
    
    // create path and map variables
    String localVarPath = "/products/batch";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateUpdateBatchProductsModel> localVarReturnType = new TypeReference<CreateUpdateBatchProductsModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create/Update a category
   * 
   * @param createUpdateCategory Values to create/update a category (required)
   * @return CreateCategoryModel
   * @throws ApiException if fails to make API call
   */
  public CreateCategoryModel createUpdateCategory(@jakarta.annotation.Nonnull CreateUpdateCategory createUpdateCategory) throws ApiException {
    return this.createUpdateCategory(createUpdateCategory, Collections.emptyMap());
  }


  /**
   * Create/Update a category
   * 
   * @param createUpdateCategory Values to create/update a category (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateCategoryModel
   * @throws ApiException if fails to make API call
   */
  public CreateCategoryModel createUpdateCategory(@jakarta.annotation.Nonnull CreateUpdateCategory createUpdateCategory, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createUpdateCategory;
    
    // verify the required parameter 'createUpdateCategory' is set
    if (createUpdateCategory == null) {
      throw new ApiException(400, "Missing the required parameter 'createUpdateCategory' when calling createUpdateCategory");
    }
    
    // create path and map variables
    String localVarPath = "/categories";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateCategoryModel> localVarReturnType = new TypeReference<CreateCategoryModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create/Update a product
   * 
   * @param createUpdateProduct Values to create/update a product (required)
   * @return CreateProductModel
   * @throws ApiException if fails to make API call
   */
  public CreateProductModel createUpdateProduct(@jakarta.annotation.Nonnull CreateUpdateProduct createUpdateProduct) throws ApiException {
    return this.createUpdateProduct(createUpdateProduct, Collections.emptyMap());
  }


  /**
   * Create/Update a product
   * 
   * @param createUpdateProduct Values to create/update a product (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateProductModel
   * @throws ApiException if fails to make API call
   */
  public CreateProductModel createUpdateProduct(@jakarta.annotation.Nonnull CreateUpdateProduct createUpdateProduct, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createUpdateProduct;
    
    // verify the required parameter 'createUpdateProduct' is set
    if (createUpdateProduct == null) {
      throw new ApiException(400, "Missing the required parameter 'createUpdateProduct' when calling createUpdateProduct");
    }
    
    // create path and map variables
    String localVarPath = "/products";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateProductModel> localVarReturnType = new TypeReference<CreateProductModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Activate the eCommerce app
   * Getting access to Brevo eCommerce.
   * @throws ApiException if fails to make API call
   */
  public void ecommerceActivatePost() throws ApiException {
    this.ecommerceActivatePost(Collections.emptyMap());
  }


  /**
   * Activate the eCommerce app
   * Getting access to Brevo eCommerce.
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void ecommerceActivatePost(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/ecommerce/activate";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get detailed attribution metrics for a single Brevo campaign or workflow
   * 
   * @param conversionSource The Brevo campaign type or workflow type for which data will be retrieved (required)
   * @param conversionSourceId The Brevo campaign or automation workflow id for which data will be retrieved (required)
   * @return EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response ecommerceAttributionMetricsConversionSourceConversionSourceIdGet(@jakarta.annotation.Nonnull String conversionSource, @jakarta.annotation.Nonnull String conversionSourceId) throws ApiException {
    return this.ecommerceAttributionMetricsConversionSourceConversionSourceIdGet(conversionSource, conversionSourceId, Collections.emptyMap());
  }


  /**
   * Get detailed attribution metrics for a single Brevo campaign or workflow
   * 
   * @param conversionSource The Brevo campaign type or workflow type for which data will be retrieved (required)
   * @param conversionSourceId The Brevo campaign or automation workflow id for which data will be retrieved (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response ecommerceAttributionMetricsConversionSourceConversionSourceIdGet(@jakarta.annotation.Nonnull String conversionSource, @jakarta.annotation.Nonnull String conversionSourceId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'conversionSource' is set
    if (conversionSource == null) {
      throw new ApiException(400, "Missing the required parameter 'conversionSource' when calling ecommerceAttributionMetricsConversionSourceConversionSourceIdGet");
    }
    
    // verify the required parameter 'conversionSourceId' is set
    if (conversionSourceId == null) {
      throw new ApiException(400, "Missing the required parameter 'conversionSourceId' when calling ecommerceAttributionMetricsConversionSourceConversionSourceIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/ecommerce/attribution/metrics/{conversionSource}/{conversionSourceId}"
      .replaceAll("\\{" + "conversionSource" + "\\}", apiClient.escapeString(apiClient.parameterToString(conversionSource)))
      .replaceAll("\\{" + "conversionSourceId" + "\\}", apiClient.escapeString(apiClient.parameterToString(conversionSourceId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response> localVarReturnType = new TypeReference<EcommerceAttributionMetricsConversionSourceConversionSourceIdGet200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get attribution metrics for one or more Brevo campaigns or workflows
   * 
   * @param periodFrom When getting metrics for a specific period, define the starting datetime in RFC3339 format (optional)
   * @param periodTo When getting metrics for a specific period, define the end datetime in RFC3339 format (optional)
   * @param emailCampaignId The email campaign ID(s) to get metrics for (optional)
   * @param smsCampaignId The SMS campaign ID(s) to get metrics for (optional)
   * @param automationWorkflowEmailId The automation workflow ID(s) to get email attribution metrics for (optional)
   * @param automationWorkflowSmsId The automation workflow ID(s) to get SMS attribution metrics for (optional)
   * @return EcommerceAttributionMetricsGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceAttributionMetricsGet200Response ecommerceAttributionMetricsGet(@jakarta.annotation.Nullable OffsetDateTime periodFrom, @jakarta.annotation.Nullable OffsetDateTime periodTo, @jakarta.annotation.Nullable List<String> emailCampaignId, @jakarta.annotation.Nullable List<String> smsCampaignId, @jakarta.annotation.Nullable List<String> automationWorkflowEmailId, @jakarta.annotation.Nullable List<String> automationWorkflowSmsId) throws ApiException {
    return this.ecommerceAttributionMetricsGet(periodFrom, periodTo, emailCampaignId, smsCampaignId, automationWorkflowEmailId, automationWorkflowSmsId, Collections.emptyMap());
  }


  /**
   * Get attribution metrics for one or more Brevo campaigns or workflows
   * 
   * @param periodFrom When getting metrics for a specific period, define the starting datetime in RFC3339 format (optional)
   * @param periodTo When getting metrics for a specific period, define the end datetime in RFC3339 format (optional)
   * @param emailCampaignId The email campaign ID(s) to get metrics for (optional)
   * @param smsCampaignId The SMS campaign ID(s) to get metrics for (optional)
   * @param automationWorkflowEmailId The automation workflow ID(s) to get email attribution metrics for (optional)
   * @param automationWorkflowSmsId The automation workflow ID(s) to get SMS attribution metrics for (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return EcommerceAttributionMetricsGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceAttributionMetricsGet200Response ecommerceAttributionMetricsGet(@jakarta.annotation.Nullable OffsetDateTime periodFrom, @jakarta.annotation.Nullable OffsetDateTime periodTo, @jakarta.annotation.Nullable List<String> emailCampaignId, @jakarta.annotation.Nullable List<String> smsCampaignId, @jakarta.annotation.Nullable List<String> automationWorkflowEmailId, @jakarta.annotation.Nullable List<String> automationWorkflowSmsId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/ecommerce/attribution/metrics";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("periodFrom", periodFrom));
    localVarQueryParams.addAll(apiClient.parameterToPair("periodTo", periodTo));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "emailCampaignId[]", emailCampaignId));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "smsCampaignId[]", smsCampaignId));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "automationWorkflowEmailId[]", automationWorkflowEmailId));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "automationWorkflowSmsId[]", automationWorkflowSmsId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<EcommerceAttributionMetricsGet200Response> localVarReturnType = new TypeReference<EcommerceAttributionMetricsGet200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get attributed product sales for a single Brevo campaign or workflow
   * 
   * @param conversionSource The Brevo campaign or automation workflow type for which data will be retrieved (required)
   * @param conversionSourceId The Brevo campaign or automation workflow id for which data will be retrieved (required)
   * @return EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response ecommerceAttributionProductsConversionSourceConversionSourceIdGet(@jakarta.annotation.Nonnull String conversionSource, @jakarta.annotation.Nonnull String conversionSourceId) throws ApiException {
    return this.ecommerceAttributionProductsConversionSourceConversionSourceIdGet(conversionSource, conversionSourceId, Collections.emptyMap());
  }


  /**
   * Get attributed product sales for a single Brevo campaign or workflow
   * 
   * @param conversionSource The Brevo campaign or automation workflow type for which data will be retrieved (required)
   * @param conversionSourceId The Brevo campaign or automation workflow id for which data will be retrieved (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response ecommerceAttributionProductsConversionSourceConversionSourceIdGet(@jakarta.annotation.Nonnull String conversionSource, @jakarta.annotation.Nonnull String conversionSourceId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'conversionSource' is set
    if (conversionSource == null) {
      throw new ApiException(400, "Missing the required parameter 'conversionSource' when calling ecommerceAttributionProductsConversionSourceConversionSourceIdGet");
    }
    
    // verify the required parameter 'conversionSourceId' is set
    if (conversionSourceId == null) {
      throw new ApiException(400, "Missing the required parameter 'conversionSourceId' when calling ecommerceAttributionProductsConversionSourceConversionSourceIdGet");
    }
    
    // create path and map variables
    String localVarPath = "/ecommerce/attribution/products/{conversionSource}/{conversionSourceId}"
      .replaceAll("\\{" + "conversionSource" + "\\}", apiClient.escapeString(apiClient.parameterToString(conversionSource)))
      .replaceAll("\\{" + "conversionSourceId" + "\\}", apiClient.escapeString(apiClient.parameterToString(conversionSourceId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response> localVarReturnType = new TypeReference<EcommerceAttributionProductsConversionSourceConversionSourceIdGet200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the ISO 4217 compliant display currency code for your Brevo account
   * 
   * @return EcommerceConfigDisplayCurrencyGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet() throws ApiException {
    return this.ecommerceConfigDisplayCurrencyGet(Collections.emptyMap());
  }


  /**
   * Get the ISO 4217 compliant display currency code for your Brevo account
   * 
   * @param additionalHeaders additionalHeaders for this call
   * @return EcommerceConfigDisplayCurrencyGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/ecommerce/config/displayCurrency";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<EcommerceConfigDisplayCurrencyGet200Response> localVarReturnType = new TypeReference<EcommerceConfigDisplayCurrencyGet200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Return all your categories
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param ids Filter by category ids (optional)
   * @param name Filter by category name (optional)
   * @param modifiedSince Filter (urlencoded) the categories modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the categories created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @return GetCategories
   * @throws ApiException if fails to make API call
   */
  public GetCategories getCategories(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable List<String> ids, @jakarta.annotation.Nullable String name, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince) throws ApiException {
    return this.getCategories(limit, offset, sort, ids, name, modifiedSince, createdSince, Collections.emptyMap());
  }


  /**
   * Return all your categories
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param ids Filter by category ids (optional)
   * @param name Filter by category name (optional)
   * @param modifiedSince Filter (urlencoded) the categories modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the categories created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetCategories
   * @throws ApiException if fails to make API call
   */
  public GetCategories getCategories(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable List<String> ids, @jakarta.annotation.Nullable String name, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/categories";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "ids", ids));
    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("modifiedSince", modifiedSince));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdSince", createdSince));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetCategories> localVarReturnType = new TypeReference<GetCategories>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get a category details
   * 
   * @param id Category ID (required)
   * @return GetCategoryDetails
   * @throws ApiException if fails to make API call
   */
  public GetCategoryDetails getCategoryInfo(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.getCategoryInfo(id, Collections.emptyMap());
  }


  /**
   * Get a category details
   * 
   * @param id Category ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetCategoryDetails
   * @throws ApiException if fails to make API call
   */
  public GetCategoryDetails getCategoryInfo(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getCategoryInfo");
    }
    
    // create path and map variables
    String localVarPath = "/categories/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetCategoryDetails> localVarReturnType = new TypeReference<GetCategoryDetails>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get order details
   * Get all the orders
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param modifiedSince Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @throws ApiException if fails to make API call
   */
  public void getOrders(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince) throws ApiException {
    this.getOrders(limit, offset, sort, modifiedSince, createdSince, Collections.emptyMap());
  }


  /**
   * Get order details
   * Get all the orders
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param modifiedSince Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void getOrders(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/orders";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("modifiedSince", modifiedSince));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdSince", createdSince));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get a product&#39;s details
   * 
   * @param id Product ID (required)
   * @return GetProductDetails
   * @throws ApiException if fails to make API call
   */
  public GetProductDetails getProductInfo(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.getProductInfo(id, Collections.emptyMap());
  }


  /**
   * Get a product&#39;s details
   * 
   * @param id Product ID (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetProductDetails
   * @throws ApiException if fails to make API call
   */
  public GetProductDetails getProductInfo(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getProductInfo");
    }
    
    // create path and map variables
    String localVarPath = "/products/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetProductDetails> localVarReturnType = new TypeReference<GetProductDetails>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Return all your products
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param ids Filter by product ids (optional)
   * @param name Filter by product name, minimum 3 characters should be present for search (optional)
   * @param priceLte Price filter for products less than and equals to particular amount (optional)
   * @param priceGte Price filter for products greater than and equals to particular amount (optional)
   * @param priceLt Price filter for products less than particular amount (optional)
   * @param priceGt Price filter for products greater than particular amount (optional)
   * @param priceEq Price filter for products equals to particular amount (optional)
   * @param priceNe Price filter for products not equals to particular amount (optional)
   * @param categories Filter by product categories (optional)
   * @param modifiedSince Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @return GetProducts
   * @throws ApiException if fails to make API call
   */
  public GetProducts getProducts(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable List<String> ids, @jakarta.annotation.Nullable String name, @jakarta.annotation.Nullable BigDecimal priceLte, @jakarta.annotation.Nullable BigDecimal priceGte, @jakarta.annotation.Nullable BigDecimal priceLt, @jakarta.annotation.Nullable BigDecimal priceGt, @jakarta.annotation.Nullable BigDecimal priceEq, @jakarta.annotation.Nullable BigDecimal priceNe, @jakarta.annotation.Nullable List<String> categories, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince) throws ApiException {
    return this.getProducts(limit, offset, sort, ids, name, priceLte, priceGte, priceLt, priceGt, priceEq, priceNe, categories, modifiedSince, createdSince, Collections.emptyMap());
  }


  /**
   * Return all your products
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document in the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param ids Filter by product ids (optional)
   * @param name Filter by product name, minimum 3 characters should be present for search (optional)
   * @param priceLte Price filter for products less than and equals to particular amount (optional)
   * @param priceGte Price filter for products greater than and equals to particular amount (optional)
   * @param priceLt Price filter for products less than particular amount (optional)
   * @param priceGt Price filter for products greater than particular amount (optional)
   * @param priceEq Price filter for products equals to particular amount (optional)
   * @param priceNe Price filter for products not equals to particular amount (optional)
   * @param categories Filter by product categories (optional)
   * @param modifiedSince Filter (urlencoded) the orders modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the orders created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetProducts
   * @throws ApiException if fails to make API call
   */
  public GetProducts getProducts(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable List<String> ids, @jakarta.annotation.Nullable String name, @jakarta.annotation.Nullable BigDecimal priceLte, @jakarta.annotation.Nullable BigDecimal priceGte, @jakarta.annotation.Nullable BigDecimal priceLt, @jakarta.annotation.Nullable BigDecimal priceGt, @jakarta.annotation.Nullable BigDecimal priceEq, @jakarta.annotation.Nullable BigDecimal priceNe, @jakarta.annotation.Nullable List<String> categories, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/products";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "ids", ids));
    localVarQueryParams.addAll(apiClient.parameterToPair("name", name));
    localVarQueryParams.addAll(apiClient.parameterToPair("price[lte]", priceLte));
    localVarQueryParams.addAll(apiClient.parameterToPair("price[gte]", priceGte));
    localVarQueryParams.addAll(apiClient.parameterToPair("price[lt]", priceLt));
    localVarQueryParams.addAll(apiClient.parameterToPair("price[gt]", priceGt));
    localVarQueryParams.addAll(apiClient.parameterToPair("price[eq]", priceEq));
    localVarQueryParams.addAll(apiClient.parameterToPair("price[ne]", priceNe));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "categories", categories));
    localVarQueryParams.addAll(apiClient.parameterToPair("modifiedSince", modifiedSince));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdSince", createdSince));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetProducts> localVarReturnType = new TypeReference<GetProducts>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Set the ISO 4217 compliant display currency code for your Brevo account
   * 
   * @param ecommerceConfigDisplayCurrencyGet200Response set ISO 4217 compliant display currency code payload (optional)
   * @return EcommerceConfigDisplayCurrencyGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceConfigDisplayCurrencyGet200Response setConfigDisplayCurrency(@jakarta.annotation.Nullable EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet200Response) throws ApiException {
    return this.setConfigDisplayCurrency(ecommerceConfigDisplayCurrencyGet200Response, Collections.emptyMap());
  }


  /**
   * Set the ISO 4217 compliant display currency code for your Brevo account
   * 
   * @param ecommerceConfigDisplayCurrencyGet200Response set ISO 4217 compliant display currency code payload (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return EcommerceConfigDisplayCurrencyGet200Response
   * @throws ApiException if fails to make API call
   */
  public EcommerceConfigDisplayCurrencyGet200Response setConfigDisplayCurrency(@jakarta.annotation.Nullable EcommerceConfigDisplayCurrencyGet200Response ecommerceConfigDisplayCurrencyGet200Response, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = ecommerceConfigDisplayCurrencyGet200Response;
    
    // create path and map variables
    String localVarPath = "/ecommerce/config/displayCurrency";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<EcommerceConfigDisplayCurrencyGet200Response> localVarReturnType = new TypeReference<EcommerceConfigDisplayCurrencyGet200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
