/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.AuthenticateDomainModel;
import software.xdev.brevo.model.CreateDomain;
import software.xdev.brevo.model.CreateDomainModel;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetDomainConfigurationModel;
import software.xdev.brevo.model.GetDomainsList;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class DomainsApi extends BaseApi {

  public DomainsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public DomainsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Authenticate a domain
   * 
   * @param domainName Domain name (required)
   * @return AuthenticateDomainModel
   * @throws ApiException if fails to make API call
   */
  public AuthenticateDomainModel authenticateDomain(@jakarta.annotation.Nonnull String domainName) throws ApiException {
    return this.authenticateDomain(domainName, Collections.emptyMap());
  }


  /**
   * Authenticate a domain
   * 
   * @param domainName Domain name (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return AuthenticateDomainModel
   * @throws ApiException if fails to make API call
   */
  public AuthenticateDomainModel authenticateDomain(@jakarta.annotation.Nonnull String domainName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'domainName' is set
    if (domainName == null) {
      throw new ApiException(400, "Missing the required parameter 'domainName' when calling authenticateDomain");
    }
    
    // create path and map variables
    String localVarPath = "/senders/domains/{domainName}/authenticate"
      .replaceAll("\\{" + "domainName" + "\\}", apiClient.escapeString(apiClient.parameterToString(domainName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<AuthenticateDomainModel> localVarReturnType = new TypeReference<AuthenticateDomainModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a new domain
   * 
   * @param domain domain&#39;s name (optional)
   * @return CreateDomainModel
   * @throws ApiException if fails to make API call
   */
  public CreateDomainModel createDomain(@jakarta.annotation.Nullable CreateDomain domain) throws ApiException {
    return this.createDomain(domain, Collections.emptyMap());
  }


  /**
   * Create a new domain
   * 
   * @param domain domain&#39;s name (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateDomainModel
   * @throws ApiException if fails to make API call
   */
  public CreateDomainModel createDomain(@jakarta.annotation.Nullable CreateDomain domain, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = domain;
    
    // create path and map variables
    String localVarPath = "/senders/domains";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateDomainModel> localVarReturnType = new TypeReference<CreateDomainModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a domain
   * 
   * @param domainName Domain name (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteDomain(@jakarta.annotation.Nonnull String domainName) throws ApiException {
    this.deleteDomain(domainName, Collections.emptyMap());
  }


  /**
   * Delete a domain
   * 
   * @param domainName Domain name (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteDomain(@jakarta.annotation.Nonnull String domainName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'domainName' is set
    if (domainName == null) {
      throw new ApiException(400, "Missing the required parameter 'domainName' when calling deleteDomain");
    }
    
    // create path and map variables
    String localVarPath = "/senders/domains/{domainName}"
      .replaceAll("\\{" + "domainName" + "\\}", apiClient.escapeString(apiClient.parameterToString(domainName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Validate domain configuration
   * 
   * @param domainName Domain name (required)
   * @return GetDomainConfigurationModel
   * @throws ApiException if fails to make API call
   */
  public GetDomainConfigurationModel getDomainConfiguration(@jakarta.annotation.Nonnull String domainName) throws ApiException {
    return this.getDomainConfiguration(domainName, Collections.emptyMap());
  }


  /**
   * Validate domain configuration
   * 
   * @param domainName Domain name (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetDomainConfigurationModel
   * @throws ApiException if fails to make API call
   */
  public GetDomainConfigurationModel getDomainConfiguration(@jakarta.annotation.Nonnull String domainName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'domainName' is set
    if (domainName == null) {
      throw new ApiException(400, "Missing the required parameter 'domainName' when calling getDomainConfiguration");
    }
    
    // create path and map variables
    String localVarPath = "/senders/domains/{domainName}"
      .replaceAll("\\{" + "domainName" + "\\}", apiClient.escapeString(apiClient.parameterToString(domainName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetDomainConfigurationModel> localVarReturnType = new TypeReference<GetDomainConfigurationModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get the list of all your domains
   * 
   * @return GetDomainsList
   * @throws ApiException if fails to make API call
   */
  public GetDomainsList getDomains() throws ApiException {
    return this.getDomains(Collections.emptyMap());
  }


  /**
   * Get the list of all your domains
   * 
   * @param additionalHeaders additionalHeaders for this call
   * @return GetDomainsList
   * @throws ApiException if fails to make API call
   */
  public GetDomainsList getDomains(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/senders/domains";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetDomainsList> localVarReturnType = new TypeReference<GetDomainsList>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
