/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.Getrecords200Response;
import software.xdev.brevo.model.Upsertrecords202Response;
import software.xdev.brevo.model.UpsertrecordsRequest;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class CustomObjectsApi extends BaseApi {

  public CustomObjectsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public CustomObjectsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Get the list of object records and total records count for an object.
   * This API retrieves a list of object records along with their associated records and provides the total count of records for the specified object. 
   * @param objectType object type for the attribute (required)
   * @param limit Number of records returned per page (required)
   * @param pageNum Page number for pagination. It&#39;s used to fetch the object records on a provided page number. Must be a valid positive integer. (required)
   * @param sort Sort order, must be &#39;asc&#39; or &#39;desc&#39;. Default to &#39;desc&#39; if not provided. (optional, default to desc)
   * @param association Whether to include associations, must be &#39;true&#39; or &#39;false&#39;. Default to &#39;false&#39; if not provided. (optional)
   * @return Getrecords200Response
   * @throws ApiException if fails to make API call
   */
  public Getrecords200Response getrecords(@jakarta.annotation.Nonnull String objectType, @jakarta.annotation.Nonnull Long limit, @jakarta.annotation.Nonnull Long pageNum, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String association) throws ApiException {
    return this.getrecords(objectType, limit, pageNum, sort, association, Collections.emptyMap());
  }


  /**
   * Get the list of object records and total records count for an object.
   * This API retrieves a list of object records along with their associated records and provides the total count of records for the specified object. 
   * @param objectType object type for the attribute (required)
   * @param limit Number of records returned per page (required)
   * @param pageNum Page number for pagination. It&#39;s used to fetch the object records on a provided page number. Must be a valid positive integer. (required)
   * @param sort Sort order, must be &#39;asc&#39; or &#39;desc&#39;. Default to &#39;desc&#39; if not provided. (optional, default to desc)
   * @param association Whether to include associations, must be &#39;true&#39; or &#39;false&#39;. Default to &#39;false&#39; if not provided. (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return Getrecords200Response
   * @throws ApiException if fails to make API call
   */
  public Getrecords200Response getrecords(@jakarta.annotation.Nonnull String objectType, @jakarta.annotation.Nonnull Long limit, @jakarta.annotation.Nonnull Long pageNum, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String association, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'objectType' is set
    if (objectType == null) {
      throw new ApiException(400, "Missing the required parameter 'objectType' when calling getrecords");
    }
    
    // verify the required parameter 'limit' is set
    if (limit == null) {
      throw new ApiException(400, "Missing the required parameter 'limit' when calling getrecords");
    }
    
    // verify the required parameter 'pageNum' is set
    if (pageNum == null) {
      throw new ApiException(400, "Missing the required parameter 'pageNum' when calling getrecords");
    }
    
    // create path and map variables
    String localVarPath = "/objects/{object_type}/records"
      .replaceAll("\\{" + "object_type" + "\\}", apiClient.escapeString(apiClient.parameterToString(objectType)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("page_num", pageNum));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("association", association));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Getrecords200Response> localVarReturnType = new TypeReference<Getrecords200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create/Update object records in bulk
   * This API allows bulk upsert of object records in a single request. Each object record may include   - Attributes   - Identifiers   - Associations  **Response:**   The API processes the request asynchronously and returns a processId that you can use to track the background process status.  **API and Schema Limitation:**   - Size:       - Max 1000 objects records per request       - Max request body size: 1 MB    - Max 500 attributes defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 500 attributes.     - Worth noting: Nothing happens If an attribute is mentioned in the request, but was not previously defined for the object schema (no error, no attribute creation)    - Max 10 associations defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 10 associations with other objects. and each object record can be linked to max 10 other records.  **Errors:**     - Make sure both object records exist before associating them, else the API will return an error.     - This route does not create objects. The object where the object records are upserted by this API must be created already else the API will return an error \&quot;invalid object type\&quot;. 
   * @param objectType object type for the attribute (required)
   * @param upsertrecordsRequest Payload for batch upsert object records with associations (required)
   * @return Upsertrecords202Response
   * @throws ApiException if fails to make API call
   */
  public Upsertrecords202Response upsertrecords(@jakarta.annotation.Nonnull String objectType, @jakarta.annotation.Nonnull UpsertrecordsRequest upsertrecordsRequest) throws ApiException {
    return this.upsertrecords(objectType, upsertrecordsRequest, Collections.emptyMap());
  }


  /**
   * Create/Update object records in bulk
   * This API allows bulk upsert of object records in a single request. Each object record may include   - Attributes   - Identifiers   - Associations  **Response:**   The API processes the request asynchronously and returns a processId that you can use to track the background process status.  **API and Schema Limitation:**   - Size:       - Max 1000 objects records per request       - Max request body size: 1 MB    - Max 500 attributes defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 500 attributes.     - Worth noting: Nothing happens If an attribute is mentioned in the request, but was not previously defined for the object schema (no error, no attribute creation)    - Max 10 associations defined per object record upsert request     - This is coherent with schema limitation: an object cannot have more than 10 associations with other objects. and each object record can be linked to max 10 other records.  **Errors:**     - Make sure both object records exist before associating them, else the API will return an error.     - This route does not create objects. The object where the object records are upserted by this API must be created already else the API will return an error \&quot;invalid object type\&quot;. 
   * @param objectType object type for the attribute (required)
   * @param upsertrecordsRequest Payload for batch upsert object records with associations (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Upsertrecords202Response
   * @throws ApiException if fails to make API call
   */
  public Upsertrecords202Response upsertrecords(@jakarta.annotation.Nonnull String objectType, @jakarta.annotation.Nonnull UpsertrecordsRequest upsertrecordsRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = upsertrecordsRequest;
    
    // verify the required parameter 'objectType' is set
    if (objectType == null) {
      throw new ApiException(400, "Missing the required parameter 'objectType' when calling upsertrecords");
    }
    
    // verify the required parameter 'upsertrecordsRequest' is set
    if (upsertrecordsRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'upsertrecordsRequest' when calling upsertrecords");
    }
    
    // create path and map variables
    String localVarPath = "/objects/{object_type}/batch/upsert"
      .replaceAll("\\{" + "object_type" + "\\}", apiClient.escapeString(apiClient.parameterToString(objectType)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Upsertrecords202Response> localVarReturnType = new TypeReference<Upsertrecords202Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
