/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.CreateCouponCollection201Response;
import software.xdev.brevo.model.CreateCouponCollectionRequest;
import software.xdev.brevo.model.CreateCouponsRequest;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetCouponCollection;
import software.xdev.brevo.model.UpdateCouponCollection200Response;
import software.xdev.brevo.model.UpdateCouponCollectionRequest;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class CouponsApi extends BaseApi {

  public CouponsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public CouponsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create а coupon collection
   * 
   * @param createCouponCollectionRequest Values to create a coupon collection (required)
   * @return CreateCouponCollection201Response
   * @throws ApiException if fails to make API call
   */
  public CreateCouponCollection201Response createCouponCollection(@jakarta.annotation.Nonnull CreateCouponCollectionRequest createCouponCollectionRequest) throws ApiException {
    return this.createCouponCollection(createCouponCollectionRequest, Collections.emptyMap());
  }


  /**
   * Create а coupon collection
   * 
   * @param createCouponCollectionRequest Values to create a coupon collection (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateCouponCollection201Response
   * @throws ApiException if fails to make API call
   */
  public CreateCouponCollection201Response createCouponCollection(@jakarta.annotation.Nonnull CreateCouponCollectionRequest createCouponCollectionRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createCouponCollectionRequest;
    
    // verify the required parameter 'createCouponCollectionRequest' is set
    if (createCouponCollectionRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCouponCollectionRequest' when calling createCouponCollection");
    }
    
    // create path and map variables
    String localVarPath = "/couponCollections";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateCouponCollection201Response> localVarReturnType = new TypeReference<CreateCouponCollection201Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create coupons for a coupon collection
   * 
   * @param createCouponsRequest Values to create coupons (required)
   * @throws ApiException if fails to make API call
   */
  public void createCoupons(@jakarta.annotation.Nonnull CreateCouponsRequest createCouponsRequest) throws ApiException {
    this.createCoupons(createCouponsRequest, Collections.emptyMap());
  }


  /**
   * Create coupons for a coupon collection
   * 
   * @param createCouponsRequest Values to create coupons (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void createCoupons(@jakarta.annotation.Nonnull CreateCouponsRequest createCouponsRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createCouponsRequest;
    
    // verify the required parameter 'createCouponsRequest' is set
    if (createCouponsRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'createCouponsRequest' when calling createCoupons");
    }
    
    // create path and map variables
    String localVarPath = "/coupons";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get a coupon collection by id
   * 
   * @param id Id of the collection to return (required)
   * @return GetCouponCollection
   * @throws ApiException if fails to make API call
   */
  public GetCouponCollection getCouponCollection(@jakarta.annotation.Nonnull String id) throws ApiException {
    return this.getCouponCollection(id, Collections.emptyMap());
  }


  /**
   * Get a coupon collection by id
   * 
   * @param id Id of the collection to return (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetCouponCollection
   * @throws ApiException if fails to make API call
   */
  public GetCouponCollection getCouponCollection(@jakarta.annotation.Nonnull String id, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling getCouponCollection");
    }
    
    // create path and map variables
    String localVarPath = "/couponCollections/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetCouponCollection> localVarReturnType = new TypeReference<GetCouponCollection>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all your coupon collections
   * 
   * @param limit Number of documents returned per page (optional, default to 50)
   * @param offset Index of the first document on the page (optional, default to 0)
   * @param sort Sort the results by creation time in ascending/descending order (optional, default to desc)
   * @param sortBy The field used to sort coupon collections (optional, default to createdAt)
   * @return GetCouponCollection
   * @throws ApiException if fails to make API call
   */
  public GetCouponCollection getCouponCollections(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String sortBy) throws ApiException {
    return this.getCouponCollections(limit, offset, sort, sortBy, Collections.emptyMap());
  }


  /**
   * Get all your coupon collections
   * 
   * @param limit Number of documents returned per page (optional, default to 50)
   * @param offset Index of the first document on the page (optional, default to 0)
   * @param sort Sort the results by creation time in ascending/descending order (optional, default to desc)
   * @param sortBy The field used to sort coupon collections (optional, default to createdAt)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetCouponCollection
   * @throws ApiException if fails to make API call
   */
  public GetCouponCollection getCouponCollections(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String sortBy, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/couponCollections";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortBy", sortBy));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetCouponCollection> localVarReturnType = new TypeReference<GetCouponCollection>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update a coupon collection by id
   * 
   * @param id Id of the collection to update (required)
   * @param updateCouponCollectionRequest Values to update the coupon collection (optional)
   * @return UpdateCouponCollection200Response
   * @throws ApiException if fails to make API call
   */
  public UpdateCouponCollection200Response updateCouponCollection(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable UpdateCouponCollectionRequest updateCouponCollectionRequest) throws ApiException {
    return this.updateCouponCollection(id, updateCouponCollectionRequest, Collections.emptyMap());
  }


  /**
   * Update a coupon collection by id
   * 
   * @param id Id of the collection to update (required)
   * @param updateCouponCollectionRequest Values to update the coupon collection (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return UpdateCouponCollection200Response
   * @throws ApiException if fails to make API call
   */
  public UpdateCouponCollection200Response updateCouponCollection(@jakarta.annotation.Nonnull String id, @jakarta.annotation.Nullable UpdateCouponCollectionRequest updateCouponCollectionRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateCouponCollectionRequest;
    
    // verify the required parameter 'id' is set
    if (id == null) {
      throw new ApiException(400, "Missing the required parameter 'id' when calling updateCouponCollection");
    }
    
    // create path and map variables
    String localVarPath = "/couponCollections/{id}"
      .replaceAll("\\{" + "id" + "\\}", apiClient.escapeString(apiClient.parameterToString(id)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<UpdateCouponCollection200Response> localVarReturnType = new TypeReference<UpdateCouponCollection200Response>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PATCH",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
