/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.AddContactToListRequest;
import software.xdev.brevo.model.ContactErrorModel;
import software.xdev.brevo.model.CreateAttribute;
import software.xdev.brevo.model.CreateContact;
import software.xdev.brevo.model.CreateDoiContact;
import software.xdev.brevo.model.CreateList;
import software.xdev.brevo.model.CreateModel;
import software.xdev.brevo.model.CreateUpdateContactModel;
import software.xdev.brevo.model.CreateUpdateFolder;
import software.xdev.brevo.model.CreatedProcessId;
import software.xdev.brevo.model.ErrorModel;
import software.xdev.brevo.model.GetAttributes;
import software.xdev.brevo.model.GetContactCampaignStats;
import software.xdev.brevo.model.GetContactInfoIdentifierParameter;
import software.xdev.brevo.model.GetContacts;
import software.xdev.brevo.model.GetExtendedContactDetails;
import software.xdev.brevo.model.GetExtendedList;
import software.xdev.brevo.model.GetFolder;
import software.xdev.brevo.model.GetFolderLists;
import software.xdev.brevo.model.GetFolders;
import software.xdev.brevo.model.GetLists;
import software.xdev.brevo.model.GetSegments;
import software.xdev.brevo.model.PostContactInfo;
import software.xdev.brevo.model.RemoveContactFromListRequest;
import software.xdev.brevo.model.RequestContactExport;
import software.xdev.brevo.model.RequestContactImport;
import software.xdev.brevo.model.UpdateAttribute;
import software.xdev.brevo.model.UpdateBatchContacts;
import software.xdev.brevo.model.UpdateContact;
import software.xdev.brevo.model.UpdateList;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class ContactsApi extends BaseApi {

  public ContactsApi() {
    super(Configuration.getDefaultApiClient());
  }

  public ContactsApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Add existing contacts to a list
   * 
   * @param listId Id of the list (required)
   * @param addContactToListRequest Emails addresses OR IDs OR EXT_ID attributes of the contacts (required)
   * @return PostContactInfo
   * @throws ApiException if fails to make API call
   */
  public PostContactInfo addContactToList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nonnull AddContactToListRequest addContactToListRequest) throws ApiException {
    return this.addContactToList(listId, addContactToListRequest, Collections.emptyMap());
  }


  /**
   * Add existing contacts to a list
   * 
   * @param listId Id of the list (required)
   * @param addContactToListRequest Emails addresses OR IDs OR EXT_ID attributes of the contacts (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return PostContactInfo
   * @throws ApiException if fails to make API call
   */
  public PostContactInfo addContactToList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nonnull AddContactToListRequest addContactToListRequest, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = addContactToListRequest;
    
    // verify the required parameter 'listId' is set
    if (listId == null) {
      throw new ApiException(400, "Missing the required parameter 'listId' when calling addContactToList");
    }
    
    // verify the required parameter 'addContactToListRequest' is set
    if (addContactToListRequest == null) {
      throw new ApiException(400, "Missing the required parameter 'addContactToListRequest' when calling addContactToList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists/{listId}/contacts/add"
      .replaceAll("\\{" + "listId" + "\\}", apiClient.escapeString(apiClient.parameterToString(listId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<PostContactInfo> localVarReturnType = new TypeReference<PostContactInfo>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create contact attribute
   * 
   * @param attributeCategory Category of the attribute (required)
   * @param attributeName Name of the attribute (required)
   * @param createAttribute Values to create an attribute (required)
   * @throws ApiException if fails to make API call
   */
  public void createAttribute(@jakarta.annotation.Nonnull String attributeCategory, @jakarta.annotation.Nonnull String attributeName, @jakarta.annotation.Nonnull CreateAttribute createAttribute) throws ApiException {
    this.createAttribute(attributeCategory, attributeName, createAttribute, Collections.emptyMap());
  }


  /**
   * Create contact attribute
   * 
   * @param attributeCategory Category of the attribute (required)
   * @param attributeName Name of the attribute (required)
   * @param createAttribute Values to create an attribute (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void createAttribute(@jakarta.annotation.Nonnull String attributeCategory, @jakarta.annotation.Nonnull String attributeName, @jakarta.annotation.Nonnull CreateAttribute createAttribute, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createAttribute;
    
    // verify the required parameter 'attributeCategory' is set
    if (attributeCategory == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeCategory' when calling createAttribute");
    }
    
    // verify the required parameter 'attributeName' is set
    if (attributeName == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeName' when calling createAttribute");
    }
    
    // verify the required parameter 'createAttribute' is set
    if (createAttribute == null) {
      throw new ApiException(400, "Missing the required parameter 'createAttribute' when calling createAttribute");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}"
      .replaceAll("\\{" + "attributeCategory" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeCategory)))
      .replaceAll("\\{" + "attributeName" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create a contact
   * Creates new contacts on Brevo. Contacts can be created by passing either - &lt;br&gt;&lt;br&gt; 1. email address of the contact (email_id),  &lt;br&gt; 2. phone number of the contact (to be passed as \&quot;SMS\&quot; field in \&quot;attributes\&quot; along with proper country code), For example- {\&quot;SMS\&quot;:\&quot;+91xxxxxxxxxx\&quot;} or {\&quot;SMS\&quot;:\&quot;0091xxxxxxxxxx\&quot;} &lt;br&gt; 3. ext_id &lt;br&gt;
   * @param createContact Values to create a contact (required)
   * @return CreateUpdateContactModel
   * @throws ApiException if fails to make API call
   */
  public CreateUpdateContactModel createContact(@jakarta.annotation.Nonnull CreateContact createContact) throws ApiException {
    return this.createContact(createContact, Collections.emptyMap());
  }


  /**
   * Create a contact
   * Creates new contacts on Brevo. Contacts can be created by passing either - &lt;br&gt;&lt;br&gt; 1. email address of the contact (email_id),  &lt;br&gt; 2. phone number of the contact (to be passed as \&quot;SMS\&quot; field in \&quot;attributes\&quot; along with proper country code), For example- {\&quot;SMS\&quot;:\&quot;+91xxxxxxxxxx\&quot;} or {\&quot;SMS\&quot;:\&quot;0091xxxxxxxxxx\&quot;} &lt;br&gt; 3. ext_id &lt;br&gt;
   * @param createContact Values to create a contact (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateUpdateContactModel
   * @throws ApiException if fails to make API call
   */
  public CreateUpdateContactModel createContact(@jakarta.annotation.Nonnull CreateContact createContact, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createContact;
    
    // verify the required parameter 'createContact' is set
    if (createContact == null) {
      throw new ApiException(400, "Missing the required parameter 'createContact' when calling createContact");
    }
    
    // create path and map variables
    String localVarPath = "/contacts";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateUpdateContactModel> localVarReturnType = new TypeReference<CreateUpdateContactModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create Contact via DOI (Double-Opt-In) Flow
   * 
   * @param createDoiContact Values to create the Double opt-in (DOI) contact (required)
   * @throws ApiException if fails to make API call
   */
  public void createDoiContact(@jakarta.annotation.Nonnull CreateDoiContact createDoiContact) throws ApiException {
    this.createDoiContact(createDoiContact, Collections.emptyMap());
  }


  /**
   * Create Contact via DOI (Double-Opt-In) Flow
   * 
   * @param createDoiContact Values to create the Double opt-in (DOI) contact (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void createDoiContact(@jakarta.annotation.Nonnull CreateDoiContact createDoiContact, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createDoiContact;
    
    // verify the required parameter 'createDoiContact' is set
    if (createDoiContact == null) {
      throw new ApiException(400, "Missing the required parameter 'createDoiContact' when calling createDoiContact");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/doubleOptinConfirmation";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Create a folder
   * 
   * @param createFolder Name of the folder (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createFolder(@jakarta.annotation.Nonnull CreateUpdateFolder createFolder) throws ApiException {
    return this.createFolder(createFolder, Collections.emptyMap());
  }


  /**
   * Create a folder
   * 
   * @param createFolder Name of the folder (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createFolder(@jakarta.annotation.Nonnull CreateUpdateFolder createFolder, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createFolder;
    
    // verify the required parameter 'createFolder' is set
    if (createFolder == null) {
      throw new ApiException(400, "Missing the required parameter 'createFolder' when calling createFolder");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/folders";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create a list
   * 
   * @param createList Values to create a list (required)
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createList(@jakarta.annotation.Nonnull CreateList createList) throws ApiException {
    return this.createList(createList, Collections.emptyMap());
  }


  /**
   * Create a list
   * 
   * @param createList Values to create a list (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreateModel
   * @throws ApiException if fails to make API call
   */
  public CreateModel createList(@jakarta.annotation.Nonnull CreateList createList, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createList;
    
    // verify the required parameter 'createList' is set
    if (createList == null) {
      throw new ApiException(400, "Missing the required parameter 'createList' when calling createList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreateModel> localVarReturnType = new TypeReference<CreateModel>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete an attribute
   * 
   * @param attributeCategory Category of the attribute (required)
   * @param attributeName Name of the existing attribute (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteAttribute(@jakarta.annotation.Nonnull String attributeCategory, @jakarta.annotation.Nonnull String attributeName) throws ApiException {
    this.deleteAttribute(attributeCategory, attributeName, Collections.emptyMap());
  }


  /**
   * Delete an attribute
   * 
   * @param attributeCategory Category of the attribute (required)
   * @param attributeName Name of the existing attribute (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteAttribute(@jakarta.annotation.Nonnull String attributeCategory, @jakarta.annotation.Nonnull String attributeName, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'attributeCategory' is set
    if (attributeCategory == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeCategory' when calling deleteAttribute");
    }
    
    // verify the required parameter 'attributeName' is set
    if (attributeName == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeName' when calling deleteAttribute");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}"
      .replaceAll("\\{" + "attributeCategory" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeCategory)))
      .replaceAll("\\{" + "attributeName" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete a contact
   * There are 2 ways to delete a contact &lt;br&gt;&lt;br&gt; Option 1- https://api.brevo.com/v3/contacts/{identifier} &lt;br&gt;&lt;br&gt; Option 2- https://api.brevo.com/v3/contacts/{identifier}?identifierType&#x3D;{} &lt;br&gt; &lt;br&gt; Option 1 only works if identifierType is email_id (for EMAIL) or contact_id (for ID of the contact),where you can directly pass the value of EMAIL and ID of the contact.   &lt;br&gt;&lt;br&gt; Option 2 works for all identifierType, use email_id for EMAIL attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute.
   * @param identifier Email (urlencoded) OR ID of the contact OR EXT_ID attribute (urlencoded) (required)
   * @param identifierType email_id for Email, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute (optional)
   * @throws ApiException if fails to make API call
   */
  public void deleteContact(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nullable String identifierType) throws ApiException {
    this.deleteContact(identifier, identifierType, Collections.emptyMap());
  }


  /**
   * Delete a contact
   * There are 2 ways to delete a contact &lt;br&gt;&lt;br&gt; Option 1- https://api.brevo.com/v3/contacts/{identifier} &lt;br&gt;&lt;br&gt; Option 2- https://api.brevo.com/v3/contacts/{identifier}?identifierType&#x3D;{} &lt;br&gt; &lt;br&gt; Option 1 only works if identifierType is email_id (for EMAIL) or contact_id (for ID of the contact),where you can directly pass the value of EMAIL and ID of the contact.   &lt;br&gt;&lt;br&gt; Option 2 works for all identifierType, use email_id for EMAIL attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute.
   * @param identifier Email (urlencoded) OR ID of the contact OR EXT_ID attribute (urlencoded) (required)
   * @param identifierType email_id for Email, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteContact(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nullable String identifierType, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling deleteContact");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/{identifier}"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("identifierType", identifierType));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete a folder (and all its lists)
   * 
   * @param folderId Id of the folder (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteFolder(@jakarta.annotation.Nonnull Long folderId) throws ApiException {
    this.deleteFolder(folderId, Collections.emptyMap());
  }


  /**
   * Delete a folder (and all its lists)
   * 
   * @param folderId Id of the folder (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteFolder(@jakarta.annotation.Nonnull Long folderId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'folderId' is set
    if (folderId == null) {
      throw new ApiException(400, "Missing the required parameter 'folderId' when calling deleteFolder");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/folders/{folderId}"
      .replaceAll("\\{" + "folderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(folderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete a list
   * 
   * @param listId Id of the list (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteList(@jakarta.annotation.Nonnull Long listId) throws ApiException {
    this.deleteList(listId, Collections.emptyMap());
  }


  /**
   * Delete a list
   * 
   * @param listId Id of the list (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteList(@jakarta.annotation.Nonnull Long listId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'listId' is set
    if (listId == null) {
      throw new ApiException(400, "Missing the required parameter 'listId' when calling deleteList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists/{listId}"
      .replaceAll("\\{" + "listId" + "\\}", apiClient.escapeString(apiClient.parameterToString(listId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete a multiple-choice attribute option
   * 
   * @param attributeType Type of the attribute (required)
   * @param multipleChoiceAttribute Name of the existing muliple-choice attribute (required)
   * @param multipleChoiceAttributeOption Name of the existing multiple-choice attribute option that you want to delete (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteMultiAttributeOptions(@jakarta.annotation.Nonnull String attributeType, @jakarta.annotation.Nonnull String multipleChoiceAttribute, @jakarta.annotation.Nonnull String multipleChoiceAttributeOption) throws ApiException {
    this.deleteMultiAttributeOptions(attributeType, multipleChoiceAttribute, multipleChoiceAttributeOption, Collections.emptyMap());
  }


  /**
   * Delete a multiple-choice attribute option
   * 
   * @param attributeType Type of the attribute (required)
   * @param multipleChoiceAttribute Name of the existing muliple-choice attribute (required)
   * @param multipleChoiceAttributeOption Name of the existing multiple-choice attribute option that you want to delete (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteMultiAttributeOptions(@jakarta.annotation.Nonnull String attributeType, @jakarta.annotation.Nonnull String multipleChoiceAttribute, @jakarta.annotation.Nonnull String multipleChoiceAttributeOption, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'attributeType' is set
    if (attributeType == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeType' when calling deleteMultiAttributeOptions");
    }
    
    // verify the required parameter 'multipleChoiceAttribute' is set
    if (multipleChoiceAttribute == null) {
      throw new ApiException(400, "Missing the required parameter 'multipleChoiceAttribute' when calling deleteMultiAttributeOptions");
    }
    
    // verify the required parameter 'multipleChoiceAttributeOption' is set
    if (multipleChoiceAttributeOption == null) {
      throw new ApiException(400, "Missing the required parameter 'multipleChoiceAttributeOption' when calling deleteMultiAttributeOptions");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/attributes/{attributeType}/{multipleChoiceAttribute}/{multipleChoiceAttributeOption}"
      .replaceAll("\\{" + "attributeType" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeType)))
      .replaceAll("\\{" + "multipleChoiceAttribute" + "\\}", apiClient.escapeString(apiClient.parameterToString(multipleChoiceAttribute)))
      .replaceAll("\\{" + "multipleChoiceAttributeOption" + "\\}", apiClient.escapeString(apiClient.parameterToString(multipleChoiceAttributeOption)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * List all attributes
   * 
   * @return GetAttributes
   * @throws ApiException if fails to make API call
   */
  public GetAttributes getAttributes() throws ApiException {
    return this.getAttributes(Collections.emptyMap());
  }


  /**
   * List all attributes
   * 
   * @param additionalHeaders additionalHeaders for this call
   * @return GetAttributes
   * @throws ApiException if fails to make API call
   */
  public GetAttributes getAttributes(Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/contacts/attributes";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetAttributes> localVarReturnType = new TypeReference<GetAttributes>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get a contact&#39;s details
   * There are 2 ways to get a contact &lt;br&gt;&lt;br&gt; Option 1- https://api.brevo.com/v3/contacts/{identifier} &lt;br&gt;&lt;br&gt; Option 2- https://api.brevo.com/v3/contacts/{identifier}?identifierType&#x3D;{} &lt;br&gt; &lt;br&gt; Option 1 only works if identifierType is email_id (for EMAIL), phone_id (for SMS) or contact_id (for ID of the contact),where you can directly pass the value of EMAIL, SMS and ID of the contact.   &lt;br&gt;&lt;br&gt; Option 2 works for all identifierType, use email_id for EMAIL attribute, phone_id for SMS attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute &lt;br&gt;&lt;br&gt;Along with the contact details, this endpoint will show the statistics of contact for the recent 90 days by default. To fetch the earlier statistics, please use Get contact campaign stats &#x60;&#x60;https://developers.brevo.com/reference/contacts-7#getcontactstats&#x60;&#x60; endpoint with the appropriate date ranges.
   * @param identifier Email (urlencoded) OR ID of the contact OR its SMS attribute value OR EXT_ID attribute (urlencoded) (required)
   * @param identifierType email_id for Email, phone_id for SMS attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute (optional)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be greater than equal to startDate.  (optional)
   * @return GetExtendedContactDetails
   * @throws ApiException if fails to make API call
   */
  public GetExtendedContactDetails getContactInfo(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nullable String identifierType, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate) throws ApiException {
    return this.getContactInfo(identifier, identifierType, startDate, endDate, Collections.emptyMap());
  }


  /**
   * Get a contact&#39;s details
   * There are 2 ways to get a contact &lt;br&gt;&lt;br&gt; Option 1- https://api.brevo.com/v3/contacts/{identifier} &lt;br&gt;&lt;br&gt; Option 2- https://api.brevo.com/v3/contacts/{identifier}?identifierType&#x3D;{} &lt;br&gt; &lt;br&gt; Option 1 only works if identifierType is email_id (for EMAIL), phone_id (for SMS) or contact_id (for ID of the contact),where you can directly pass the value of EMAIL, SMS and ID of the contact.   &lt;br&gt;&lt;br&gt; Option 2 works for all identifierType, use email_id for EMAIL attribute, phone_id for SMS attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute &lt;br&gt;&lt;br&gt;Along with the contact details, this endpoint will show the statistics of contact for the recent 90 days by default. To fetch the earlier statistics, please use Get contact campaign stats &#x60;&#x60;https://developers.brevo.com/reference/contacts-7#getcontactstats&#x60;&#x60; endpoint with the appropriate date ranges.
   * @param identifier Email (urlencoded) OR ID of the contact OR its SMS attribute value OR EXT_ID attribute (urlencoded) (required)
   * @param identifierType email_id for Email, phone_id for SMS attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE_NUMBER attribute (optional)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be greater than equal to startDate.  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetExtendedContactDetails
   * @throws ApiException if fails to make API call
   */
  public GetExtendedContactDetails getContactInfo(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nullable String identifierType, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling getContactInfo");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/{identifier}"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("identifierType", identifierType));
    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetExtendedContactDetails> localVarReturnType = new TypeReference<GetExtendedContactDetails>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get email campaigns&#39; statistics for a contact
   * 
   * @param identifier Email (urlencoded) OR ID of the contact (required)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be greater than equal to startDate. Maximum difference between startDate and endDate should not be greater than 90 days  (optional)
   * @return GetContactCampaignStats
   * @throws ApiException if fails to make API call
   */
  public GetContactCampaignStats getContactStats(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate) throws ApiException {
    return this.getContactStats(identifier, startDate, endDate, Collections.emptyMap());
  }


  /**
   * Get email campaigns&#39; statistics for a contact
   * 
   * @param identifier Email (urlencoded) OR ID of the contact (required)
   * @param startDate **Mandatory if endDate is used.** Starting date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be lower than equal to endDate  (optional)
   * @param endDate **Mandatory if startDate is used.** Ending date (YYYY-MM-DD) of the statistic events specific to campaigns. Must be greater than equal to startDate. Maximum difference between startDate and endDate should not be greater than 90 days  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetContactCampaignStats
   * @throws ApiException if fails to make API call
   */
  public GetContactCampaignStats getContactStats(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling getContactStats");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/{identifier}/campaignStats"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetContactCampaignStats> localVarReturnType = new TypeReference<GetContactCampaignStats>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all the contacts
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param modifiedSince Filter (urlencoded) the contacts modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the contacts created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param segmentId Id of the segment. **Either listIds or segmentId can be passed.** (optional)
   * @param listIds Ids of the list. **Either listIds or segmentId can be passed.** (optional)
   * @param filter Filter the contacts on the basis of attributes. **Allowed operator: equals. For multiple-choice options, the filter will apply an AND condition between the options. For category attributes, the filter will work with both id and value. (e.g. filter&#x3D;equals(FIRSTNAME,\&quot;Antoine\&quot;), filter&#x3D;equals(B1, true), filter&#x3D;equals(DOB, \&quot;1989-11-23\&quot;), filter&#x3D;equals(GENDER, \&quot;1\&quot;), filter&#x3D;equals(GENDER, \&quot;MALE\&quot;), filter&#x3D;equals(COUNTRY,\&quot;USA, INDIA\&quot;)**  (optional)
   * @return GetContacts
   * @throws ApiException if fails to make API call
   */
  public GetContacts getContacts(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable Long segmentId, @jakarta.annotation.Nullable List<Long> listIds, @jakarta.annotation.Nullable String filter) throws ApiException {
    return this.getContacts(limit, offset, modifiedSince, createdSince, sort, segmentId, listIds, filter, Collections.emptyMap());
  }


  /**
   * Get all the contacts
   * 
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param modifiedSince Filter (urlencoded) the contacts modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param createdSince Filter (urlencoded) the contacts created after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param segmentId Id of the segment. **Either listIds or segmentId can be passed.** (optional)
   * @param listIds Ids of the list. **Either listIds or segmentId can be passed.** (optional)
   * @param filter Filter the contacts on the basis of attributes. **Allowed operator: equals. For multiple-choice options, the filter will apply an AND condition between the options. For category attributes, the filter will work with both id and value. (e.g. filter&#x3D;equals(FIRSTNAME,\&quot;Antoine\&quot;), filter&#x3D;equals(B1, true), filter&#x3D;equals(DOB, \&quot;1989-11-23\&quot;), filter&#x3D;equals(GENDER, \&quot;1\&quot;), filter&#x3D;equals(GENDER, \&quot;MALE\&quot;), filter&#x3D;equals(COUNTRY,\&quot;USA, INDIA\&quot;)**  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetContacts
   * @throws ApiException if fails to make API call
   */
  public GetContacts getContacts(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable String createdSince, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable Long segmentId, @jakarta.annotation.Nullable List<Long> listIds, @jakarta.annotation.Nullable String filter, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/contacts";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("modifiedSince", modifiedSince));
    localVarQueryParams.addAll(apiClient.parameterToPair("createdSince", createdSince));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("segmentId", segmentId));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "listIds", listIds));
    localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetContacts> localVarReturnType = new TypeReference<GetContacts>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get contacts in a list
   * 
   * @param listId Id of the list (required)
   * @param modifiedSince Filter (urlencoded) the contacts modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetContacts
   * @throws ApiException if fails to make API call
   */
  public GetContacts getContactsFromList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getContactsFromList(listId, modifiedSince, limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Get contacts in a list
   * 
   * @param listId Id of the list (required)
   * @param modifiedSince Filter (urlencoded) the contacts modified after a given UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ). **Prefer to pass your timezone in date-time format for accurate result.**  (optional)
   * @param limit Number of documents per page (optional, default to 50)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetContacts
   * @throws ApiException if fails to make API call
   */
  public GetContacts getContactsFromList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nullable String modifiedSince, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'listId' is set
    if (listId == null) {
      throw new ApiException(400, "Missing the required parameter 'listId' when calling getContactsFromList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists/{listId}/contacts"
      .replaceAll("\\{" + "listId" + "\\}", apiClient.escapeString(apiClient.parameterToString(listId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("modifiedSince", modifiedSince));
    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetContacts> localVarReturnType = new TypeReference<GetContacts>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Returns a folder&#39;s details
   * 
   * @param folderId id of the folder (required)
   * @return GetFolder
   * @throws ApiException if fails to make API call
   */
  public GetFolder getFolder(@jakarta.annotation.Nonnull Long folderId) throws ApiException {
    return this.getFolder(folderId, Collections.emptyMap());
  }


  /**
   * Returns a folder&#39;s details
   * 
   * @param folderId id of the folder (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetFolder
   * @throws ApiException if fails to make API call
   */
  public GetFolder getFolder(@jakarta.annotation.Nonnull Long folderId, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'folderId' is set
    if (folderId == null) {
      throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolder");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/folders/{folderId}"
      .replaceAll("\\{" + "folderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(folderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetFolder> localVarReturnType = new TypeReference<GetFolder>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get lists in a folder
   * 
   * @param folderId Id of the folder (required)
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetFolderLists
   * @throws ApiException if fails to make API call
   */
  public GetFolderLists getFolderLists(@jakarta.annotation.Nonnull Long folderId, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getFolderLists(folderId, limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Get lists in a folder
   * 
   * @param folderId Id of the folder (required)
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetFolderLists
   * @throws ApiException if fails to make API call
   */
  public GetFolderLists getFolderLists(@jakarta.annotation.Nonnull Long folderId, @jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'folderId' is set
    if (folderId == null) {
      throw new ApiException(400, "Missing the required parameter 'folderId' when calling getFolderLists");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/folders/{folderId}/lists"
      .replaceAll("\\{" + "folderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(folderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetFolderLists> localVarReturnType = new TypeReference<GetFolderLists>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all folders
   * 
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetFolders
   * @throws ApiException if fails to make API call
   */
  public GetFolders getFolders(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getFolders(limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Get all folders
   * 
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetFolders
   * @throws ApiException if fails to make API call
   */
  public GetFolders getFolders(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/contacts/folders";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetFolders> localVarReturnType = new TypeReference<GetFolders>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get a list&#39;s details
   * 
   * @param listId Id of the list (required)
   * @param startDate **Mandatory if endDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to aggregate the sent email campaigns for a specific list id. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to aggregate the sent email campaigns for a specific list id. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @return GetExtendedList
   * @throws ApiException if fails to make API call
   */
  public GetExtendedList getList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate) throws ApiException {
    return this.getList(listId, startDate, endDate, Collections.emptyMap());
  }


  /**
   * Get a list&#39;s details
   * 
   * @param listId Id of the list (required)
   * @param startDate **Mandatory if endDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to aggregate the sent email campaigns for a specific list id. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param endDate **Mandatory if startDate is used**. Ending (urlencoded) UTC date-time (YYYY-MM-DDTHH:mm:ss.SSSZ) to aggregate the sent email campaigns for a specific list id. **Prefer to pass your timezone in date-time format for accurate result**  (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetExtendedList
   * @throws ApiException if fails to make API call
   */
  public GetExtendedList getList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nullable String startDate, @jakarta.annotation.Nullable String endDate, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'listId' is set
    if (listId == null) {
      throw new ApiException(400, "Missing the required parameter 'listId' when calling getList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists/{listId}"
      .replaceAll("\\{" + "listId" + "\\}", apiClient.escapeString(apiClient.parameterToString(listId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("startDate", startDate));
    localVarQueryParams.addAll(apiClient.parameterToPair("endDate", endDate));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetExtendedList> localVarReturnType = new TypeReference<GetExtendedList>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all the lists
   * 
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetLists
   * @throws ApiException if fails to make API call
   */
  public GetLists getLists(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getLists(limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Get all the lists
   * 
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetLists
   * @throws ApiException if fails to make API call
   */
  public GetLists getLists(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/contacts/lists";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetLists> localVarReturnType = new TypeReference<GetLists>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get all the segments
   * 
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @return GetSegments
   * @throws ApiException if fails to make API call
   */
  public GetSegments getSegments(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.getSegments(limit, offset, sort, Collections.emptyMap());
  }


  /**
   * Get all the segments
   * 
   * @param limit Number of documents per page (optional, default to 10)
   * @param offset Index of the first document of the page (optional, default to 0)
   * @param sort Sort the results in the ascending/descending order of record creation. Default order is **descending** if &#x60;sort&#x60; is not passed (optional, default to desc)
   * @param additionalHeaders additionalHeaders for this call
   * @return GetSegments
   * @throws ApiException if fails to make API call
   */
  public GetSegments getSegments(@jakarta.annotation.Nullable Long limit, @jakarta.annotation.Nullable Long offset, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/contacts/segments";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<GetSegments> localVarReturnType = new TypeReference<GetSegments>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Import contacts
   * It returns the background process ID which on completion calls the notify URL that you have set in the input.  **Note**: - Any contact attribute that doesn&#39;t exist in your account will be ignored at import end. 
   * @param requestContactImport Values to import contacts in Brevo. To know more about the expected format, please have a look at &#x60;&#x60;https://help.brevo.com/hc/en-us/articles/209499265-Build-contacts-lists-for-your-email-marketing-campaigns&#x60;&#x60; (required)
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId importContacts(@jakarta.annotation.Nonnull RequestContactImport requestContactImport) throws ApiException {
    return this.importContacts(requestContactImport, Collections.emptyMap());
  }


  /**
   * Import contacts
   * It returns the background process ID which on completion calls the notify URL that you have set in the input.  **Note**: - Any contact attribute that doesn&#39;t exist in your account will be ignored at import end. 
   * @param requestContactImport Values to import contacts in Brevo. To know more about the expected format, please have a look at &#x60;&#x60;https://help.brevo.com/hc/en-us/articles/209499265-Build-contacts-lists-for-your-email-marketing-campaigns&#x60;&#x60; (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId importContacts(@jakarta.annotation.Nonnull RequestContactImport requestContactImport, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = requestContactImport;
    
    // verify the required parameter 'requestContactImport' is set
    if (requestContactImport == null) {
      throw new ApiException(400, "Missing the required parameter 'requestContactImport' when calling importContacts");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/import";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete a contact from a list
   * 
   * @param listId Id of the list (required)
   * @param contactEmails Emails adresses OR IDs OR EXT_ID attributes of the contacts OR &#39;all&#39; true (required)
   * @return PostContactInfo
   * @throws ApiException if fails to make API call
   */
  public PostContactInfo removeContactFromList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nonnull RemoveContactFromListRequest contactEmails) throws ApiException {
    return this.removeContactFromList(listId, contactEmails, Collections.emptyMap());
  }


  /**
   * Delete a contact from a list
   * 
   * @param listId Id of the list (required)
   * @param contactEmails Emails adresses OR IDs OR EXT_ID attributes of the contacts OR &#39;all&#39; true (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return PostContactInfo
   * @throws ApiException if fails to make API call
   */
  public PostContactInfo removeContactFromList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nonnull RemoveContactFromListRequest contactEmails, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = contactEmails;
    
    // verify the required parameter 'listId' is set
    if (listId == null) {
      throw new ApiException(400, "Missing the required parameter 'listId' when calling removeContactFromList");
    }
    
    // verify the required parameter 'contactEmails' is set
    if (contactEmails == null) {
      throw new ApiException(400, "Missing the required parameter 'contactEmails' when calling removeContactFromList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists/{listId}/contacts/remove"
      .replaceAll("\\{" + "listId" + "\\}", apiClient.escapeString(apiClient.parameterToString(listId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<PostContactInfo> localVarReturnType = new TypeReference<PostContactInfo>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Export contacts
   * It returns the background process ID which on completion calls the notify URL that you have set in the input. File will be available in csv.
   * @param requestContactExport Values to request a contact export (required)
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId requestContactExport(@jakarta.annotation.Nonnull RequestContactExport requestContactExport) throws ApiException {
    return this.requestContactExport(requestContactExport, Collections.emptyMap());
  }


  /**
   * Export contacts
   * It returns the background process ID which on completion calls the notify URL that you have set in the input. File will be available in csv.
   * @param requestContactExport Values to request a contact export (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return CreatedProcessId
   * @throws ApiException if fails to make API call
   */
  public CreatedProcessId requestContactExport(@jakarta.annotation.Nonnull RequestContactExport requestContactExport, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = requestContactExport;
    
    // verify the required parameter 'requestContactExport' is set
    if (requestContactExport == null) {
      throw new ApiException(400, "Missing the required parameter 'requestContactExport' when calling requestContactExport");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/export";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<CreatedProcessId> localVarReturnType = new TypeReference<CreatedProcessId>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update contact attribute
   * 
   * @param attributeCategory Category of the attribute (required)
   * @param attributeName Name of the existing attribute (required)
   * @param updateAttribute Values to update an attribute (required)
   * @throws ApiException if fails to make API call
   */
  public void updateAttribute(@jakarta.annotation.Nonnull String attributeCategory, @jakarta.annotation.Nonnull String attributeName, @jakarta.annotation.Nonnull UpdateAttribute updateAttribute) throws ApiException {
    this.updateAttribute(attributeCategory, attributeName, updateAttribute, Collections.emptyMap());
  }


  /**
   * Update contact attribute
   * 
   * @param attributeCategory Category of the attribute (required)
   * @param attributeName Name of the existing attribute (required)
   * @param updateAttribute Values to update an attribute (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateAttribute(@jakarta.annotation.Nonnull String attributeCategory, @jakarta.annotation.Nonnull String attributeName, @jakarta.annotation.Nonnull UpdateAttribute updateAttribute, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateAttribute;
    
    // verify the required parameter 'attributeCategory' is set
    if (attributeCategory == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeCategory' when calling updateAttribute");
    }
    
    // verify the required parameter 'attributeName' is set
    if (attributeName == null) {
      throw new ApiException(400, "Missing the required parameter 'attributeName' when calling updateAttribute");
    }
    
    // verify the required parameter 'updateAttribute' is set
    if (updateAttribute == null) {
      throw new ApiException(400, "Missing the required parameter 'updateAttribute' when calling updateAttribute");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/attributes/{attributeCategory}/{attributeName}"
      .replaceAll("\\{" + "attributeCategory" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeCategory)))
      .replaceAll("\\{" + "attributeName" + "\\}", apiClient.escapeString(apiClient.parameterToString(attributeName)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update multiple contacts
   * 
   * @param updateBatchContacts Values to update multiple contacts (required)
   * @throws ApiException if fails to make API call
   */
  public void updateBatchContacts(@jakarta.annotation.Nonnull UpdateBatchContacts updateBatchContacts) throws ApiException {
    this.updateBatchContacts(updateBatchContacts, Collections.emptyMap());
  }


  /**
   * Update multiple contacts
   * 
   * @param updateBatchContacts Values to update multiple contacts (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateBatchContacts(@jakarta.annotation.Nonnull UpdateBatchContacts updateBatchContacts, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateBatchContacts;
    
    // verify the required parameter 'updateBatchContacts' is set
    if (updateBatchContacts == null) {
      throw new ApiException(400, "Missing the required parameter 'updateBatchContacts' when calling updateBatchContacts");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/batch";

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update a contact
   * There are 2 ways to update a contact &lt;br&gt;&lt;br&gt; Option 1- https://api.brevo.com/v3/contacts/{identifier} &lt;br&gt;&lt;br&gt; Option 2- https://api.brevo.com/v3/contacts/{identifier}?identifierType&#x3D;{} &lt;br&gt; &lt;br&gt; Option 1 only works if identifierType is email_id (for EMAIL) or contact_id (for ID of the contact),where you can directly pass the value of EMAIL and ID of the contact.   &lt;br&gt;&lt;br&gt; Option 2 works for all identifierType, use email_id for EMAIL attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE attribute
   * @param identifier Email (urlencoded) OR ID of the contact OR EXT_ID attribute (urlencoded) OR its SMS attribute value OR its WHATSAPP attribute value OR its LANDLINE attribute value (required)
   * @param updateContact Values to update a contact (required)
   * @param identifierType email_id for Email, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE attribute (optional)
   * @throws ApiException if fails to make API call
   */
  public void updateContact(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nonnull UpdateContact updateContact, @jakarta.annotation.Nullable String identifierType) throws ApiException {
    this.updateContact(identifier, updateContact, identifierType, Collections.emptyMap());
  }


  /**
   * Update a contact
   * There are 2 ways to update a contact &lt;br&gt;&lt;br&gt; Option 1- https://api.brevo.com/v3/contacts/{identifier} &lt;br&gt;&lt;br&gt; Option 2- https://api.brevo.com/v3/contacts/{identifier}?identifierType&#x3D;{} &lt;br&gt; &lt;br&gt; Option 1 only works if identifierType is email_id (for EMAIL) or contact_id (for ID of the contact),where you can directly pass the value of EMAIL and ID of the contact.   &lt;br&gt;&lt;br&gt; Option 2 works for all identifierType, use email_id for EMAIL attribute, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE attribute
   * @param identifier Email (urlencoded) OR ID of the contact OR EXT_ID attribute (urlencoded) OR its SMS attribute value OR its WHATSAPP attribute value OR its LANDLINE attribute value (required)
   * @param updateContact Values to update a contact (required)
   * @param identifierType email_id for Email, contact_id for ID of the contact, ext_id for EXT_ID attribute, phone_id for SMS attribute, whatsapp_id for WHATSAPP attribute, landline_number_id for LANDLINE attribute (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateContact(@jakarta.annotation.Nonnull GetContactInfoIdentifierParameter identifier, @jakarta.annotation.Nonnull UpdateContact updateContact, @jakarta.annotation.Nullable String identifierType, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateContact;
    
    // verify the required parameter 'identifier' is set
    if (identifier == null) {
      throw new ApiException(400, "Missing the required parameter 'identifier' when calling updateContact");
    }
    
    // verify the required parameter 'updateContact' is set
    if (updateContact == null) {
      throw new ApiException(400, "Missing the required parameter 'updateContact' when calling updateContact");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/{identifier}"
      .replaceAll("\\{" + "identifier" + "\\}", apiClient.escapeString(apiClient.parameterToString(identifier)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("identifierType", identifierType));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update a folder
   * 
   * @param folderId Id of the folder (required)
   * @param updateFolder Name of the folder (required)
   * @throws ApiException if fails to make API call
   */
  public void updateFolder(@jakarta.annotation.Nonnull Long folderId, @jakarta.annotation.Nonnull CreateUpdateFolder updateFolder) throws ApiException {
    this.updateFolder(folderId, updateFolder, Collections.emptyMap());
  }


  /**
   * Update a folder
   * 
   * @param folderId Id of the folder (required)
   * @param updateFolder Name of the folder (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateFolder(@jakarta.annotation.Nonnull Long folderId, @jakarta.annotation.Nonnull CreateUpdateFolder updateFolder, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateFolder;
    
    // verify the required parameter 'folderId' is set
    if (folderId == null) {
      throw new ApiException(400, "Missing the required parameter 'folderId' when calling updateFolder");
    }
    
    // verify the required parameter 'updateFolder' is set
    if (updateFolder == null) {
      throw new ApiException(400, "Missing the required parameter 'updateFolder' when calling updateFolder");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/folders/{folderId}"
      .replaceAll("\\{" + "folderId" + "\\}", apiClient.escapeString(apiClient.parameterToString(folderId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Update a list
   * 
   * @param listId Id of the list (required)
   * @param updateList Values to update a list (required)
   * @throws ApiException if fails to make API call
   */
  public void updateList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nonnull UpdateList updateList) throws ApiException {
    this.updateList(listId, updateList, Collections.emptyMap());
  }


  /**
   * Update a list
   * 
   * @param listId Id of the list (required)
   * @param updateList Values to update a list (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void updateList(@jakarta.annotation.Nonnull Long listId, @jakarta.annotation.Nonnull UpdateList updateList, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateList;
    
    // verify the required parameter 'listId' is set
    if (listId == null) {
      throw new ApiException(400, "Missing the required parameter 'listId' when calling updateList");
    }
    
    // verify the required parameter 'updateList' is set
    if (updateList == null) {
      throw new ApiException(400, "Missing the required parameter 'updateList' when calling updateList");
    }
    
    // create path and map variables
    String localVarPath = "/contacts/lists/{listId}"
      .replaceAll("\\{" + "listId" + "\\}", apiClient.escapeString(apiClient.parameterToString(listId)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
