/*
 * Brevo API
 * Brevo API documentation by XDEV Software based on https://api.brevo.com/v3/swagger_definition_v3.yml
 *
 * The version of the OpenAPI document: 3.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package software.xdev.brevo.api;

import com.fasterxml.jackson.core.type.TypeReference;

import software.xdev.brevo.client.ApiException;
import software.xdev.brevo.client.ApiClient;
import software.xdev.brevo.client.BaseApi;
import software.xdev.brevo.client.Configuration;
import software.xdev.brevo.client.Pair;

import software.xdev.brevo.model.Balance;
import software.xdev.brevo.model.BalanceDefinition;
import software.xdev.brevo.model.BalanceDefinitionPage;
import software.xdev.brevo.model.BalanceLimit;
import software.xdev.brevo.model.BalanceOrder;
import software.xdev.brevo.model.ContactBalancesResp;
import software.xdev.brevo.model.CreateBalanceDefinitionPayload;
import software.xdev.brevo.model.CreateBalanceLimitPayload;
import software.xdev.brevo.model.CreateBalancePayload;
import software.xdev.brevo.model.CreateOrderPayload;
import software.xdev.brevo.model.CreateTransactionPayload;
import software.xdev.brevo.model.ErrorResponse;
import software.xdev.brevo.model.ModelSubscriptionBalanceResp;
import software.xdev.brevo.model.Transaction;
import software.xdev.brevo.model.TransactionHistoryResp;
import java.util.UUID;
import software.xdev.brevo.model.UpdateBalanceDefinitionPayload;
import software.xdev.brevo.model.UpdateBalanceLimitPayload;


import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class BalanceApi extends BaseApi {

  public BalanceApi() {
    super(Configuration.getDefaultApiClient());
  }

  public BalanceApi(ApiClient apiClient) {
    super(apiClient);
  }

  /**
   * Create new transaction
   * Creates new transaction and returns information
   * @param pid Loyalty Program Id (required)
   * @param createTransactionPayload Transaction Payload (required)
   * @return Transaction
   * @throws ApiException if fails to make API call
   */
  public Transaction beginTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateTransactionPayload createTransactionPayload) throws ApiException {
    return this.beginTransaction(pid, createTransactionPayload, Collections.emptyMap());
  }


  /**
   * Create new transaction
   * Creates new transaction and returns information
   * @param pid Loyalty Program Id (required)
   * @param createTransactionPayload Transaction Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Transaction
   * @throws ApiException if fails to make API call
   */
  public Transaction beginTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateTransactionPayload createTransactionPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createTransactionPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling beginTransaction");
    }
    
    // verify the required parameter 'createTransactionPayload' is set
    if (createTransactionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createTransactionPayload' when calling beginTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/transactions"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Transaction> localVarReturnType = new TypeReference<Transaction>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Cancel transaction
   * Cancels transaction
   * @param pid Loyalty Program Id (required)
   * @param tid Transaction Id (required)
   * @return Transaction
   * @throws ApiException if fails to make API call
   */
  public Transaction cancelTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid) throws ApiException {
    return this.cancelTransaction(pid, tid, Collections.emptyMap());
  }


  /**
   * Cancel transaction
   * Cancels transaction
   * @param pid Loyalty Program Id (required)
   * @param tid Transaction Id (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Transaction
   * @throws ApiException if fails to make API call
   */
  public Transaction cancelTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling cancelTransaction");
    }
    
    // verify the required parameter 'tid' is set
    if (tid == null) {
      throw new ApiException(400, "Missing the required parameter 'tid' when calling cancelTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/transactions/{tid}/cancel"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "tid" + "\\}", apiClient.escapeString(apiClient.parameterToString(tid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Transaction> localVarReturnType = new TypeReference<Transaction>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Complete transaction
   * Completes transaction
   * @param pid Loyalty Program Id (required)
   * @param tid Transaction Id (required)
   * @return Transaction
   * @throws ApiException if fails to make API call
   */
  public Transaction completeTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid) throws ApiException {
    return this.completeTransaction(pid, tid, Collections.emptyMap());
  }


  /**
   * Complete transaction
   * Completes transaction
   * @param pid Loyalty Program Id (required)
   * @param tid Transaction Id (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Transaction
   * @throws ApiException if fails to make API call
   */
  public Transaction completeTransaction(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID tid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling completeTransaction");
    }
    
    // verify the required parameter 'tid' is set
    if (tid == null) {
      throw new ApiException(400, "Missing the required parameter 'tid' when calling completeTransaction");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/transactions/{tid}/complete"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "tid" + "\\}", apiClient.escapeString(apiClient.parameterToString(tid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Transaction> localVarReturnType = new TypeReference<Transaction>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create balance limits
   * Creates balance limit and sends the created UUID along with the data
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param createBalanceLimitPayload Balance Definition Payload (required)
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit createBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull CreateBalanceLimitPayload createBalanceLimitPayload) throws ApiException {
    return this.createBalanceLimit(pid, bdid, createBalanceLimitPayload, Collections.emptyMap());
  }


  /**
   * Create balance limits
   * Creates balance limit and sends the created UUID along with the data
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param createBalanceLimitPayload Balance Definition Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit createBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull CreateBalanceLimitPayload createBalanceLimitPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createBalanceLimitPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling createBalanceLimit");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling createBalanceLimit");
    }
    
    // verify the required parameter 'createBalanceLimitPayload' is set
    if (createBalanceLimitPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createBalanceLimitPayload' when calling createBalanceLimit");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create balance order
   * Returns created order
   * @param pid Loyalty Program Id (required)
   * @param createOrderPayload Order Payload (required)
   * @return BalanceOrder
   * @throws ApiException if fails to make API call
   */
  public BalanceOrder createBalanceOrder(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateOrderPayload createOrderPayload) throws ApiException {
    return this.createBalanceOrder(pid, createOrderPayload, Collections.emptyMap());
  }


  /**
   * Create balance order
   * Returns created order
   * @param pid Loyalty Program Id (required)
   * @param createOrderPayload Order Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceOrder
   * @throws ApiException if fails to make API call
   */
  public BalanceOrder createBalanceOrder(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateOrderPayload createOrderPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createOrderPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling createBalanceOrder");
    }
    
    // verify the required parameter 'createOrderPayload' is set
    if (createOrderPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createOrderPayload' when calling createBalanceOrder");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/create-order"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceOrder> localVarReturnType = new TypeReference<BalanceOrder>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Delete balance definition
   * Delete Balance definition
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteBalanceDefinition(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid) throws ApiException {
    this.deleteBalanceDefinition(pid, bdid, Collections.emptyMap());
  }


  /**
   * Delete balance definition
   * Delete Balance definition
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteBalanceDefinition(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteBalanceDefinition");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling deleteBalanceDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Delete balance limit
   * Delete balance limit
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param blid Balance Limit Id (required)
   * @throws ApiException if fails to make API call
   */
  public void deleteBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UUID blid) throws ApiException {
    this.deleteBalanceLimit(pid, bdid, blid, Collections.emptyMap());
  }


  /**
   * Delete balance limit
   * Delete balance limit
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param blid Balance Limit Id (required)
   * @param additionalHeaders additionalHeaders for this call
   * @throws ApiException if fails to make API call
   */
  public void deleteBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UUID blid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling deleteBalanceLimit");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling deleteBalanceLimit");
    }
    
    // verify the required parameter 'blid' is set
    if (blid == null) {
      throw new ApiException(400, "Missing the required parameter 'blid' when calling deleteBalanceLimit");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)))
      .replaceAll("\\{" + "blid" + "\\}", apiClient.escapeString(apiClient.parameterToString(blid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    apiClient.invokeAPI(
        localVarPath,
        "DELETE",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        null
    );
  }

  /**
   * Get balance definition
   * Returns balance definition
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param version Version (optional, default to draft)
   * @return BalanceDefinition
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinition getBalanceDefinition(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.getBalanceDefinition(pid, bdid, version, Collections.emptyMap());
  }


  /**
   * Get balance definition
   * Returns balance definition
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param version Version (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceDefinition
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinition getBalanceDefinition(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getBalanceDefinition");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling getBalanceDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceDefinition> localVarReturnType = new TypeReference<BalanceDefinition>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get balance definition list
   * Returns balance definition page
   * @param pid Loyalty Program Id (required)
   * @param limit Limit the number of records returned (optional, default to 200)
   * @param offset Offset to paginate records (optional, default to 0)
   * @param sortField Field to sort by (optional, default to updated_at)
   * @param sort Sort direction (optional, default to desc)
   * @param version Version (optional, default to draft)
   * @return BalanceDefinitionPage
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinitionPage getBalanceDefinitionList(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.getBalanceDefinitionList(pid, limit, offset, sortField, sort, version, Collections.emptyMap());
  }


  /**
   * Get balance definition list
   * Returns balance definition page
   * @param pid Loyalty Program Id (required)
   * @param limit Limit the number of records returned (optional, default to 200)
   * @param offset Offset to paginate records (optional, default to 0)
   * @param sortField Field to sort by (optional, default to updated_at)
   * @param sort Sort direction (optional, default to desc)
   * @param version Version (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceDefinitionPage
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinitionPage getBalanceDefinitionList(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getBalanceDefinitionList");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sortField", sortField));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceDefinitionPage> localVarReturnType = new TypeReference<BalanceDefinitionPage>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get balance limits
   * Fetches balance limits and send the created UUID along with the data
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param blid Balance Limit Id (required)
   * @param version Version (optional, default to draft)
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit getBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UUID blid, @jakarta.annotation.Nullable String version) throws ApiException {
    return this.getBalanceLimit(pid, bdid, blid, version, Collections.emptyMap());
  }


  /**
   * Get balance limits
   * Fetches balance limits and send the created UUID along with the data
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param blid Balance Limit Id (required)
   * @param version Version (optional, default to draft)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit getBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UUID blid, @jakarta.annotation.Nullable String version, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getBalanceLimit");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling getBalanceLimit");
    }
    
    // verify the required parameter 'blid' is set
    if (blid == null) {
      throw new ApiException(400, "Missing the required parameter 'blid' when calling getBalanceLimit");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)))
      .replaceAll("\\{" + "blid" + "\\}", apiClient.escapeString(apiClient.parameterToString(blid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("version", version));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get balance list
   * Returns balance list
   * @param pid Loyalty Program Id (required)
   * @return ContactBalancesResp
   * @throws ApiException if fails to make API call
   */
  public ContactBalancesResp getContactBalances(@jakarta.annotation.Nonnull UUID pid) throws ApiException {
    return this.getContactBalances(pid, Collections.emptyMap());
  }


  /**
   * Get balance list
   * Returns balance list
   * @param pid Loyalty Program Id (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return ContactBalancesResp
   * @throws ApiException if fails to make API call
   */
  public ContactBalancesResp getContactBalances(@jakarta.annotation.Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getContactBalances");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/contact-balances"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<ContactBalancesResp> localVarReturnType = new TypeReference<ContactBalancesResp>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get subscription balances
   * Returns subscription balances
   * @param cid Contact Id (required)
   * @param pid Loyalty Program Id (required)
   * @return ModelSubscriptionBalanceResp
   * @throws ApiException if fails to make API call
   */
  public ModelSubscriptionBalanceResp getSubscriptionBalances(@jakarta.annotation.Nonnull Integer cid, @jakarta.annotation.Nonnull UUID pid) throws ApiException {
    return this.getSubscriptionBalances(cid, pid, Collections.emptyMap());
  }


  /**
   * Get subscription balances
   * Returns subscription balances
   * @param cid Contact Id (required)
   * @param pid Loyalty Program Id (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return ModelSubscriptionBalanceResp
   * @throws ApiException if fails to make API call
   */
  public ModelSubscriptionBalanceResp getSubscriptionBalances(@jakarta.annotation.Nonnull Integer cid, @jakarta.annotation.Nonnull UUID pid, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'cid' is set
    if (cid == null) {
      throw new ApiException(400, "Missing the required parameter 'cid' when calling getSubscriptionBalances");
    }
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling getSubscriptionBalances");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/subscriptions/{cid}/balances"
      .replaceAll("\\{" + "cid" + "\\}", apiClient.escapeString(apiClient.parameterToString(cid)))
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<ModelSubscriptionBalanceResp> localVarReturnType = new TypeReference<ModelSubscriptionBalanceResp>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Active Balances API
   * Returns Active Balances
   * @param pid Loyalty Program Id (required)
   * @param contactId Contact ID (required)
   * @param balanceDefinitionId Balance Definition ID (required)
   * @param limit Limit (optional)
   * @param offset Offset (optional)
   * @param sortField Sort Field (optional)
   * @param sort Sort Order (optional)
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit loyaltyBalanceProgramsPidActiveBalanceGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull Integer contactId, @jakarta.annotation.Nonnull UUID balanceDefinitionId, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort) throws ApiException {
    return this.loyaltyBalanceProgramsPidActiveBalanceGet(pid, contactId, balanceDefinitionId, limit, offset, sortField, sort, Collections.emptyMap());
  }


  /**
   * Get Active Balances API
   * Returns Active Balances
   * @param pid Loyalty Program Id (required)
   * @param contactId Contact ID (required)
   * @param balanceDefinitionId Balance Definition ID (required)
   * @param limit Limit (optional)
   * @param offset Offset (optional)
   * @param sortField Sort Field (optional)
   * @param sort Sort Order (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit loyaltyBalanceProgramsPidActiveBalanceGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull Integer contactId, @jakarta.annotation.Nonnull UUID balanceDefinitionId, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidActiveBalanceGet");
    }
    
    // verify the required parameter 'contactId' is set
    if (contactId == null) {
      throw new ApiException(400, "Missing the required parameter 'contactId' when calling loyaltyBalanceProgramsPidActiveBalanceGet");
    }
    
    // verify the required parameter 'balanceDefinitionId' is set
    if (balanceDefinitionId == null) {
      throw new ApiException(400, "Missing the required parameter 'balanceDefinitionId' when calling loyaltyBalanceProgramsPidActiveBalanceGet");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/active-balance"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort_field", sortField));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("contact_id", contactId));
    localVarQueryParams.addAll(apiClient.parameterToPair("balance_definition_id", balanceDefinitionId));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create balance definition
   * Creates balance definition and returns information
   * @param pid Loyalty Program Id (required)
   * @param createBalanceDefinitionPayload Create Balance Definition Payload (required)
   * @return BalanceDefinition
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinition loyaltyBalanceProgramsPidBalanceDefinitionsPost(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateBalanceDefinitionPayload createBalanceDefinitionPayload) throws ApiException {
    return this.loyaltyBalanceProgramsPidBalanceDefinitionsPost(pid, createBalanceDefinitionPayload, Collections.emptyMap());
  }


  /**
   * Create balance definition
   * Creates balance definition and returns information
   * @param pid Loyalty Program Id (required)
   * @param createBalanceDefinitionPayload Create Balance Definition Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceDefinition
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinition loyaltyBalanceProgramsPidBalanceDefinitionsPost(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull CreateBalanceDefinitionPayload createBalanceDefinitionPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createBalanceDefinitionPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidBalanceDefinitionsPost");
    }
    
    // verify the required parameter 'createBalanceDefinitionPayload' is set
    if (createBalanceDefinitionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createBalanceDefinitionPayload' when calling loyaltyBalanceProgramsPidBalanceDefinitionsPost");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceDefinition> localVarReturnType = new TypeReference<BalanceDefinition>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Create subscription balances
   * Creates a balance for a contact
   * @param pid Loyalty Program Id (required)
   * @param cid Contact Id (required)
   * @param createBalancePayload Create Balnce Payload (required)
   * @return Balance
   * @throws ApiException if fails to make API call
   */
  public Balance loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID cid, @jakarta.annotation.Nonnull CreateBalancePayload createBalancePayload) throws ApiException {
    return this.loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost(pid, cid, createBalancePayload, Collections.emptyMap());
  }


  /**
   * Create subscription balances
   * Creates a balance for a contact
   * @param pid Loyalty Program Id (required)
   * @param cid Contact Id (required)
   * @param createBalancePayload Create Balnce Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return Balance
   * @throws ApiException if fails to make API call
   */
  public Balance loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID cid, @jakarta.annotation.Nonnull CreateBalancePayload createBalancePayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = createBalancePayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost");
    }
    
    // verify the required parameter 'cid' is set
    if (cid == null) {
      throw new ApiException(400, "Missing the required parameter 'cid' when calling loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost");
    }
    
    // verify the required parameter 'createBalancePayload' is set
    if (createBalancePayload == null) {
      throw new ApiException(400, "Missing the required parameter 'createBalancePayload' when calling loyaltyBalanceProgramsPidSubscriptionsCidBalancesPost");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/subscriptions/{cid}/balances"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "cid" + "\\}", apiClient.escapeString(apiClient.parameterToString(cid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<Balance> localVarReturnType = new TypeReference<Balance>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Get Transaction History API
   * Returns transaction history
   * @param pid Loyalty Program Id (required)
   * @param contactId Contact ID (required)
   * @param balanceDefinitionId Balance Definition ID (required)
   * @param limit Limit the number of records returned (optional, default to 20)
   * @param offset Skip a number of records (optional, default to 0)
   * @param sortField Field to sort by (optional, default to created_at)
   * @param sort Sort order, either asc or desc (optional, default to desc)
   * @param filters Filters to apply (optional)
   * @return TransactionHistoryResp
   * @throws ApiException if fails to make API call
   */
  public TransactionHistoryResp loyaltyBalanceProgramsPidTransactionHistoryGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull Integer contactId, @jakarta.annotation.Nonnull UUID balanceDefinitionId, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable List<String> filters) throws ApiException {
    return this.loyaltyBalanceProgramsPidTransactionHistoryGet(pid, contactId, balanceDefinitionId, limit, offset, sortField, sort, filters, Collections.emptyMap());
  }


  /**
   * Get Transaction History API
   * Returns transaction history
   * @param pid Loyalty Program Id (required)
   * @param contactId Contact ID (required)
   * @param balanceDefinitionId Balance Definition ID (required)
   * @param limit Limit the number of records returned (optional, default to 20)
   * @param offset Skip a number of records (optional, default to 0)
   * @param sortField Field to sort by (optional, default to created_at)
   * @param sort Sort order, either asc or desc (optional, default to desc)
   * @param filters Filters to apply (optional)
   * @param additionalHeaders additionalHeaders for this call
   * @return TransactionHistoryResp
   * @throws ApiException if fails to make API call
   */
  public TransactionHistoryResp loyaltyBalanceProgramsPidTransactionHistoryGet(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull Integer contactId, @jakarta.annotation.Nonnull UUID balanceDefinitionId, @jakarta.annotation.Nullable Integer limit, @jakarta.annotation.Nullable Integer offset, @jakarta.annotation.Nullable String sortField, @jakarta.annotation.Nullable String sort, @jakarta.annotation.Nullable List<String> filters, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling loyaltyBalanceProgramsPidTransactionHistoryGet");
    }
    
    // verify the required parameter 'contactId' is set
    if (contactId == null) {
      throw new ApiException(400, "Missing the required parameter 'contactId' when calling loyaltyBalanceProgramsPidTransactionHistoryGet");
    }
    
    // verify the required parameter 'balanceDefinitionId' is set
    if (balanceDefinitionId == null) {
      throw new ApiException(400, "Missing the required parameter 'balanceDefinitionId' when calling loyaltyBalanceProgramsPidTransactionHistoryGet");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/transaction-history"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
    localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort_field", sortField));
    localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
    localVarQueryParams.addAll(apiClient.parameterToPair("contact_id", contactId));
    localVarQueryParams.addAll(apiClient.parameterToPair("balance_definition_id", balanceDefinitionId));
    localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "filters", filters));
    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<TransactionHistoryResp> localVarReturnType = new TypeReference<TransactionHistoryResp>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Update balance definition
   * Updates Balance definition
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param updateBalanceDefinitionPayload Create Balance Definition Payload (required)
   * @return BalanceDefinition
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinition updateBalanceDefinition(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UpdateBalanceDefinitionPayload updateBalanceDefinitionPayload) throws ApiException {
    return this.updateBalanceDefinition(pid, bdid, updateBalanceDefinitionPayload, Collections.emptyMap());
  }


  /**
   * Update balance definition
   * Updates Balance definition
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param updateBalanceDefinitionPayload Create Balance Definition Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceDefinition
   * @throws ApiException if fails to make API call
   */
  public BalanceDefinition updateBalanceDefinition(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UpdateBalanceDefinitionPayload updateBalanceDefinitionPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateBalanceDefinitionPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling updateBalanceDefinition");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling updateBalanceDefinition");
    }
    
    // verify the required parameter 'updateBalanceDefinitionPayload' is set
    if (updateBalanceDefinitionPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'updateBalanceDefinitionPayload' when calling updateBalanceDefinition");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceDefinition> localVarReturnType = new TypeReference<BalanceDefinition>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  /**
   * Updates balance limit
   * Updates balance limit
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param blid Balance Limit Id (required)
   * @param updateBalanceLimitPayload Balance Limits Payload (required)
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit updateBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UUID blid, @jakarta.annotation.Nonnull UpdateBalanceLimitPayload updateBalanceLimitPayload) throws ApiException {
    return this.updateBalanceLimit(pid, bdid, blid, updateBalanceLimitPayload, Collections.emptyMap());
  }


  /**
   * Updates balance limit
   * Updates balance limit
   * @param pid Loyalty Program Id (required)
   * @param bdid Balance Definition Id (required)
   * @param blid Balance Limit Id (required)
   * @param updateBalanceLimitPayload Balance Limits Payload (required)
   * @param additionalHeaders additionalHeaders for this call
   * @return BalanceLimit
   * @throws ApiException if fails to make API call
   */
  public BalanceLimit updateBalanceLimit(@jakarta.annotation.Nonnull UUID pid, @jakarta.annotation.Nonnull UUID bdid, @jakarta.annotation.Nonnull UUID blid, @jakarta.annotation.Nonnull UpdateBalanceLimitPayload updateBalanceLimitPayload, Map<String, String> additionalHeaders) throws ApiException {
    Object localVarPostBody = updateBalanceLimitPayload;
    
    // verify the required parameter 'pid' is set
    if (pid == null) {
      throw new ApiException(400, "Missing the required parameter 'pid' when calling updateBalanceLimit");
    }
    
    // verify the required parameter 'bdid' is set
    if (bdid == null) {
      throw new ApiException(400, "Missing the required parameter 'bdid' when calling updateBalanceLimit");
    }
    
    // verify the required parameter 'blid' is set
    if (blid == null) {
      throw new ApiException(400, "Missing the required parameter 'blid' when calling updateBalanceLimit");
    }
    
    // verify the required parameter 'updateBalanceLimitPayload' is set
    if (updateBalanceLimitPayload == null) {
      throw new ApiException(400, "Missing the required parameter 'updateBalanceLimitPayload' when calling updateBalanceLimit");
    }
    
    // create path and map variables
    String localVarPath = "/loyalty/balance/programs/{pid}/balance-definitions/{bdid}/limits/{blid}"
      .replaceAll("\\{" + "pid" + "\\}", apiClient.escapeString(apiClient.parameterToString(pid)))
      .replaceAll("\\{" + "bdid" + "\\}", apiClient.escapeString(apiClient.parameterToString(bdid)))
      .replaceAll("\\{" + "blid" + "\\}", apiClient.escapeString(apiClient.parameterToString(blid)));

    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    String localVarQueryParameterBaseName;
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    
    localVarHeaderParams.putAll(additionalHeaders);

    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    TypeReference<BalanceLimit> localVarReturnType = new TypeReference<BalanceLimit>() {};
    return apiClient.invokeAPI(
        localVarPath,
        "PUT",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        localVarPostBody,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        localVarReturnType
    );
  }

  @Override
  public <T> T invokeAPI(String url, String method, Object request, TypeReference<T> returnType, Map<String, String> additionalHeaders) throws ApiException {
    String localVarPath = url.replace(apiClient.getBaseURL(), "");
    StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, String> localVarCookieParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarHeaderParams.putAll(additionalHeaders);

    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "api-key" };

    return apiClient.invokeAPI(
      localVarPath,
        method,
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarQueryStringJoiner.toString(),
        request,
        localVarHeaderParams,
        localVarCookieParams,
        localVarFormParams,
        localVarAccept,
        localVarContentType,
        localVarAuthNames,
        returnType
    );
  }
}
