/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.net;

import java.net.Proxy;
import lombok.Generated;
import okhttp3.Credentials;
import org.apache.commons.lang3.StringUtils;
import software.reloadly.sdk.core.internal.util.Asserter;

public class ProxyOptions {
    private final Proxy proxy;
    private String proxyUsername;
    private char[] proxyPassword;
    private String basicAuthentication;

    public ProxyOptions(Proxy proxy) {
        Asserter.assertNotNull(proxy, "proxy");
        this.proxy = proxy;
    }

    public ProxyOptions(Proxy proxy, String proxyUsername, char[] proxyPassword) {
        Asserter.assertNotNull(proxy, "proxy");
        this.proxy = proxy;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.validateAndBuildAuthenticationCredentials();
    }

    private void validateAndBuildAuthenticationCredentials() {
        if (StringUtils.isNotBlank((CharSequence)this.proxyUsername) || this.proxyPassword != null) {
            Asserter.assertNotBlank(this.proxyUsername, "Proxy username");
            Asserter.assertNotNull(this.proxyPassword, "Proxy password");
            this.basicAuthentication = Credentials.basic((String)this.proxyUsername, (String)new String(this.proxyPassword));
        }
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Generated
    public char[] getProxyPassword() {
        return this.proxyPassword;
    }

    @Generated
    public String getBasicAuthentication() {
        return this.basicAuthentication;
    }
}

