/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.util;

import okhttp3.mockwebserver.RecordedRequest;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class RecordedRequestMatcher
extends TypeSafeDiagnosingMatcher<RecordedRequest> {
    private static final int METHOD_PATH = 0;
    private static final int HEADER = 1;
    private static final int QUERY_PARAMETER = 2;
    private static final int QUERY_PARAMETER_PRESENCE = 3;
    private final int checkingOption;
    private final String first;
    private final String second;

    private RecordedRequestMatcher(String first, String second, int checkingOption) {
        this.checkingOption = checkingOption;
        this.first = first;
        this.second = second;
    }

    protected boolean matchesSafely(RecordedRequest item, Description mismatchDescription) {
        if (item == null) {
            mismatchDescription.appendText("was null");
            return false;
        }
        switch (this.checkingOption) {
            default: {
                return this.matchesMethodAndPath(item, mismatchDescription);
            }
            case 1: {
                return this.matchesHeader(item, mismatchDescription);
            }
            case 2: {
                return this.matchesQueryParameter(item, mismatchDescription);
            }
            case 3: 
        }
        return this.hasQueryParameter(item, mismatchDescription);
    }

    private boolean matchesMethodAndPath(RecordedRequest item, Description mismatchDescription) {
        boolean hasQuery;
        if (item.getMethod() == null || !item.getMethod().equalsIgnoreCase(this.first)) {
            mismatchDescription.appendText("method was ").appendValue((Object)item.getMethod());
            return false;
        }
        String path = item.getPath();
        boolean bl = hasQuery = path != null && path.indexOf("?") > 0;
        if (hasQuery) {
            path = path.substring(0, path.indexOf("?"));
        }
        if (path != null && !path.equals(this.second)) {
            mismatchDescription.appendText("path was ").appendValue((Object)path);
            return false;
        }
        return true;
    }

    private boolean matchesHeader(RecordedRequest item, Description mismatchDescription) {
        String value = item.getHeader(this.first);
        if (value != null && !value.equals(this.second) || value == null && this.second != null) {
            mismatchDescription.appendText(this.first).appendText(" header was ").appendValue((Object)value);
            return false;
        }
        return true;
    }

    private boolean matchesQueryParameter(RecordedRequest item, Description mismatchDescription) {
        Object[] parameters = this.getParameters(item, mismatchDescription);
        if (parameters == null) {
            return false;
        }
        for (String string : parameters) {
            if (!string.equals(String.format("%s=%s", this.first, this.second))) continue;
            return true;
        }
        mismatchDescription.appendValueList("Query parameters were {", ", ", "}.", parameters);
        return false;
    }

    private boolean hasQueryParameter(RecordedRequest item, Description mismatchDescription) {
        Object[] parameters = this.getParameters(item, mismatchDescription);
        if (parameters == null) {
            return false;
        }
        for (String string : parameters) {
            if (!string.startsWith(String.format("%s=", this.first))) continue;
            return true;
        }
        mismatchDescription.appendValueList("Query parameters were {", ", ", "}.", parameters);
        return false;
    }

    private String[] getParameters(RecordedRequest item, Description mismatchDescription) {
        boolean hasQuery;
        String path = item.getPath();
        boolean bl = hasQuery = path != null && path.indexOf("?") > 0;
        if (!hasQuery) {
            mismatchDescription.appendText(" query was empty");
            return null;
        }
        String query = path.substring(path.indexOf("?") + 1);
        return query.split("&");
    }

    public void describeTo(Description description) {
        switch (this.checkingOption) {
            default: {
                description.appendText("A request with method ").appendValue((Object)this.first).appendText(" and path ").appendValue((Object)this.second);
                break;
            }
            case 1: {
                description.appendText("A request containing header ").appendValue((Object)this.first).appendText(" with value ").appendValue((Object)this.second);
                break;
            }
            case 2: {
                description.appendText("A request containing query parameter ").appendValue((Object)this.first).appendText(" with value ").appendValue((Object)this.second);
                break;
            }
            case 3: {
                description.appendText("A request containing query parameter ").appendValue((Object)this.first);
            }
        }
    }

    public static RecordedRequestMatcher hasMethodAndPath(String method, String path) {
        return new RecordedRequestMatcher(method, path, 0);
    }

    public static RecordedRequestMatcher hasHeader(String name, String value) {
        return new RecordedRequestMatcher(name, value, 1);
    }

    public static RecordedRequestMatcher hasQueryParameter(String name, String value) {
        return new RecordedRequestMatcher(name, value, 2);
    }

    public static RecordedRequestMatcher hasQueryParameter(String name) {
        return new RecordedRequestMatcher(name, null, 3);
    }
}

