/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.util;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import software.reloadly.sdk.core.dto.APIError;
import software.reloadly.sdk.core.exception.APIException;
import software.reloadly.sdk.core.exception.oauth.OAuthException;

public class ExceptionUtil {
    public static APIException convert(APIError apiError, int httpStatusCode) {
        return ExceptionUtil.setAdditionalFields(apiError, ExceptionUtil.doGetApiException(apiError, httpStatusCode));
    }

    public static APIException convert(APIError apiError, int httpStatusCode, Throwable cause) {
        return ExceptionUtil.setAdditionalFields(apiError, ExceptionUtil.doGetApiException(apiError, httpStatusCode, cause));
    }

    private static APIException doGetApiException(APIError apiError, int httpStatusCode) {
        if (ExceptionUtil.isAuthenticationError(apiError)) {
            return new OAuthException(apiError.getMessage(), httpStatusCode, apiError.getPath());
        }
        return new APIException(apiError.getMessage(), httpStatusCode, apiError.getPath());
    }

    private static APIException doGetApiException(APIError apiError, int httpStatusCode, Throwable cause) {
        if (ExceptionUtil.isAuthenticationError(apiError)) {
            return new OAuthException(apiError.getMessage(), httpStatusCode, apiError.getPath(), cause);
        }
        return new APIException(apiError.getMessage(), httpStatusCode, apiError.getPath(), cause);
    }

    private static APIException setAdditionalFields(APIError apiError, APIException apiException) {
        if (apiError.getErrorCode() != null && !apiError.getErrorCode().trim().isEmpty()) {
            apiException.setErrorCode(apiError.getErrorCode());
        }
        if (apiError.getTimeStamp() != null) {
            apiException.setTimeStamp(apiError.getTimeStamp());
        }
        if (apiError.getDetails() != null) {
            apiException.setDetails(apiError.getDetails());
        }
        return apiException;
    }

    private static boolean isAuthenticationError(APIError apiError) {
        return StringUtils.isNotBlank((CharSequence)apiError.getPath()) && apiError.getPath().equalsIgnoreCase("/oauth/token");
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionUtil)) {
            return false;
        }
        ExceptionUtil other = (ExceptionUtil)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExceptionUtil;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

