/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.net;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import software.reloadly.sdk.core.internal.util.TelemetryUtil;

public class Telemetry {
    private static final String ENV_KEY = "env";
    private static final String JAVA_KEY = "java";
    private static final String NAME_KEY = "name";
    private static final String VERSION_KEY = "api-version";
    public static final String HEADER_NAME = "Reloadly-Client";
    private static final String LIBRARY_VERSION_KEY = "reloadly-sdk-java";
    private final String name;
    private final String value;
    private final String apiVersion;
    private final String libraryVersion;
    private final Map<String, String> env;

    public Telemetry(String name, String libraryVersion) {
        this(name, libraryVersion, null);
    }

    public Telemetry(String name, String libraryVersion, @Nullable String apiVersion) {
        String tmpValue;
        this.name = name;
        this.apiVersion = apiVersion;
        this.libraryVersion = libraryVersion;
        if (name == null) {
            this.env = Collections.emptyMap();
            this.value = null;
            return;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(NAME_KEY, name);
        if (StringUtils.isNotBlank((CharSequence)apiVersion)) {
            values.put(VERSION_KEY, apiVersion);
        }
        HashMap<String, String> tmpEnv = new HashMap<String, String>();
        tmpEnv.put(JAVA_KEY, TelemetryUtil.getJDKVersion());
        if (StringUtils.isNotBlank((CharSequence)libraryVersion)) {
            tmpEnv.put(LIBRARY_VERSION_KEY, libraryVersion);
        }
        this.env = Collections.unmodifiableMap(tmpEnv);
        values.put(ENV_KEY, this.env);
        try {
            String json = new ObjectMapper().writeValueAsString(values);
            tmpValue = Base64.encodeBase64URLSafeString((byte[])json.getBytes());
        }
        catch (JsonProcessingException e) {
            tmpValue = null;
            e.printStackTrace();
        }
        this.value = tmpValue;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public String getLibraryVersion() {
        return this.libraryVersion;
    }

    @Generated
    public Map<String, String> getEnv() {
        return this.env;
    }
}

