/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.net;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import software.reloadly.sdk.core.exception.ReloadlyException;
import software.reloadly.sdk.core.internal.dto.request.interfaces.Request;
import software.reloadly.sdk.core.internal.net.API;
import software.reloadly.sdk.core.internal.util.Asserter;
import software.reloadly.sdk.core.net.HttpOptions;

public abstract class ServiceAPI
extends API {
    protected String accessToken;
    protected boolean cacheAccessToken;

    public ServiceAPI(String clientId, String clientSecret, String accessToken, boolean enableLogging, List<String> redactHeaders, HttpOptions options, Boolean enableTelemetry, String sdkVersion, @Nullable String apiVersion) {
        super(clientId, clientSecret, enableLogging, redactHeaders, options, enableTelemetry, sdkVersion, apiVersion);
        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
            this.accessToken = this.validateAccessToken(accessToken);
            if (StringUtils.isNotBlank((CharSequence)this.accessToken)) {
                this.cacheAccessToken = true;
            }
        }
    }

    public abstract void refreshAccessToken(Request<?> var1) throws ReloadlyException;

    public boolean isAccessTokenCached() {
        return this.cacheAccessToken;
    }

    protected void validateCredentials() {
        if (StringUtils.isBlank((CharSequence)this.accessToken) && StringUtils.isBlank((CharSequence)this.clientId) && StringUtils.isBlank((CharSequence)this.clientSecret)) {
            throw new IllegalArgumentException("Either a valid access token or both client id & client secret must be provided");
        }
        if (StringUtils.isBlank((CharSequence)this.accessToken)) {
            Asserter.assertNotNull(this.clientId, "Client id");
            Asserter.assertNotNull(this.clientSecret, "Client secret");
        } else if (StringUtils.isBlank((CharSequence)this.clientId) && StringUtils.isBlank((CharSequence)this.clientSecret)) {
            Asserter.assertNotNull(this.accessToken, "Access token");
        }
    }

    protected void setAccessToken(String accessToken) {
        Asserter.assertNotNull(accessToken, "Access token");
        this.accessToken = this.validateAccessToken(accessToken);
    }

    @Nullable
    private String validateAccessToken(String accessToken) {
        DecodedJWT decodedToken;
        try {
            decodedToken = JWT.decode((String)accessToken);
        }
        catch (Exception e) {
            return null;
        }
        Date expirationDate = decodedToken.getExpiresAt();
        Date now = new Date();
        long timeLeftInSeconds = (expirationDate.getTime() - now.getTime()) / 1000L;
        return expirationDate.compareTo(now) <= 0 || timeLeftInSeconds <= 300L ? null : accessToken;
    }

    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }
}

