/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.net;

import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;
import software.reloadly.sdk.core.internal.interceptor.TelemetryInterceptor;
import software.reloadly.sdk.core.internal.util.TelemetryUtil;
import software.reloadly.sdk.core.net.HttpOptions;
import software.reloadly.sdk.core.net.ProxyOptions;

public abstract class API {
    protected static final String KEY_CLIENT_ID = "client_id";
    protected static final String KEY_CLIENT_SECRET = "client_secret";
    protected final String clientId;
    protected final String clientSecret;
    protected final boolean enableLogging;
    protected final Boolean enableTelemetry;
    protected final OkHttpClient client;
    private TelemetryInterceptor telemetryInterceptor;
    private HttpLoggingInterceptor httpLoggingInterceptor;
    private Set<String> headersToRedact;
    private String apiVersion;
    private final String libraryVersion;

    public API(String clientId, String clientSecret, boolean enableLogging, List<String> redactHeaders, HttpOptions options, Boolean enableTelemetry, String libraryVersion) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.enableLogging = enableLogging;
        this.libraryVersion = libraryVersion;
        if (redactHeaders != null && !redactHeaders.isEmpty()) {
            this.headersToRedact = new HashSet<String>(redactHeaders);
        }
        this.enableTelemetry = enableTelemetry == null || enableTelemetry != false;
        this.client = this.buildClient(options == null ? new HttpOptions() : options);
    }

    public API(String clientId, String clientSecret, boolean enableLogging, List<String> redactHeaders, HttpOptions options, Boolean enableTelemetry, String libraryVersion, String apiVersion) {
        this.clientId = clientId;
        this.apiVersion = apiVersion;
        this.clientSecret = clientSecret;
        this.enableLogging = enableLogging;
        this.libraryVersion = libraryVersion;
        if (redactHeaders != null && !redactHeaders.isEmpty()) {
            this.headersToRedact = new HashSet<String>(redactHeaders);
        }
        this.enableTelemetry = enableTelemetry == null || enableTelemetry != false;
        this.client = this.buildClient(options == null ? new HttpOptions() : options);
    }

    public boolean isLoggingEnabled() {
        return this.enableLogging;
    }

    @Nullable
    protected HttpUrl createUrlFromString(String url) {
        try {
            return HttpUrl.parse((String)url);
        }
        catch (Exception e) {
            return null;
        }
    }

    private OkHttpClient buildClient(HttpOptions options) {
        Duration readTimeout = options.getConnectTimeout() == null ? Duration.ofSeconds(60L) : options.getConnectTimeout();
        Duration writeTimeout = options.getConnectTimeout() == null ? Duration.ofSeconds(60L) : options.getConnectTimeout();
        Duration connectTimeout = options.getConnectTimeout() == null ? Duration.ofSeconds(60L) : options.getConnectTimeout();
        ProxyOptions proxyOptions = options.getProxyOptions();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (proxyOptions != null) {
            clientBuilder.proxy(proxyOptions.getProxy());
            String proxyAuth = proxyOptions.getBasicAuthentication();
            if (proxyAuth != null) {
                clientBuilder.proxyAuthenticator((route, response) -> {
                    if (response.request().header("Proxy-Authorization") != null) {
                        return null;
                    }
                    return response.request().newBuilder().header("Proxy-Authorization", proxyAuth).build();
                });
            }
        }
        OkHttpClient.Builder builder = clientBuilder.connectTimeout(connectTimeout).readTimeout(readTimeout).writeTimeout(writeTimeout);
        if (this.enableLogging) {
            this.httpLoggingInterceptor = new HttpLoggingInterceptor();
            this.httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            if (this.headersToRedact != null && !this.headersToRedact.isEmpty()) {
                this.headersToRedact.forEach(header -> {
                    if (StringUtils.isNotBlank((CharSequence)header.trim())) {
                        this.httpLoggingInterceptor.redactHeader(header.trim());
                    }
                });
            }
            builder.addInterceptor((Interceptor)this.httpLoggingInterceptor);
        }
        if (this.enableTelemetry.booleanValue()) {
            this.telemetryInterceptor = TelemetryUtil.getTelemetryInterceptor(this.libraryVersion, this.apiVersion);
            this.telemetryInterceptor.setEnabled(true);
            builder.addInterceptor((Interceptor)this.telemetryInterceptor);
        }
        return builder.build();
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    protected OkHttpClient getClient() {
        return this.client;
    }
}

