/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.interceptor;

import java.io.IOException;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.lang.NonNull;
import software.reloadly.sdk.core.internal.net.Telemetry;

public class TelemetryInterceptor
implements Interceptor {
    private boolean enabled;
    private Telemetry telemetry;

    public TelemetryInterceptor(Telemetry telemetry) {
        this.telemetry = telemetry;
        this.enabled = true;
    }

    @NonNull
    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        if (!this.enabled) {
            return chain.proceed(chain.request());
        }
        Request request = chain.request().newBuilder().addHeader("Reloadly-Client", this.telemetry.getValue()).build();
        return chain.proceed(request);
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Telemetry getTelemetry() {
        return this.telemetry;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setTelemetry(Telemetry telemetry) {
        this.telemetry = telemetry;
    }
}

