/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.dto.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import software.reloadly.sdk.core.dto.APIError;
import software.reloadly.sdk.core.exception.APIException;
import software.reloadly.sdk.core.exception.RateLimitException;
import software.reloadly.sdk.core.exception.ReloadlyException;
import software.reloadly.sdk.core.internal.dto.request.BaseRequest;
import software.reloadly.sdk.core.internal.dto.request.CustomizableRequest;
import software.reloadly.sdk.core.internal.util.ExceptionUtil;

public class CustomRequest<T>
extends BaseRequest<T>
implements CustomizableRequest<T> {
    private final String url;
    private final String method;
    private final ObjectMapper mapper;
    private final TypeReference<T> tType;
    private final Map<String, String> headers;
    private final Map<String, Object> parameters;
    private Object body;
    private static final int STATUS_CODE_TOO_MANY_REQUEST = 429;

    CustomRequest(OkHttpClient client, String url, String method, ObjectMapper mapper, TypeReference<T> tType) {
        super(client);
        this.url = url;
        this.method = method;
        this.mapper = mapper;
        this.tType = tType;
        this.headers = new HashMap<String, String>();
        this.parameters = new HashMap<String, Object>();
    }

    public CustomRequest(OkHttpClient client, String url, String method, TypeReference<T> tType) {
        this(client, url, method, new ObjectMapper(), tType);
    }

    @Override
    protected Request createRequest() throws ReloadlyException {
        Request.Builder builder = new Request.Builder().url(this.url).method(this.method, this.createBody());
        this.headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected T parseResponse(Response response) throws ReloadlyException {
        if (!response.isSuccessful()) {
            throw this.createResponseException(response);
        }
        try (ResponseBody body = response.body();){
            if (body == null) {
                throw new Exception();
            }
            String payload = body.string();
            Object object = this.mapper.readValue(payload, this.tType);
            return (T)object;
        }
        catch (Exception e) {
            String path = this.getPath(response);
            throw new APIException("Failed to parse json body", response.code(), path, e);
        }
    }

    @Override
    public CustomRequest<T> addHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    @Override
    public CustomRequest<T> addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    @Override
    public CustomRequest<T> setBody(Object value) {
        this.body = value;
        return this;
    }

    protected RequestBody createBody() throws ReloadlyException {
        if (this.body == null && this.parameters.isEmpty()) {
            return null;
        }
        try {
            byte[] jsonBody = this.mapper.writeValueAsBytes(this.body != null ? this.body : this.parameters);
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])jsonBody);
        }
        catch (JsonProcessingException e) {
            throw new ReloadlyException("Couldn't create the request body.", e);
        }
    }

    protected ReloadlyException createResponseException(Response response) {
        if (response.code() == 429) {
            return this.createRateLimitException(response);
        }
        return this.doCreateResponseException(response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private APIException doCreateResponseException(Response response) {
        try (ResponseBody body = response.body();){
            if (body == null) {
                throw new Exception("Operation failed");
            }
            Reader streamReader = body.charStream();
            APIException aPIException = ExceptionUtil.convert((APIError)new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").create().fromJson(streamReader, APIError.class), response.code());
            return aPIException;
        }
        catch (Exception e) {
            this.body = this.body == null ? "No response from server, please try again or contact support" : this.body.toString();
            return new APIException(this.body.toString(), response.code(), this.getPath(response), e);
        }
    }

    private RateLimitException createRateLimitException(Response response) {
        RateLimitException rateLimitException = (RateLimitException)this.doCreateResponseException(response);
        String resetValue = response.header("X-RateLimit-Reset", "-1");
        String limitValue = response.header("X-RateLimit-Limit", "-1");
        String remainingValue = response.header("X-RateLimit-Remaining", "-1");
        resetValue = resetValue == null ? "-1" : resetValue;
        limitValue = limitValue == null ? "-1" : limitValue;
        remainingValue = remainingValue == null ? "-1" : remainingValue;
        long limit = Long.parseLong(limitValue);
        long remaining = Long.parseLong(remainingValue);
        long reset = Long.parseLong(resetValue);
        rateLimitException.setLimit(limit);
        rateLimitException.setRemaining(remaining);
        rateLimitException.setExpectedResetTimestamp(reset);
        return rateLimitException;
    }

    private String getPath(Response response) {
        return StringUtils.join((Iterable)response.request().url().pathSegments(), (String)"/");
    }
}

