/*
 * Decompiled with CFR 0.152.
 */
package software.reloadly.sdk.core.internal.dto.request;

import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Response;
import software.reloadly.sdk.core.exception.ReloadlyException;
import software.reloadly.sdk.core.internal.dto.request.interfaces.Request;

public abstract class BaseRequest<T>
implements Request<T> {
    private final OkHttpClient client;

    BaseRequest(OkHttpClient client) {
        this.client = client;
    }

    protected abstract okhttp3.Request createRequest() throws ReloadlyException;

    protected abstract T parseResponse(Response var1) throws ReloadlyException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T execute() throws ReloadlyException {
        okhttp3.Request request = this.createRequest();
        try (Response response = this.client.newCall(request).execute();){
            T t = this.parseResponse(response);
            return t;
        }
        catch (ReloadlyException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ReloadlyException("Failed to execute request", e);
        }
    }
}

