/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.util;

public class Logger {
    public static final int NONE = -1;
    public static final int ERROR = 0;
    public static final int WARN = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static int level = -1;
    public static String prefix = "[Client]";

    public static void debug(String message) {
        if (level >= 3) {
            System.out.println(Logger.fmt(message));
        }
    }

    public static void info(String message) {
        if (level >= 2) {
            System.out.println(Logger.fmt(message));
        }
    }

    public static void warn(String message) {
        if (level >= 1) {
            System.err.println(Logger.fmt(message));
        }
    }

    public static void error(String message) {
        if (level >= 0) {
            System.err.println(Logger.fmt(message));
        }
    }

    private static String fmt(String message) {
        return prefix + String.format("%-12s " + message, "[" + Thread.currentThread().getName() + "]");
    }
}

