/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.sock;

import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import software.coley.instrument.io.codec.StructureEncoder;
import software.coley.instrument.message.AbstractMessage;

public class WriteResult<T extends AbstractMessage> {
    private final StructureEncoder<T> encoder;
    private final int frameId;
    private final int decoderKey;
    private final T value;
    private volatile CompletableFuture<Void> future;

    public WriteResult(StructureEncoder<T> encoder, int frameId, int decoderKey, T value) {
        this.encoder = encoder;
        this.frameId = frameId;
        this.decoderKey = decoderKey;
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompletableFuture<Void> getFuture() {
        if (this.future != null) return this.future;
        Class<WriteResult> clazz = WriteResult.class;
        synchronized (WriteResult.class) {
            if (this.future != null) return this.future;
            this.future = new CompletableFuture();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.future;
        }
    }

    public int getFrameId() {
        return this.frameId;
    }

    public int getDecoderKey() {
        return this.decoderKey;
    }

    public T getValue() {
        return this.value;
    }

    public void writeHeader(DataOutput output) throws IOException {
        output.writeInt(this.frameId);
        output.writeShort(this.decoderKey);
        output.writeInt(-1);
    }

    public void writeTo(DataOutput output) throws IOException {
        this.encoder.encode(output, this.value);
    }

    public void complete() {
        this.getFuture().complete(null);
    }
}

