/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.message.request;

import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import software.coley.instrument.data.MemberData;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.message.reply.ReplyFieldSetMessage;
import software.coley.instrument.message.request.AbstractRequestMessage;
import software.coley.instrument.util.DescUtil;
import software.coley.instrument.util.Logger;

public class RequestFieldSetMessage
extends AbstractRequestMessage<ReplyFieldSetMessage> {
    public static final StructureCodec<RequestFieldSetMessage> CODEC = StructureCodec.compose(input -> new RequestFieldSetMessage((MemberData)MemberData.CODEC.decode(input), input.readUTF()), (output, value) -> {
        MemberData.CODEC.encode(output, value.getMemberInfo());
        output.writeUTF(value.getValueText());
    });
    private final MemberData memberData;
    private final String valueText;

    public RequestFieldSetMessage(MemberData memberData, String valueText) {
        this.memberData = memberData;
        this.valueText = valueText;
    }

    public MemberData getMemberInfo() {
        return this.memberData;
    }

    public String getValueText() {
        return this.valueText;
    }

    public void assignValue() {
        String owner = this.memberData.getOwner();
        String name = this.memberData.getName();
        String desc = this.memberData.getDesc();
        if (owner == null || name == null || desc == null || this.valueText == null) {
            throw new IllegalStateException("Field indicators not set before usage");
        }
        try {
            Class<?> clazz = Class.forName(owner.replace('/', '.'));
            block12: for (Field declaredField : clazz.getDeclaredFields()) {
                if ((declaredField.getModifiers() & 8) <= 0 || !declaredField.getName().equals(name) || !desc.equals(DescUtil.getDescriptor(declaredField))) continue;
                declaredField.setAccessible(true);
                char first = desc.charAt(0);
                if (DescUtil.isPrimitiveName(first)) {
                    switch (first) {
                        case 'I': {
                            declaredField.setInt(null, this.mapInt());
                            continue block12;
                        }
                        case 'Z': {
                            declaredField.setBoolean(null, this.mapBoolean());
                            continue block12;
                        }
                        case 'B': {
                            declaredField.setByte(null, this.mapByte());
                            continue block12;
                        }
                        case 'C': {
                            declaredField.setChar(null, this.mapChar());
                            continue block12;
                        }
                        case 'S': {
                            declaredField.setShort(null, this.mapShort());
                            continue block12;
                        }
                        case 'D': {
                            declaredField.setDouble(null, this.mapDouble());
                            continue block12;
                        }
                        case 'F': {
                            declaredField.setFloat(null, this.mapFloat());
                            continue block12;
                        }
                        case 'J': {
                            declaredField.setLong(null, this.mapLong());
                            continue block12;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive class desc: " + first);
                        }
                    }
                }
                declaredField.set(null, this.mapObjectValue());
            }
        }
        catch (Exception ex) {
            Logger.error("Failed to set field value: " + ex);
        }
    }

    @Override
    public String toString() {
        String owner = this.memberData.getOwner();
        String name = this.memberData.getName();
        String desc = this.memberData.getDesc();
        return "RequestFieldSetMessage[owner='" + owner + '\'' + ", name='" + name + '\'' + ", desc='" + desc + '\'' + ", valueText='" + this.valueText + '\'' + ']';
    }

    private int mapInt() {
        if (this.valueText.toLowerCase().startsWith("0x")) {
            return Integer.parseInt(this.valueText, 16);
        }
        if (this.valueText.toLowerCase().startsWith("0b")) {
            return Integer.parseInt(this.valueText, 1);
        }
        return Integer.parseInt(this.valueText);
    }

    private boolean mapBoolean() {
        return Boolean.parseBoolean(this.valueText);
    }

    private byte mapByte() {
        if (this.valueText.toLowerCase().startsWith("0x")) {
            return Byte.parseByte(this.valueText, 16);
        }
        if (this.valueText.toLowerCase().startsWith("0b")) {
            return Byte.parseByte(this.valueText, 1);
        }
        return Byte.parseByte(this.valueText);
    }

    private char mapChar() {
        return this.valueText.charAt(0);
    }

    private short mapShort() {
        if (this.valueText.toLowerCase().startsWith("0x")) {
            return Short.parseShort(this.valueText, 16);
        }
        if (this.valueText.toLowerCase().startsWith("0b")) {
            return Short.parseShort(this.valueText, 1);
        }
        return Short.parseShort(this.valueText);
    }

    private double mapDouble() {
        String text = this.valueText.toLowerCase();
        if (text.endsWith("d")) {
            text = text.substring(0, text.length() - 1);
        }
        return Double.parseDouble(text);
    }

    private float mapFloat() {
        String text = this.valueText.toLowerCase();
        if (text.endsWith("f")) {
            text = text.substring(0, text.length() - 1);
        }
        return Float.parseFloat(text);
    }

    private long mapLong() {
        String text = this.valueText.toLowerCase();
        if (text.endsWith("l")) {
            text = text.substring(0, text.length() - 1);
        }
        if (text.startsWith("0x")) {
            return Long.parseLong(text, 16);
        }
        if (text.startsWith("0b")) {
            return Long.parseLong(text, 1);
        }
        return Long.parseLong(text);
    }

    private Object mapObjectValue() {
        if (this.valueText.equals("null")) {
            return null;
        }
        String desc = this.memberData.getDesc();
        if (desc.equals(DescUtil.INT_DESC)) {
            return this.mapInt();
        }
        if (desc.equals(DescUtil.BOOL_DESC)) {
            return this.mapBoolean();
        }
        if (desc.equals(DescUtil.BYTE_DESC)) {
            return this.mapByte();
        }
        if (desc.equals(DescUtil.CHAR_DESC)) {
            return Character.valueOf(this.mapChar());
        }
        if (desc.equals(DescUtil.SHORT_DESC)) {
            return this.mapShort();
        }
        if (desc.equals(DescUtil.DOUBLE_DESC)) {
            return this.mapDouble();
        }
        if (desc.equals(DescUtil.FLOAT_DESC)) {
            return Float.valueOf(this.mapFloat());
        }
        if (desc.equals(DescUtil.LONG_DESC)) {
            return this.mapLong();
        }
        if (desc.equals(DescUtil.STRING_DESC) || desc.equals(DescUtil.CHAR_SEQUENCE_DESC)) {
            return this.valueText;
        }
        if (desc.equals(DescUtil.STRING_BUILDER_DESC)) {
            return new StringBuilder(this.valueText);
        }
        if (desc.equals(DescUtil.STRING_BUFFER_DESC)) {
            return new StringBuffer(this.valueText);
        }
        if (desc.equals(DescUtil.FILE_DESC)) {
            return new File(this.valueText);
        }
        if (desc.equals(DescUtil.PATH_DESC)) {
            return Paths.get(this.valueText, new String[0]);
        }
        throw new IllegalStateException("Unsupported field type: " + desc);
    }
}

