/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.message.request;

import java.lang.reflect.Field;
import java.util.Arrays;
import software.coley.instrument.data.MemberData;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.message.reply.ReplyFieldGetMessage;
import software.coley.instrument.message.request.AbstractRequestMessage;
import software.coley.instrument.util.DescUtil;
import software.coley.instrument.util.Logger;

public class RequestFieldGetMessage
extends AbstractRequestMessage<ReplyFieldGetMessage> {
    public static final StructureCodec<RequestFieldGetMessage> CODEC = StructureCodec.compose(input -> new RequestFieldGetMessage((MemberData)MemberData.CODEC.decode(input)), (output, value) -> MemberData.CODEC.encode(output, value.getMemberInfo()));
    private final MemberData memberData;

    public RequestFieldGetMessage(MemberData memberData) {
        this.memberData = memberData;
    }

    public MemberData getMemberInfo() {
        return this.memberData;
    }

    public String lookupValue() {
        String owner = this.memberData.getOwner();
        String name = this.memberData.getName();
        String desc = this.memberData.getDesc();
        String valueText = null;
        if (owner == null || name == null || desc == null) {
            throw new IllegalStateException("Field indicators not set before usage");
        }
        try {
            Class<?> clazz = Class.forName(owner.replace('/', '.'));
            block12: for (Field declaredField : clazz.getDeclaredFields()) {
                if ((declaredField.getModifiers() & 8) <= 0 || !declaredField.getName().equals(name) || !desc.equals(DescUtil.getDescriptor(declaredField))) continue;
                declaredField.setAccessible(true);
                char first = desc.charAt(0);
                if (DescUtil.isPrimitiveName(first)) {
                    switch (first) {
                        case 'I': {
                            valueText = String.valueOf(declaredField.getInt(null));
                            break block12;
                        }
                        case 'Z': {
                            valueText = String.valueOf(declaredField.getBoolean(null));
                            break block12;
                        }
                        case 'B': {
                            valueText = String.valueOf(declaredField.getByte(null));
                            break block12;
                        }
                        case 'C': {
                            valueText = String.valueOf(declaredField.getChar(null));
                            break block12;
                        }
                        case 'S': {
                            valueText = String.valueOf(declaredField.getShort(null));
                            break block12;
                        }
                        case 'D': {
                            valueText = String.valueOf(declaredField.getDouble(null));
                            break block12;
                        }
                        case 'F': {
                            valueText = String.valueOf(declaredField.getFloat(null));
                            break block12;
                        }
                        case 'J': {
                            valueText = String.valueOf(declaredField.getLong(null));
                            break block12;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported primitive class desc: " + first);
                        }
                    }
                }
                valueText = this.mapObjectValue(declaredField.get(null));
                break;
            }
            return valueText;
        }
        catch (Exception ex) {
            Logger.error("Failed to set field value: " + ex);
            return null;
        }
    }

    private String mapObjectValue(Object value) {
        if (value == null) {
            return "null";
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            return RequestFieldGetMessage.arrayToString(value);
        }
        return value.toString();
    }

    private static String arrayToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        if (value instanceof boolean[]) {
            return Arrays.toString((boolean[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        if (value instanceof char[]) {
            return Arrays.toString((char[])value);
        }
        if (value instanceof short[]) {
            return Arrays.toString((short[])value);
        }
        if (value instanceof double[]) {
            return Arrays.toString((double[])value);
        }
        if (value instanceof float[]) {
            return Arrays.toString((float[])value);
        }
        if (value instanceof long[]) {
            return Arrays.toString((long[])value);
        }
        return Arrays.toString((Object[])value);
    }
}

