/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.message.reply;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.message.reply.AbstractReplyMessage;

public class ReplyPropertiesMessage
extends AbstractReplyMessage {
    public static final StructureCodec<ReplyPropertiesMessage> CODEC = StructureCodec.compose(input -> new ReplyPropertiesMessage(input.readUTF()), (output, value) -> output.writeUTF(value.getProperties()));
    private static final char SEPARATOR = '\u0000';
    private final String properties;

    public ReplyPropertiesMessage(Properties properties) {
        this(ReplyPropertiesMessage.encode(properties));
    }

    public ReplyPropertiesMessage(String properties) {
        this.properties = properties;
    }

    public String getProperties() {
        return this.properties;
    }

    public Map<String, String> mapValue() {
        String[] lines;
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (String line : lines = this.properties.split(String.valueOf('\u0000'))) {
            int index = line.indexOf(61);
            if (index <= 0) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            propertiesMap.put(key, value);
        }
        return propertiesMap;
    }

    @Override
    public String toString() {
        if (this.properties == null) {
            return "ReplyPropertiesMessage[empty]";
        }
        int count = this.properties.length() - this.properties.replace(String.valueOf('\u0000'), "").length();
        return "ReplyPropertiesMessage[" + count + "]";
    }

    private static String encode(Properties properties) {
        StringBuilder sb = new StringBuilder();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> sb.append(key).append('=').append(value).append('\u0000')));
        return sb.toString();
    }
}

