/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.message.reply;

import software.coley.instrument.data.MemberData;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.message.reply.AbstractReplyMessage;

public class ReplyFieldGetMessage
extends AbstractReplyMessage {
    public static final StructureCodec<ReplyFieldGetMessage> CODEC = StructureCodec.compose(input -> new ReplyFieldGetMessage((MemberData)MemberData.CODEC.decode(input), input.readUTF()), (output, value) -> {
        MemberData.CODEC.encode(output, value.getMemberInfo());
        output.writeUTF(value.getValueText());
    });
    private static final String UNKNOWN_VALUE = "?";
    private final MemberData memberData;
    private final String valueText;

    public ReplyFieldGetMessage(MemberData memberData, String valueText) {
        this.memberData = memberData;
        this.valueText = valueText != null ? valueText : UNKNOWN_VALUE;
    }

    public boolean isValueUnknown() {
        return UNKNOWN_VALUE.equals(this.valueText);
    }

    public MemberData getMemberInfo() {
        return this.memberData;
    }

    public String getValueText() {
        return this.valueText;
    }

    @Override
    public String toString() {
        String owner = this.memberData.getOwner();
        String name = this.memberData.getName();
        String desc = this.memberData.getDesc();
        return "ReplyFieldGetMessage[owner='" + owner + '\'' + ", name='" + name + '\'' + ", desc='" + desc + '\'' + ", valueText='" + this.valueText + '\'' + ']';
    }
}

