/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.message.reply;

import java.util.Collection;
import software.coley.instrument.io.codec.CommonCodecs;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.message.reply.AbstractReplyMessage;

public class ReplyClassloaderClassesMessage
extends AbstractReplyMessage {
    public static final StructureCodec<ReplyClassloaderClassesMessage> CODEC = StructureCodec.compose(input -> {
        int id = input.readInt();
        Collection classes = (Collection)CommonCodecs.collection(CommonCodecs.STRING).decode(input);
        return new ReplyClassloaderClassesMessage(id, classes);
    }, (output, value) -> {
        output.writeInt(value.getLoaderId());
        CommonCodecs.collection(CommonCodecs.STRING).encode(output, value.getClasses());
    });
    private final int loaderId;
    private final Collection<String> classes;

    public ReplyClassloaderClassesMessage(int loaderId, Collection<String> classes) {
        this.loaderId = loaderId;
        this.classes = classes;
    }

    public int getLoaderId() {
        return this.loaderId;
    }

    public Collection<String> getClasses() {
        return this.classes;
    }
}

