/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.message;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.message.AbstractMessage;
import software.coley.instrument.message.MessageConstants;
import software.coley.instrument.message.broadcast.BroadcastClassMessage;
import software.coley.instrument.message.broadcast.BroadcastClassloaderMessage;
import software.coley.instrument.message.reply.ReplyClassMessage;
import software.coley.instrument.message.reply.ReplyClassloaderClassesMessage;
import software.coley.instrument.message.reply.ReplyClassloadersMessage;
import software.coley.instrument.message.reply.ReplyFieldGetMessage;
import software.coley.instrument.message.reply.ReplyFieldSetMessage;
import software.coley.instrument.message.reply.ReplyPingMessage;
import software.coley.instrument.message.reply.ReplyPropertiesMessage;
import software.coley.instrument.message.reply.ReplyRedefineMessage;
import software.coley.instrument.message.reply.ReplySetPropertyMessage;
import software.coley.instrument.message.reply.ReplyThreadsMessage;
import software.coley.instrument.message.request.RequestClassMessage;
import software.coley.instrument.message.request.RequestClassloaderClassesMessage;
import software.coley.instrument.message.request.RequestClassloadersMessage;
import software.coley.instrument.message.request.RequestFieldGetMessage;
import software.coley.instrument.message.request.RequestFieldSetMessage;
import software.coley.instrument.message.request.RequestPingMessage;
import software.coley.instrument.message.request.RequestPropertiesMessage;
import software.coley.instrument.message.request.RequestRedefineMessage;
import software.coley.instrument.message.request.RequestSetPropertyMessage;
import software.coley.instrument.message.request.RequestThreadsMessage;

public class MessageFactory
implements MessageConstants {
    private final Map<Class<?>, MessageInfo> messageTypeMap = new IdentityHashMap();
    private final Map<Integer, MessageInfo> messageIdMap = new HashMap<Integer, MessageInfo>();

    private MessageFactory() {
        this.register(100, RequestPingMessage.CODEC, new RequestPingMessage[0]);
        this.register(200, ReplyPingMessage.CODEC, new ReplyPingMessage[0]);
        this.register(110, RequestClassloadersMessage.CODEC, new RequestClassloadersMessage[0]);
        this.register(210, ReplyClassloadersMessage.CODEC, new ReplyClassloadersMessage[0]);
        this.register(101, RequestPropertiesMessage.CODEC, new RequestPropertiesMessage[0]);
        this.register(201, ReplyPropertiesMessage.CODEC, new ReplyPropertiesMessage[0]);
        this.register(102, RequestSetPropertyMessage.CODEC, new RequestSetPropertyMessage[0]);
        this.register(202, ReplySetPropertyMessage.CODEC, new ReplySetPropertyMessage[0]);
        this.register(113, RequestRedefineMessage.CODEC, new RequestRedefineMessage[0]);
        this.register(213, ReplyRedefineMessage.CODEC, new ReplyRedefineMessage[0]);
        this.register(112, RequestClassMessage.CODEC, new RequestClassMessage[0]);
        this.register(212, ReplyClassMessage.CODEC, new ReplyClassMessage[0]);
        this.register(111, RequestClassloaderClassesMessage.CODEC, new RequestClassloaderClassesMessage[0]);
        this.register(211, ReplyClassloaderClassesMessage.CODEC, new ReplyClassloaderClassesMessage[0]);
        this.register(114, RequestFieldGetMessage.CODEC, new RequestFieldGetMessage[0]);
        this.register(214, ReplyFieldGetMessage.CODEC, new ReplyFieldGetMessage[0]);
        this.register(115, RequestFieldSetMessage.CODEC, new RequestFieldSetMessage[0]);
        this.register(215, ReplyFieldSetMessage.CODEC, new ReplyFieldSetMessage[0]);
        this.register(103, RequestThreadsMessage.CODEC, new RequestThreadsMessage[0]);
        this.register(203, ReplyThreadsMessage.CODEC, new ReplyThreadsMessage[0]);
        this.register(300, BroadcastClassloaderMessage.CODEC, new BroadcastClassloaderMessage[0]);
        this.register(301, BroadcastClassMessage.CODEC, new BroadcastClassMessage[0]);
    }

    public MessageInfo getInfo(Object value) {
        MessageInfo info = this.messageTypeMap.get(value.getClass());
        if (info == null) {
            throw new IllegalStateException("Unsupported value type: " + value.getClass());
        }
        return info;
    }

    public MessageInfo getInfo(int key) {
        MessageInfo info = this.messageIdMap.get(key);
        if (info == null) {
            throw new IllegalStateException("Unsupported value key: " + key);
        }
        return info;
    }

    public <T extends AbstractMessage> void register(int id, StructureCodec<T> codec, T ... typeHint) {
        Class<?> type = typeHint.getClass().getComponentType();
        MessageInfo info = new MessageInfo(codec, id);
        this.messageTypeMap.put(type, info);
        this.messageIdMap.put(id, info);
    }

    public static MessageFactory create() {
        return new MessageFactory();
    }

    public static final class MessageInfo {
        private final StructureCodec<AbstractMessage> codec;
        private final int id;

        <T extends AbstractMessage> MessageInfo(StructureCodec<T> codec, int id) {
            this.codec = codec;
            this.id = id;
        }

        public <T extends AbstractMessage> StructureCodec<T> getCodec() {
            return this.codec;
        }

        public int getId() {
            return this.id;
        }
    }
}

