/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.io.codec;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import software.coley.instrument.io.codec.StructureCodec;
import software.coley.instrument.io.codec.StructureDecoder;

public final class CommonCodecs {
    public static final StructureCodec<long[]> LONG_ARRAY = StructureDecoder.decoder(input -> {
        int len = input.readInt();
        long[] arr = new long[len];
        int i = 0;
        while (i < len) {
            arr[i++] = input.readLong();
        }
        return arr;
    }).with((output, value) -> {
        output.writeInt(((long[])value).length);
        int i = 0;
        int j = ((long[])value).length;
        while (i < j) {
            output.writeLong(value[i++]);
        }
    });
    public static final StructureCodec<double[]> DOUBLE_ARRAY = StructureDecoder.decoder(input -> {
        int len = input.readInt();
        double[] arr = new double[len];
        int i = 0;
        while (i < len) {
            arr[i++] = input.readDouble();
        }
        return arr;
    }).with((output, value) -> {
        output.writeInt(((double[])value).length);
        int i = 0;
        int j = ((double[])value).length;
        while (i < j) {
            output.writeDouble(value[i++]);
        }
    });
    public static final StructureCodec<int[]> INT_ARRAY = StructureDecoder.decoder(input -> {
        int len = input.readInt();
        int[] arr = new int[len];
        int i = 0;
        while (i < len) {
            arr[i++] = input.readInt();
        }
        return arr;
    }).with((output, value) -> {
        output.writeInt(((int[])value).length);
        int i = 0;
        int j = ((int[])value).length;
        while (i < j) {
            output.writeInt(value[i++]);
        }
    });
    public static final StructureCodec<byte[]> BYTE_ARRAY = StructureDecoder.decoder(input -> {
        int len = input.readInt();
        byte[] arr = new byte[len];
        int i = 0;
        while (i < len) {
            arr[i++] = input.readByte();
        }
        return arr;
    }).with((output, value) -> {
        output.writeInt(((byte[])value).length);
        int i = 0;
        int j = ((byte[])value).length;
        while (i < j) {
            output.writeByte(value[i++]);
        }
    });
    public static final StructureCodec<float[]> FLOAT_ARRAY = StructureDecoder.decoder(input -> {
        int len = input.readInt();
        float[] arr = new float[len];
        int i = 0;
        while (i < len) {
            arr[i++] = input.readFloat();
        }
        return arr;
    }).with((output, value) -> {
        output.writeInt(((float[])value).length);
        int i = 0;
        int j = ((float[])value).length;
        while (i < j) {
            output.writeFloat(value[i++]);
        }
    });
    public static final StructureCodec<UUID> UUID = StructureDecoder.decoder(input -> new UUID(input.readLong(), input.readLong())).with((output, value) -> {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    });
    public static final StructureCodec<String> STRING = StructureDecoder.decoder(DataInput::readUTF).with(DataOutput::writeUTF);

    private CommonCodecs() {
    }

    public static <T, C extends Collection<T>> StructureCodec<C> collection(StructureCodec<T> valueCodec, IntFunction<? extends C> allocator) {
        return StructureDecoder.decoder(input -> {
            int size = input.readInt();
            Collection c = (Collection)allocator.apply(size);
            while (size-- != 0) {
                c.add(valueCodec.decode(input));
            }
            return c;
        }).with((output, value) -> {
            output.writeInt(value.size());
            for (Object v : value) {
                valueCodec.encode(output, v);
            }
        });
    }

    public static <T> StructureCodec<List<T>> arrayList(StructureCodec<T> valueCodec) {
        return CommonCodecs.collection(valueCodec, ArrayList::new);
    }

    public static <T> StructureCodec<Set<T>> hashSet(StructureCodec<T> valueCodec) {
        return CommonCodecs.collection(valueCodec, HashSet::new);
    }

    public static <T> StructureCodec<Set<T>> linkedHashSet(StructureCodec<T> valueCodec) {
        return CommonCodecs.collection(valueCodec, LinkedHashSet::new);
    }

    public static <T extends Comparable<T>> StructureCodec<SortedSet<T>> treeSet(StructureCodec<T> valueCodec) {
        return CommonCodecs.collection(valueCodec, __ -> new TreeSet());
    }

    public static <T> StructureCodec<Collection<T>> collection(StructureCodec<T> valueCodec) {
        return CommonCodecs.collection(valueCodec, ArrayList::new);
    }

    public static <T> StructureCodec<T> emptyMessage(Supplier<T> constructor) {
        return StructureCodec.compose(input -> constructor.get(), (output, value) -> {});
    }

    public static <T, C> StructureCodec<T> collectionMessage(Function<Collection<C>, T> constructor, Function<T, Collection<C>> collectionGetter, StructureCodec<Collection<C>> listCodec) {
        return StructureCodec.compose(input -> constructor.apply((Collection)listCodec.decode(input)), (output, value) -> listCodec.encode(output, (Collection)collectionGetter.apply(value)));
    }
}

