/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.io;

import java.io.DataOutput;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import software.coley.instrument.io.ByteBufferAllocator;
import software.coley.instrument.io.ByteBufferSanitizer;

public final class ByteBufferDataOutput
implements DataOutput {
    private final ByteBufferSanitizer sanitizer;

    public ByteBufferDataOutput(ByteBufferSanitizer sanitizer) {
        this.sanitizer = sanitizer;
    }

    public ByteBufferDataOutput(ByteBufferAllocator alloc) {
        this(new ByteBufferSanitizer(alloc));
    }

    public ByteBuffer getBuffer() {
        return this.sanitizer.getBuffer();
    }

    public void reset() {
        this.sanitizer.clear();
    }

    public ByteBuffer consume() {
        return this.sanitizer.consume();
    }

    @Override
    public void write(int b) {
        this.buffer(1).put((byte)b);
    }

    @Override
    public void write(byte[] b) {
        this.buffer(b.length).put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.buffer(len).put(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.buffer(1).put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeByte(int v) {
        this.buffer(1).put((byte)v);
    }

    @Override
    public void writeShort(int v) {
        this.buffer(2).putShort((short)v);
    }

    @Override
    public void writeChar(int v) {
        this.buffer(2).putChar((char)v);
    }

    @Override
    public void writeInt(int v) {
        this.buffer(4).putInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.buffer(8).putLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.buffer(4).putFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.buffer(8).putDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        int j = s.length();
        ByteBuffer buf = this.buffer(j);
        for (int i = 0; i < j; ++i) {
            buf.put((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) {
        int j = s.length();
        ByteBuffer buf = this.buffer(j * 2);
        for (int i = 0; i < j; ++i) {
            char v = s.charAt(i);
            buf.put((byte)(v >>> 8));
            buf.put((byte)(v & 0xFF));
        }
    }

    @Override
    public void writeUTF(String s) {
        int position;
        ByteBuffer buffer;
        block3: {
            CoderResult result;
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            CharBuffer cb = CharBuffer.wrap(s);
            buffer = this.buffer(4 + s.length());
            position = buffer.position();
            buffer.putInt(-1);
            while (true) {
                if ((result = encoder.encode(cb, buffer, true)).isUnderflow()) {
                    if (cb.hasRemaining()) {
                        throw new IllegalStateException("Buffer must have no data left");
                    }
                    break block3;
                }
                if (!result.isOverflow()) break;
                buffer = this.buffer(Math.max((int)encoder.averageBytesPerChar() * cb.remaining(), 64));
            }
            throw new IllegalStateException("Unexpected coder result: " + result);
        }
        int newPosition = buffer.position();
        buffer.putInt(position, newPosition - position - 4);
    }

    private ByteBuffer buffer(int size) {
        return this.sanitizer.ensureWriteable(size);
    }
}

