/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.data;

import java.util.Arrays;
import java.util.List;
import software.coley.instrument.io.codec.CommonCodecs;
import software.coley.instrument.io.codec.StructureCodec;

public class ThreadData {
    public static final StructureCodec<StackTraceElement> TRACE_CODEC = StructureCodec.compose(input -> new StackTraceElement(input.readUTF(), input.readUTF(), input.readUTF(), input.readInt()), (output, value) -> {
        String fileName = value.getFileName();
        output.writeUTF(value.getClassName());
        output.writeUTF(value.getMethodName());
        output.writeUTF(fileName == null ? "" : fileName);
        output.writeInt(value.getLineNumber());
    });
    public static final StructureCodec<ThreadData> CODEC = StructureCodec.compose(input -> new ThreadData(input.readLong(), input.readUTF(), input.readUTF(), (List)CommonCodecs.arrayList(TRACE_CODEC).decode(input)), (output, value) -> {
        output.writeLong(value.getId());
        output.writeUTF(value.getName());
        output.writeUTF(value.getState());
        CommonCodecs.arrayList(TRACE_CODEC).encode(output, value.getTrace());
    });
    private final long id;
    private final String name;
    private final String state;
    private final List<StackTraceElement> trace;

    public ThreadData(Thread thread) {
        this.id = thread.getId();
        this.name = thread.getName();
        this.state = thread.getState().name();
        this.trace = Arrays.asList(thread.getStackTrace());
    }

    public ThreadData(long id, String name, String state, List<StackTraceElement> trace) {
        this.id = id;
        this.name = name;
        this.state = state;
        this.trace = trace;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public List<StackTraceElement> getTrace() {
        return this.trace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThreadData other = (ThreadData)o;
        if (this.id != other.id) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        if (!this.state.equals(other.state)) {
            return false;
        }
        return this.trace.equals(other.trace);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.state.hashCode();
        result = 31 * result + this.trace.hashCode();
        return result;
    }

    public String toString() {
        return "ThreadData{id=" + this.id + ", name='" + this.name + '\'' + ", state='" + this.state + '\'' + ", trace=" + this.trace + '}';
    }
}

