/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument.data;

import java.util.Arrays;
import software.coley.instrument.io.codec.CommonCodecs;
import software.coley.instrument.io.codec.StructureCodec;

public class ClassData {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    public static final StructureCodec<ClassData> CODEC = StructureCodec.compose(input -> new ClassData(input.readUTF(), input.readInt(), (byte[])CommonCodecs.BYTE_ARRAY.decode(input)), (output, value) -> {
        output.writeUTF(value.getName());
        output.writeInt(value.getClassLoaderId());
        CommonCodecs.BYTE_ARRAY.encode(output, value.getCode());
    });
    private final String name;
    private final int classLoaderId;
    private final byte[] code;

    public ClassData(String name, int classLoaderId, byte[] code) {
        this.name = name;
        this.classLoaderId = classLoaderId;
        this.code = code == null ? EMPTY_ARRAY : code;
    }

    public boolean hasCode() {
        return this.code != EMPTY_ARRAY;
    }

    public String getName() {
        return this.name;
    }

    public int getClassLoaderId() {
        return this.classLoaderId;
    }

    public byte[] getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassData classData = (ClassData)o;
        if (this.classLoaderId != classData.classLoaderId) {
            return false;
        }
        if (!this.name.equals(classData.name)) {
            return false;
        }
        return Arrays.equals(this.code, classData.code);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.code);
        result = 31 * result + this.classLoaderId;
        return result;
    }

    public String toString() {
        return "ClassData{name='" + this.name + '\'' + ", classLoaderId=" + this.classLoaderId + ", code=byte[" + this.code.length + "]}";
    }
}

