/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument;

import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import software.coley.instrument.InstrumentationHelper;
import software.coley.instrument.data.MemberData;
import software.coley.instrument.data.ThreadData;
import software.coley.instrument.io.ByteBufferAllocator;
import software.coley.instrument.message.AbstractMessage;
import software.coley.instrument.message.MessageFactory;
import software.coley.instrument.message.broadcast.AbstractBroadcastMessage;
import software.coley.instrument.message.reply.ReplyClassMessage;
import software.coley.instrument.message.reply.ReplyClassloaderClassesMessage;
import software.coley.instrument.message.reply.ReplyClassloadersMessage;
import software.coley.instrument.message.reply.ReplyFieldGetMessage;
import software.coley.instrument.message.reply.ReplyFieldSetMessage;
import software.coley.instrument.message.reply.ReplyPingMessage;
import software.coley.instrument.message.reply.ReplyPropertiesMessage;
import software.coley.instrument.message.reply.ReplyRedefineMessage;
import software.coley.instrument.message.reply.ReplySetPropertyMessage;
import software.coley.instrument.message.reply.ReplyThreadsMessage;
import software.coley.instrument.message.request.RequestClassMessage;
import software.coley.instrument.message.request.RequestClassloaderClassesMessage;
import software.coley.instrument.message.request.RequestClassloadersMessage;
import software.coley.instrument.message.request.RequestFieldGetMessage;
import software.coley.instrument.message.request.RequestFieldSetMessage;
import software.coley.instrument.message.request.RequestPingMessage;
import software.coley.instrument.message.request.RequestPropertiesMessage;
import software.coley.instrument.message.request.RequestRedefineMessage;
import software.coley.instrument.message.request.RequestSetPropertyMessage;
import software.coley.instrument.message.request.RequestThreadsMessage;
import software.coley.instrument.sock.ChannelHandler;
import software.coley.instrument.util.Discovery;
import software.coley.instrument.util.Logger;
import software.coley.instrument.util.NamedThreadFactory;

public class Server {
    public static final int DEFAULT_PORT = 25252;
    private final Set<ChannelHandler> clients = Collections.synchronizedSet(new HashSet());
    private final Map<Class<?>, ReplyHandler<?>> replyHandlerMap = new IdentityHashMap();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ServerSocketChannel serverChannel;
    private final InstrumentationHelper instrumentation;
    private final ByteBufferAllocator allocator;
    private final MessageFactory factory;
    private final int port;

    private Server(Instrumentation instrumentation, InetSocketAddress address, ByteBufferAllocator allocator, MessageFactory factory) throws IOException {
        Logger.info("Opening server on: " + address);
        this.serverChannel = ServerSocketChannel.open().bind(address);
        this.instrumentation = new InstrumentationHelper(this, instrumentation);
        this.allocator = allocator;
        this.factory = factory;
        this.port = address.getPort();
        Discovery.setupDiscovery(this.port);
    }

    public static Server open(Instrumentation instrumentation, InetSocketAddress address, ByteBufferAllocator allocator, MessageFactory factory) throws IOException {
        Server server = new Server(instrumentation, address, allocator, factory);
        server.acceptLoop();
        return server;
    }

    public InstrumentationHelper getInstrumentation() {
        return this.instrumentation;
    }

    public Set<ChannelHandler> getClients() {
        return this.clients;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Discovery.removeDiscovery(this.port);
            Set<ChannelHandler> set = this.clients;
            synchronized (set) {
                int count = this.clients.size();
                if (count == 0) {
                    Logger.debug("No clients connected to close");
                } else if (count == 1) {
                    Logger.debug("Closing client connection");
                } else {
                    Logger.debug("Closing " + count + " client connections");
                }
                for (ChannelHandler ch : this.clients) {
                    ch.shutdown();
                }
            }
            try {
                this.serverChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Logger.info("Server closed");
        } else {
            Logger.debug("Server already closed");
        }
    }

    public void broadcast(AbstractBroadcastMessage message) {
        for (ChannelHandler client : this.clients) {
            client.write(message, -1);
        }
    }

    private void acceptLoop() {
        Executors.newSingleThreadExecutor(new NamedThreadFactory(ChannelHandler.threadNameClientAccept)).submit(() -> {
            try {
                while (!this.isClosed()) {
                    SocketChannel accept = this.serverChannel.accept();
                    ChannelHandler ch = new ChannelHandler(accept, this.allocator, this.factory, closedCh -> {
                        this.clients.remove(closedCh);
                        Logger.info("Disconnect client: " + accept.toString());
                    });
                    this.configureChannel(ch);
                    Set<ChannelHandler> set = this.clients;
                    synchronized (set) {
                        Logger.info("New client: " + accept.toString());
                        this.clients.add(ch);
                        ch.start();
                    }
                }
                Logger.info("Accept loop ending, socket is closed");
            }
            catch (IOException ex) {
                Logger.error("Server accept-loop failure: " + ex);
                this.close();
            }
        });
    }

    private void configureChannel(ChannelHandler ch) {
        ch.setAllResponsesListener((frameId, value) -> {
            if (frameId != -1) {
                Logger.debug("Server handling request[id=" + frameId + ", value=" + value + "]");
                try {
                    ReplyHandler<?> handler = this.replyHandlerMap.get(value.getClass());
                    if (handler != null) {
                        handler.accept(frameId, value);
                    } else {
                        Logger.warn("No handler for request: " + value);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        });
        InstrumentationHelper inst = this.instrumentation;
        this.answer(ch, RequestPingMessage.class, ReplyPingMessage::new);
        this.answer(ch, RequestThreadsMessage.class, () -> new ReplyThreadsMessage(Thread.getAllStackTraces().keySet().stream().map(ThreadData::new).collect(Collectors.toList())));
        this.answer(ch, RequestPropertiesMessage.class, () -> new ReplyPropertiesMessage(System.getProperties()));
        this.answer(ch, RequestSetPropertyMessage.class, (? super T req) -> {
            System.getProperties().put(req.getKey(), req.getValue());
            return new ReplySetPropertyMessage();
        });
        this.answer(ch, RequestClassloadersMessage.class, () -> new ReplyClassloadersMessage(inst.getLoaders()));
        this.answer(ch, RequestClassloaderClassesMessage.class, (? super T req) -> {
            int loaderId = req.getLoaderId();
            return new ReplyClassloaderClassesMessage(loaderId, inst.getLoaderClasses(loaderId));
        });
        this.answer(ch, RequestClassMessage.class, (? super T req) -> new ReplyClassMessage(inst.getClassData(req.getLoaderId(), req.getName())));
        this.answer(ch, RequestRedefineMessage.class, (? super T req) -> {
            inst.lock();
            try {
                String message = inst.redefineClass(req.getLoaderId(), req.getClassName(), req.getBytecode());
                if (message == null) {
                    ReplyRedefineMessage replyRedefineMessage = new ReplyRedefineMessage(".");
                    return replyRedefineMessage;
                }
                ReplyRedefineMessage replyRedefineMessage = new ReplyRedefineMessage(message);
                return replyRedefineMessage;
            }
            catch (Exception ex) {
                ReplyRedefineMessage replyRedefineMessage = new ReplyRedefineMessage(ex);
                return replyRedefineMessage;
            }
            finally {
                inst.unlock();
            }
        });
        this.answer(ch, RequestFieldGetMessage.class, (? super T req) -> {
            MemberData member = req.getMemberInfo();
            try {
                return new ReplyFieldGetMessage(member, req.lookupValue());
            }
            catch (Exception ex) {
                return new ReplyFieldGetMessage(member, null);
            }
        });
        this.answer(ch, RequestFieldSetMessage.class, (? super T req) -> {
            try {
                req.assignValue();
                return new ReplyFieldSetMessage(".");
            }
            catch (Exception ex) {
                return new ReplyFieldSetMessage(ex.toString());
            }
        });
    }

    private <T extends AbstractMessage, R extends AbstractMessage> void answer(ChannelHandler ch, Class<T> type, Function<? super T, R> fn) {
        this.addHandler(type, (frameId, value) -> ch.write((AbstractMessage)fn.apply(value), frameId));
    }

    private <T extends AbstractMessage, R extends AbstractMessage> void answer(ChannelHandler ch, Class<T> type, Supplier<R> fn) {
        this.addHandler(type, (frameId, value) -> ch.write((AbstractMessage)fn.get(), frameId));
    }

    private <T extends AbstractMessage> void addHandler(Class<T> type, ReplyHandler<T> handler) {
        this.replyHandlerMap.put(type, handler);
    }

    private static interface ReplyHandler<T extends AbstractMessage> {
        public void accept(int var1, T var2);
    }
}

