/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import software.coley.instrument.Agent;
import software.coley.instrument.util.Streams;

public class Extractor {
    public static void main(String[] args) throws IOException {
        if (args.length > 0) {
            Extractor.extractToPath(Paths.get(args[0], new String[0]));
        } else {
            System.err.println("Provide a target path to extract to");
        }
    }

    public static void extractToPath(Path path) throws IOException {
        List<Item> items = Extractor.collectSelfItems();
        Extractor.writeItems(items, path);
    }

    public static List<Item> collectSelfItems() throws IOException {
        Path selfPath;
        try {
            selfPath = Paths.get(Extractor.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException syntaxException) {
            throw new IOException(syntaxException);
        }
        if (!Files.exists(selfPath, new LinkOption[0])) {
            throw new IOException("Source-path of extractor does not exist: " + selfPath);
        }
        ArrayList<Item> list = new ArrayList<Item>();
        String prefix = Extractor.class.getPackage().getName().replace('.', '/');
        if (Files.isRegularFile(selfPath, new LinkOption[0])) {
            try (ZipFile file = new ZipFile(selfPath.toFile());){
                Enumeration<? extends ZipEntry> entries = file.entries();
                while (entries.hasMoreElements()) {
                    String name;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(name = entry.getName()).startsWith(prefix)) continue;
                    list.add(new Item(entry.getName(), Streams.readStream(file.getInputStream(entry))));
                }
            }
        } else if (Files.isDirectory(selfPath, new LinkOption[0])) {
            Files.walk(selfPath, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && path.toString().endsWith(".class")).forEach(path -> {
                String localName = selfPath.relativize((Path)path).toString().replace('\\', '/');
                if (localName.startsWith(prefix)) {
                    try {
                        list.add(new Item(localName, Files.readAllBytes(path)));
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Could not read class: " + localName, ex);
                    }
                }
            });
        } else {
            throw new IOException("Source-path of extractor exists, but is not a file or directory: " + selfPath);
        }
        return list;
    }

    public static void writeItems(List<Item> items, Path path) throws IOException {
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(new Attributes.Name("Premain-Class"), Agent.class.getName());
        manifest.getMainAttributes().put(new Attributes.Name("Agent-Class"), Agent.class.getName());
        manifest.getMainAttributes().put(new Attributes.Name("Can-Redefine-Classes"), "true");
        manifest.getMainAttributes().put(new Attributes.Name("Can-Retransform-Classes"), "true");
        try (JarOutputStream jar = new JarOutputStream(Files.newOutputStream(path, new OpenOption[0]), manifest);){
            for (Item item : items) {
                JarEntry jarEntry = new JarEntry(item.getPath());
                jar.putNextEntry(jarEntry);
                jar.write(item.getContent());
                jar.closeEntry();
            }
        }
    }

    public static class Item {
        private final String path;
        private final byte[] content;

        private Item(String path, byte[] content) {
            this.path = path;
            this.content = content;
        }

        public String getPath() {
            return this.path;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

