/*
 * Decompiled with CFR 0.152.
 */
package software.coley.instrument;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import software.coley.instrument.io.ByteBufferAllocator;
import software.coley.instrument.message.AbstractMessage;
import software.coley.instrument.message.MessageFactory;
import software.coley.instrument.message.reply.AbstractReplyMessage;
import software.coley.instrument.message.request.AbstractRequestMessage;
import software.coley.instrument.sock.BroadcastListener;
import software.coley.instrument.sock.ChannelHandler;
import software.coley.instrument.sock.ReplyResult;
import software.coley.instrument.sock.WriteResult;
import software.coley.instrument.util.Logger;

public class Client {
    private final InetSocketAddress hostAddress;
    private final SocketChannel socketChannel = SocketChannel.open();
    private final ChannelHandler handler;
    private final String ip;
    private final int port;

    public Client(String ip, int port, ByteBufferAllocator allocator, MessageFactory factory) throws IOException {
        this.hostAddress = new InetSocketAddress(ip, port);
        this.handler = new ChannelHandler(this.socketChannel, allocator, factory, null);
        this.ip = ip;
        this.port = port;
    }

    public InetSocketAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setBroadcastListener(BroadcastListener listener) {
        this.handler.setBroadcastListener(listener);
    }

    public boolean connect() {
        try {
            this.connectThrowing();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void connectThrowing() throws Exception {
        try {
            if (this.socketChannel.connect(this.hostAddress)) {
                this.handler.start();
                return;
            }
            throw new IOException("Could not connect to: " + this.hostAddress);
        }
        catch (Exception ex) {
            Logger.error("Failed to connect to host: " + this.hostAddress + " - " + ex);
            throw ex;
        }
    }

    public void close() throws IOException {
        this.handler.shutdown();
        this.socketChannel.close();
    }

    private void quietClose() {
        try {
            this.close();
        }
        catch (IOException ex) {
            Logger.error("Failed to close client: " + ex);
        }
    }

    public <T extends AbstractMessage> WriteResult<T> sendAsync(T message) {
        return this.handler.write(message, this.handler.getNextFrameId());
    }

    public <ReplyType extends AbstractReplyMessage, RequestType extends AbstractRequestMessage<ReplyType>> ReplyResult<RequestType, ReplyType> sendAsync(RequestType message, Consumer<ReplyType> replyHandler) {
        CompletableFuture replyFuture = new CompletableFuture();
        int frameId = this.handler.getNextFrameId();
        this.handler.addResponseListener(frameId, (responseId, value) -> {
            try {
                AbstractReplyMessage reply = (AbstractReplyMessage)value;
                if (replyHandler != null) {
                    replyHandler.accept(reply);
                }
                replyFuture.complete(reply);
            }
            catch (Throwable t) {
                t.printStackTrace();
                replyFuture.completeExceptionally(t);
            }
        });
        WriteResult<RequestType> writeResult = this.handler.write(message, frameId);
        return new ReplyResult(writeResult, replyFuture);
    }

    public synchronized void sendBlocking(AbstractMessage message) {
        String title = "sending message (without reply expected)";
        try {
            WriteResult<AbstractMessage> result = this.sendAsync(message);
            title = "sending message[id=" + result.getFrameId() + "] (without reply expected)";
            result.getFuture().get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.error("Client interrupted while " + title);
            this.quietClose();
        }
        catch (ExecutionException e) {
            Logger.error("Client encountered error " + title + " into buffer: " + e.getCause());
            this.quietClose();
        }
        catch (TimeoutException e) {
            Logger.error("Client timed out " + title);
            this.quietClose();
        }
    }

    public synchronized <ReplyType extends AbstractReplyMessage, RequestType extends AbstractRequestMessage<ReplyType>> void sendBlocking(RequestType message, Consumer<ReplyType> replyHandler) {
        String title = "sending message (reply expected)";
        try {
            ReplyResult<RequestType, ReplyType> result = this.sendAsync(message, replyHandler);
            WriteResult<RequestType> writeResult = result.getWriteResult();
            title = "sending message[id=" + writeResult.getFrameId() + "] (reply expected)";
            result.getReplyFuture().get(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.error("Client interrupted while " + title);
            this.quietClose();
        }
        catch (ExecutionException e) {
            Logger.error("Client encountered error " + title + " into buffer: " + e.getCause());
            this.quietClose();
        }
        catch (TimeoutException e) {
            Logger.error("Client timed out " + title);
            this.quietClose();
        }
    }
}

