/**
 * The pipeline module vends an extension to CDK's CodePipeline construct, named PDKPipeline. It additionally creates a CodeCommit repository and by default is configured to build the project assumming nx-monorepo is being used (although this can be changed). A Sonarqube Scanner can also be configured to trigger a scan whenever the synth build job completes successfully. This Scanner is non-blocking and as such is not instrumented as part of the pipeline.
 * <p>
 * The architecture for the PDKPipeline is as follows:
 * <p>
 * <blockquote><pre>
 * CodeCommit repository -&gt; CodePipeline
 *                              |-&gt; EventBridge Rule (On Build Succeded) -&gt; CodeBuild (Sonar Scan)
 *                              |-&gt; Secret (sonarqube token)
 * </pre></blockquote>
 * <p>
 * This module additionally vends multiple Projen Projects, one for each of the supported languages. These projects aim to bootstrap your project by providing sample code which uses the PDKPipeline construct.
 * <p>
 * For example, in .projenrc.ts:
 * <p>
 * <blockquote><pre>
 * new PDKPipelineTsProject({
 *     cdkVersion: "2.1.0",
 *     defaultReleaseBranch: "mainline",
 *     devDeps: ["aws-prototyping-sdk"],
 *     name: "my-pipeline",
 * });
 * </pre></blockquote>
 * <p>
 * This will generate a package in typescript containing CDK boilerplate for a pipeline stack (which instantiates PDKPipeline), sets up a Dev stage with an Application Stage containing an empty ApplicationStack (to be implemented). Once this package is synthesized, you can run <code>npx projen</code> and projen will synthesize your cloudformation.
 * <p>
 * Alternatively, you can initialize a project using the cli (in an empty directory) for each of the supported languages as follows:
 * <p>
 * <blockquote><pre>
 * # Typescript
 * npx projen new --from aws-prototyping-sdk pdk-pipeline-ts
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * # Python
 * npx projen new --from aws-prototyping-sdk pdk-pipeline-py
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * # Java
 * npx projen new --from aws-prototyping-sdk pdk-pipeline-java
 * </pre></blockquote>
 * <p>
 * <h3>CDK Nag</h3>
 * <p>
 * In order to keep CDK Nag happy, make sure you build the pipeline before synth as per https://github.com/aws/aws-cdk/issues/18440.
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.aws.awsprototypingsdk.pipeline;
