package software.aws.awsprototypingsdk.openapigateway;

/**
 * (experimental) Represents an api gateway integration.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-19T06:30:21.314Z")
@software.amazon.jsii.Jsii(module = software.aws.awsprototypingsdk.openapigateway.$Module.class, fqn = "@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration")
@software.amazon.jsii.Jsii.Proxy(ApiGatewayIntegration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ApiGatewayIntegration extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A list of request parameters whose values are to be cached.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheKeyParameters() {
        return null;
    }

    /**
     * (experimental) An API-specific tag group of related cached parameters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCacheNamespace() {
        return null;
    }

    /**
     * (experimental) The ID of a VpcLink for the private integration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html">https://docs.aws.amazon.com/apigateway/latest/api/API_VpcLink.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionId() {
        return null;
    }

    /**
     * (experimental) The integration connection type.
     * <p>
     * The valid value is "VPC_LINK" for private integration or "INTERNET", otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionType() {
        return null;
    }

    /**
     * (experimental) Request payload encoding conversion types.
     * <p>
     * Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
     * into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
     * payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
     * base64-decoded blob or passing through a binary payload natively without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContentHandling() {
        return null;
    }

    /**
     * (experimental) For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role.
     * <p>
     * If unspecified, credentials default
     * to resource-based permissions that must be added manually to allow the API to access the resource. For more
     * information, see Granting Permissions Using a Resource Policy.
     * <p>
     * Note: When using IAM credentials, make sure that AWS STS Regional endpoints are enabled for the Region where this
     * API is deployed for best performance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getCredentials() {
        return null;
    }

    /**
     * (experimental) The HTTP method used in the integration request.
     * <p>
     * For Lambda function invocations, the value must be POST.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
        return null;
    }

    /**
     * (experimental) Specifies how a request payload of unmapped content type is passed through the integration request without modification.
     * <p>
     * Supported values are when_no_templates, when_no_match, and never.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior">https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#passthroughBehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPassthroughBehavior() {
        return null;
    }

    /**
     * (experimental) Specifies mappings from method request parameters to integration request parameters.
     * <p>
     * Supported request parameters
     * are querystring, path, header, and body.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestParameters.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
        return null;
    }

    /**
     * (experimental) Mapping templates for a request payload of specified MIME types.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-requestTemplates.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
        return null;
    }

    /**
     * (experimental) Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions-integration-responses.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse> getResponses() {
        return null;
    }

    /**
     * (experimental) Custom timeout between 50 and 29,000 milliseconds.
     * <p>
     * The default value is 29,000 milliseconds or 29 seconds.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMillis() {
        return null;
    }

    /**
     * (experimental) Specifies the TLS configuration for an integration.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-extensions-integration-tls-config.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig getTlsConfig() {
        return null;
    }

    /**
     * (experimental) The type of integration with the specified backend.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type">https://docs.aws.amazon.com/apigateway/latest/api/API_Integration.html#type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * (experimental) The endpoint URI of the backend.
     * <p>
     * For integrations of the aws type, this is an ARN value.
     * For the HTTP integration, this is the URL of the HTTP endpoint including the https or http scheme.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUri() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiGatewayIntegration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiGatewayIntegration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ApiGatewayIntegration> {
        java.util.List<java.lang.String> cacheKeyParameters;
        java.lang.String cacheNamespace;
        java.lang.String connectionId;
        java.lang.String connectionType;
        java.lang.String contentHandling;
        java.lang.String credentials;
        java.lang.String httpMethod;
        java.lang.String passthroughBehavior;
        java.util.Map<java.lang.String, java.lang.String> requestParameters;
        java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        java.util.Map<java.lang.String, software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse> responses;
        java.lang.Number timeoutInMillis;
        software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig tlsConfig;
        java.lang.String type;
        java.lang.String uri;

        /**
         * Sets the value of {@link ApiGatewayIntegration#getCacheKeyParameters}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
            this.cacheKeyParameters = cacheKeyParameters;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getCacheNamespace}
         * @param cacheNamespace An API-specific tag group of related cached parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cacheNamespace(java.lang.String cacheNamespace) {
            this.cacheNamespace = cacheNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getConnectionId}
         * @param connectionId The ID of a VpcLink for the private integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionId(java.lang.String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getConnectionType}
         * @param connectionType The integration connection type.
         *                       The valid value is "VPC_LINK" for private integration or "INTERNET", otherwise.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder connectionType(java.lang.String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getContentHandling}
         * @param contentHandling Request payload encoding conversion types.
         *                        Valid values are 1) CONVERT_TO_TEXT, for converting a binary payload
         *                        into a base64-encoded string or converting a text payload into a utf-8-encoded string or passing through the text
         *                        payload natively without modification, and 2) CONVERT_TO_BINARY, for converting a text payload into a
         *                        base64-decoded blob or passing through a binary payload natively without modification.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder contentHandling(java.lang.String contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getCredentials}
         * @param credentials For AWS IAM role-based credentials, specify the ARN of an appropriate IAM role.
         *                    If unspecified, credentials default
         *                    to resource-based permissions that must be added manually to allow the API to access the resource. For more
         *                    information, see Granting Permissions Using a Resource Policy.
         *                    <p>
         *                    Note: When using IAM credentials, make sure that AWS STS Regional endpoints are enabled for the Region where this
         *                    API is deployed for best performance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder credentials(java.lang.String credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getHttpMethod}
         * @param httpMethod The HTTP method used in the integration request.
         *                   For Lambda function invocations, the value must be POST.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpMethod(java.lang.String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getPassthroughBehavior}
         * @param passthroughBehavior Specifies how a request payload of unmapped content type is passed through the integration request without modification.
         *                            Supported values are when_no_templates, when_no_match, and never.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder passthroughBehavior(java.lang.String passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getRequestParameters}
         * @param requestParameters Specifies mappings from method request parameters to integration request parameters.
         *                          Supported request parameters
         *                          are querystring, path, header, and body.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getRequestTemplates}
         * @param requestTemplates Mapping templates for a request payload of specified MIME types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getResponses}
         * @param responses Defines the method's responses and specifies desired parameter mappings or payload mappings from integration responses to method responses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder responses(java.util.Map<java.lang.String, ? extends software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse> responses) {
            this.responses = (java.util.Map<java.lang.String, software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse>)responses;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getTimeoutInMillis}
         * @param timeoutInMillis Custom timeout between 50 and 29,000 milliseconds.
         *                        The default value is 29,000 milliseconds or 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getTlsConfig}
         * @param tlsConfig Specifies the TLS configuration for an integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tlsConfig(software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getType}
         * @param type The type of integration with the specified backend.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ApiGatewayIntegration#getUri}
         * @param uri The endpoint URI of the backend.
         *            For integrations of the aws type, this is an ARN value.
         *            For the HTTP integration, this is the URL of the HTTP endpoint including the https or http scheme.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder uri(java.lang.String uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiGatewayIntegration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ApiGatewayIntegration build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiGatewayIntegration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiGatewayIntegration {
        private final java.util.List<java.lang.String> cacheKeyParameters;
        private final java.lang.String cacheNamespace;
        private final java.lang.String connectionId;
        private final java.lang.String connectionType;
        private final java.lang.String contentHandling;
        private final java.lang.String credentials;
        private final java.lang.String httpMethod;
        private final java.lang.String passthroughBehavior;
        private final java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private final java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private final java.util.Map<java.lang.String, software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse> responses;
        private final java.lang.Number timeoutInMillis;
        private final software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig tlsConfig;
        private final java.lang.String type;
        private final java.lang.String uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cacheKeyParameters = software.amazon.jsii.Kernel.get(this, "cacheKeyParameters", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.cacheNamespace = software.amazon.jsii.Kernel.get(this, "cacheNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionId = software.amazon.jsii.Kernel.get(this, "connectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.responses = software.amazon.jsii.Kernel.get(this, "responses", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse.class)));
            this.timeoutInMillis = software.amazon.jsii.Kernel.get(this, "timeoutInMillis", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.tlsConfig = software.amazon.jsii.Kernel.get(this, "tlsConfig", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.uri = software.amazon.jsii.Kernel.get(this, "uri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cacheKeyParameters = builder.cacheKeyParameters;
            this.cacheNamespace = builder.cacheNamespace;
            this.connectionId = builder.connectionId;
            this.connectionType = builder.connectionType;
            this.contentHandling = builder.contentHandling;
            this.credentials = builder.credentials;
            this.httpMethod = builder.httpMethod;
            this.passthroughBehavior = builder.passthroughBehavior;
            this.requestParameters = builder.requestParameters;
            this.requestTemplates = builder.requestTemplates;
            this.responses = (java.util.Map<java.lang.String, software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse>)builder.responses;
            this.timeoutInMillis = builder.timeoutInMillis;
            this.tlsConfig = builder.tlsConfig;
            this.type = builder.type;
            this.uri = builder.uri;
        }

        @Override
        public final java.util.List<java.lang.String> getCacheKeyParameters() {
            return this.cacheKeyParameters;
        }

        @Override
        public final java.lang.String getCacheNamespace() {
            return this.cacheNamespace;
        }

        @Override
        public final java.lang.String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final java.lang.String getConnectionType() {
            return this.connectionType;
        }

        @Override
        public final java.lang.String getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final java.lang.String getCredentials() {
            return this.credentials;
        }

        @Override
        public final java.lang.String getHttpMethod() {
            return this.httpMethod;
        }

        @Override
        public final java.lang.String getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final java.util.Map<java.lang.String, software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationResponse> getResponses() {
            return this.responses;
        }

        @Override
        public final java.lang.Number getTimeoutInMillis() {
            return this.timeoutInMillis;
        }

        @Override
        public final software.aws.awsprototypingsdk.openapigateway.ApiGatewayIntegrationTlsConfig getTlsConfig() {
            return this.tlsConfig;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getUri() {
            return this.uri;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCacheKeyParameters() != null) {
                data.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
            }
            if (this.getCacheNamespace() != null) {
                data.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
            }
            if (this.getConnectionId() != null) {
                data.set("connectionId", om.valueToTree(this.getConnectionId()));
            }
            if (this.getConnectionType() != null) {
                data.set("connectionType", om.valueToTree(this.getConnectionType()));
            }
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHttpMethod() != null) {
                data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getResponses() != null) {
                data.set("responses", om.valueToTree(this.getResponses()));
            }
            if (this.getTimeoutInMillis() != null) {
                data.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
            }
            if (this.getTlsConfig() != null) {
                data.set("tlsConfig", om.valueToTree(this.getTlsConfig()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }
            if (this.getUri() != null) {
                data.set("uri", om.valueToTree(this.getUri()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-prototyping-sdk/open-api-gateway.ApiGatewayIntegration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiGatewayIntegration.Jsii$Proxy that = (ApiGatewayIntegration.Jsii$Proxy) o;

            if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
            if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
            if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
            if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.httpMethod != null ? !this.httpMethod.equals(that.httpMethod) : that.httpMethod != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            if (this.responses != null ? !this.responses.equals(that.responses) : that.responses != null) return false;
            if (this.timeoutInMillis != null ? !this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis != null) return false;
            if (this.tlsConfig != null ? !this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig != null) return false;
            if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
            result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
            result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
            result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.responses != null ? this.responses.hashCode() : 0);
            result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
            result = 31 * result + (this.tlsConfig != null ? this.tlsConfig.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
