/**
 * <h2>Getting started</h2>
 * <p>
 * To create a new <a href="https://github.com/aws/awsui-documentation">AWS UI</a> React Typescript Project, there are a couple of options:
 * <p>
 * <h3>Via Projen CLI</h3>
 * <p>
 * <blockquote><pre>
 * npx projen new --from &#64;aws-prototyping-sdk/awsui-react-ts-website awsui-react-ts-website [--application-name &lt;your-app&gt;]
 * </pre></blockquote>
 * <p>
 * <h3>Programmatically</h3>
 * <p>
 * <blockquote><pre>
 * new AwsUiReactTsWebsiteProject({
 *     defaultReleaseBranch: "mainline",
 *     name: "&lt;name-of-package&gt;",
 *     applicationName: "&lt;name-of-app&gt;",
 * });
 * </pre></blockquote>
 * <p>
 * <h3>Running your synthesized Application</h3>
 * <p>
 * To run your synthesized application locally, run <code>npx projen dev</code>.
 * <p>
 * <h2>Developer Notes</h2>
 * <p>
 * To enable Cognito auth, ensure you have a runtime-config.json file in the root of your deployed project which at least contains the following:
 * <p>
 * <blockquote><pre>
 * {
 *     "region": "&lt;aws-region&gt;",
 *     "identityPoolId":"&lt;identity-pool-id&gt;",
 *     "userPoolId":"&lt;user-pool-id&gt;",
 *     "userPoolWebClientId":"&lt;user-pool-web-client-id&gt;"
 * }
 * </pre></blockquote>
 * <p>
 * The easiest way to get this set up is to use the static-website + identity packages to deploy your website.
 * <p>
 * An example of how to do this is as follows:
 * <p>
 * <blockquote><pre>
 * const userIdentity = new UserIdentity(this, 'UserIdentity');
 * new StaticWebsite(this, 'StaticWebsite', {
 *     websiteContentPath: '&lt;relative&gt;/&lt;path&gt;/&lt;to&gt;/&lt;built&gt;/&lt;website&gt;',
 *     runtimeOptions: {
 *         jsonPayload: {
 *             region: Stack.of(this).region,
 *             identityPoolId: userIdentity.identityPool.identityPoolId,
 *             userPoolId: userIdentity.userPool?.userPoolId,
 *             userPoolWebClientId: userIdentity.userPoolClient?.userPoolClientId,
 *         }
 *     },
 * });
 * </pre></blockquote>
 * <p>
 * For local development, you will need to copy the generated runtime-config.json file into your /public directory. An example on how to do this is as follows:
 * <p>
 * <blockquote><pre>
 * curl https://dxxxxxxxxxx.cloudfront.net/runtime-config.json &gt; public/runtime-config.json
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
package software.aws.awsprototypingsdk.awsuireacttswebsite;
