package software.aws.awsprototypingsdk.pipeline;

/**
 * Properties to configure the PDKPipeline.
 * <p>
 * Note: Due to limitations with JSII and generic support it should be noted that
 * the synth, synthShellStepPartialProps.input and
 * synthShellStepPartialProps.primaryOutputDirectory properties will be ignored
 * if passed in to this construct.
 * <p>
 * synthShellStepPartialProps.commands is marked as a required field, however
 * if you pass in [] the default commands of this construct will be retained.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.62.0 (build 293ac17)", date = "2022-07-21T04:39:58.671Z")
@software.amazon.jsii.Jsii(module = software.aws.awsprototypingsdk.$Module.class, fqn = "aws-prototyping-sdk.pipeline.PDKPipelineProps")
@software.amazon.jsii.Jsii.Proxy(PDKPipelineProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PDKPipelineProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.pipelines.CodePipelineProps {

    /**
     * Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrimarySynthDirectory();

    /**
     * Name of the CodeCommit repository to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName();

    /**
     * Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getCodeCommitRemovalPolicy() {
        return null;
    }

    /**
     * Branch to trigger the pipeline execution.
     * <p>
     * Default: mainline
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultBranchName() {
        return null;
    }

    /**
     * Configuration for enabling Sonarqube code scanning on a successful synth.
     * <p>
     * Default: undefined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig getSonarCodeScannerConfig() {
        return null;
    }

    /**
     * PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.
     * <p>
     * To override these defaults
     * and/or provide additional inputs, specify env settings, etc you can provide
     * a partial ShellStepProps.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.pipelines.ShellStepProps getSynthShellStepPartialProps() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PDKPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PDKPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PDKPipelineProps> {
        java.lang.String primarySynthDirectory;
        java.lang.String repositoryName;
        software.amazon.awscdk.RemovalPolicy codeCommitRemovalPolicy;
        java.lang.String defaultBranchName;
        software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig sonarCodeScannerConfig;
        software.amazon.awscdk.pipelines.ShellStepProps synthShellStepPartialProps;
        software.amazon.awscdk.pipelines.IFileSetProducer synth;
        software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults;
        java.lang.String cliVersion;
        software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults;
        software.amazon.awscdk.services.codepipeline.Pipeline codePipeline;
        java.lang.Boolean crossAccountKeys;
        java.util.List<software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials;
        java.lang.Boolean dockerEnabledForSelfMutation;
        java.lang.Boolean dockerEnabledForSynth;
        java.lang.String pipelineName;
        java.lang.Boolean publishAssetsInParallel;
        java.lang.Boolean reuseCrossRegionSupportStacks;
        java.lang.Boolean selfMutation;
        software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults;
        software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults;

        /**
         * Sets the value of {@link PDKPipelineProps#getPrimarySynthDirectory}
         * @param primarySynthDirectory Output directory for cdk synthesized artifacts i.e: packages/infra/cdk.out. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primarySynthDirectory(java.lang.String primarySynthDirectory) {
            this.primarySynthDirectory = primarySynthDirectory;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getRepositoryName}
         * @param repositoryName Name of the CodeCommit repository to create. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(java.lang.String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getCodeCommitRemovalPolicy}
         * @param codeCommitRemovalPolicy Possible values for a resource's Removal Policy The removal policy controls what happens to the resource if it stops being managed by CloudFormation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeCommitRemovalPolicy(software.amazon.awscdk.RemovalPolicy codeCommitRemovalPolicy) {
            this.codeCommitRemovalPolicy = codeCommitRemovalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getDefaultBranchName}
         * @param defaultBranchName Branch to trigger the pipeline execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultBranchName(java.lang.String defaultBranchName) {
            this.defaultBranchName = defaultBranchName;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getSonarCodeScannerConfig}
         * @param sonarCodeScannerConfig Configuration for enabling Sonarqube code scanning on a successful synth.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sonarCodeScannerConfig(software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig sonarCodeScannerConfig) {
            this.sonarCodeScannerConfig = sonarCodeScannerConfig;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getSynthShellStepPartialProps}
         * @param synthShellStepPartialProps PDKPipeline by default assumes a NX Monorepo structure for it's codebase and uses sane defaults for the install and run commands.
         *                                   To override these defaults
         *                                   and/or provide additional inputs, specify env settings, etc you can provide
         *                                   a partial ShellStepProps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthShellStepPartialProps(software.amazon.awscdk.pipelines.ShellStepProps synthShellStepPartialProps) {
            this.synthShellStepPartialProps = synthShellStepPartialProps;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getSynth}
         * @param synth The build step that produces the CDK Cloud Assembly. This parameter is required.
         *              The primary output of this step needs to be the <code>cdk.out</code> directory
         *              generated by the <code>cdk synth</code> command.
         *              <p>
         *              If you use a <code>ShellStep</code> here and you don't configure an output directory,
         *              the output directory will automatically be assumed to be <code>cdk.out</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synth(software.amazon.awscdk.pipelines.IFileSetProducer synth) {
            this.synth = synth;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getAssetPublishingCodeBuildDefaults}
         * @param assetPublishingCodeBuildDefaults Additional customizations to apply to the asset publishing CodeBuild projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetPublishingCodeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults) {
            this.assetPublishingCodeBuildDefaults = assetPublishingCodeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getCliVersion}
         * @param cliVersion CDK CLI version to use in self-mutation and asset publishing steps.
         *                   If you want to lock the CDK CLI version used in the pipeline, by steps
         *                   that are automatically generated for you, specify the version here.
         *                   <p>
         *                   We recommend you do not specify this value, as not specifying it always
         *                   uses the latest CLI version which is backwards compatible with old versions.
         *                   <p>
         *                   If you do specify it, be aware that this version should always be equal to or higher than the
         *                   version of the CDK framework used by the CDK app, when the CDK commands are
         *                   run during your pipeline execution. When you change this version, the <em>next
         *                   time</em> the <code>SelfMutate</code> step runs it will still be using the CLI of the the
         *                   <em>previous</em> version that was in this property: it will only start using the
         *                   new version after <code>SelfMutate</code> completes successfully. That means that if
         *                   you want to update both framework and CLI version, you should update the
         *                   CLI version first, commit, push and deploy, and only then update the
         *                   framework version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cliVersion(java.lang.String cliVersion) {
            this.cliVersion = cliVersion;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getCodeBuildDefaults}
         * @param codeBuildDefaults Customize the CodeBuild projects created for this pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults) {
            this.codeBuildDefaults = codeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getCodePipeline}
         * @param codePipeline An existing Pipeline to be reused and built upon.
         *                     [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder codePipeline(software.amazon.awscdk.services.codepipeline.Pipeline codePipeline) {
            this.codePipeline = codePipeline;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getCrossAccountKeys}
         * @param crossAccountKeys Create KMS keys for the artifact buckets, allowing cross-account deployments.
         *                         The artifact buckets have to be encrypted to support deploying CDK apps to
         *                         another account, so if you want to do that or want to have your artifact
         *                         buckets encrypted, be sure to set this value to <code>true</code>.
         *                         <p>
         *                         Be aware there is a cost associated with maintaining the KMS keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossAccountKeys(java.lang.Boolean crossAccountKeys) {
            this.crossAccountKeys = crossAccountKeys;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getDockerCredentials}
         * @param dockerCredentials A list of credentials used to authenticate to Docker registries.
         *                          Specify any credentials necessary within the pipeline to build, synth, update, or publish assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dockerCredentials(java.util.List<? extends software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials) {
            this.dockerCredentials = (java.util.List<software.amazon.awscdk.pipelines.DockerCredential>)dockerCredentials;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getDockerEnabledForSelfMutation}
         * @param dockerEnabledForSelfMutation Enable Docker for the self-mutate step.
         *                                     Set this to true if the pipeline itself uses Docker container assets
         *                                     (for example, if you use <code>LinuxBuildImage.fromAsset()</code> as the build
         *                                     image of a CodeBuild step in the pipeline).
         *                                     <p>
         *                                     You do not need to set it if you build Docker image assets in the
         *                                     application Stages and Stacks that are <em>deployed</em> by this pipeline.
         *                                     <p>
         *                                     Configures privileged mode for the self-mutation CodeBuild action.
         *                                     <p>
         *                                     If you are about to turn this on in an already-deployed Pipeline,
         *                                     set the value to <code>true</code> first, commit and allow the pipeline to
         *                                     self-update, and only then use the Docker asset in the pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSelfMutation(java.lang.Boolean dockerEnabledForSelfMutation) {
            this.dockerEnabledForSelfMutation = dockerEnabledForSelfMutation;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getDockerEnabledForSynth}
         * @param dockerEnabledForSynth Enable Docker for the 'synth' step.
         *                              Set this to true if you are using file assets that require
         *                              "bundling" anywhere in your application (meaning an asset
         *                              compilation step will be run with the tools provided by
         *                              a Docker image), both for the Pipeline stack as well as the
         *                              application stacks.
         *                              <p>
         *                              A common way to use bundling assets in your application is by
         *                              using the <code>&#64;aws-cdk/aws-lambda-nodejs</code> library.
         *                              <p>
         *                              Configures privileged mode for the synth CodeBuild action.
         *                              <p>
         *                              If you are about to turn this on in an already-deployed Pipeline,
         *                              set the value to <code>true</code> first, commit and allow the pipeline to
         *                              self-update, and only then use the bundled asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dockerEnabledForSynth(java.lang.Boolean dockerEnabledForSynth) {
            this.dockerEnabledForSynth = dockerEnabledForSynth;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getPipelineName}
         * @param pipelineName The name of the CodePipeline pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineName(java.lang.String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getPublishAssetsInParallel}
         * @param publishAssetsInParallel Publish assets in multiple CodeBuild projects.
         *                                If set to false, use one Project per type to publish all assets.
         *                                <p>
         *                                Publishing in parallel improves concurrency and may reduce publishing
         *                                latency, but may also increase overall provisioning time of the CodeBuild
         *                                projects.
         *                                <p>
         *                                Experiment and see what value works best for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publishAssetsInParallel(java.lang.Boolean publishAssetsInParallel) {
            this.publishAssetsInParallel = publishAssetsInParallel;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getReuseCrossRegionSupportStacks}
         * @param reuseCrossRegionSupportStacks Reuse the same cross region support stack for all pipelines in the App.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseCrossRegionSupportStacks(java.lang.Boolean reuseCrossRegionSupportStacks) {
            this.reuseCrossRegionSupportStacks = reuseCrossRegionSupportStacks;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getSelfMutation}
         * @param selfMutation Whether the pipeline will update itself.
         *                     This needs to be set to <code>true</code> to allow the pipeline to reconfigure
         *                     itself when assets or stages are being added to it, and <code>true</code> is the
         *                     recommended setting.
         *                     <p>
         *                     You can temporarily set this to <code>false</code> while you are iterating
         *                     on the pipeline itself and prefer to deploy changes using <code>cdk deploy</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutation(java.lang.Boolean selfMutation) {
            this.selfMutation = selfMutation;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getSelfMutationCodeBuildDefaults}
         * @param selfMutationCodeBuildDefaults Additional customizations to apply to the self mutation CodeBuild projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfMutationCodeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults) {
            this.selfMutationCodeBuildDefaults = selfMutationCodeBuildDefaults;
            return this;
        }

        /**
         * Sets the value of {@link PDKPipelineProps#getSynthCodeBuildDefaults}
         * @param synthCodeBuildDefaults Additional customizations to apply to the synthesize CodeBuild projects.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder synthCodeBuildDefaults(software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults) {
            this.synthCodeBuildDefaults = synthCodeBuildDefaults;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PDKPipelineProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PDKPipelineProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PDKPipelineProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PDKPipelineProps {
        private final java.lang.String primarySynthDirectory;
        private final java.lang.String repositoryName;
        private final software.amazon.awscdk.RemovalPolicy codeCommitRemovalPolicy;
        private final java.lang.String defaultBranchName;
        private final software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig sonarCodeScannerConfig;
        private final software.amazon.awscdk.pipelines.ShellStepProps synthShellStepPartialProps;
        private final software.amazon.awscdk.pipelines.IFileSetProducer synth;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions assetPublishingCodeBuildDefaults;
        private final java.lang.String cliVersion;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions codeBuildDefaults;
        private final software.amazon.awscdk.services.codepipeline.Pipeline codePipeline;
        private final java.lang.Boolean crossAccountKeys;
        private final java.util.List<software.amazon.awscdk.pipelines.DockerCredential> dockerCredentials;
        private final java.lang.Boolean dockerEnabledForSelfMutation;
        private final java.lang.Boolean dockerEnabledForSynth;
        private final java.lang.String pipelineName;
        private final java.lang.Boolean publishAssetsInParallel;
        private final java.lang.Boolean reuseCrossRegionSupportStacks;
        private final java.lang.Boolean selfMutation;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions selfMutationCodeBuildDefaults;
        private final software.amazon.awscdk.pipelines.CodeBuildOptions synthCodeBuildDefaults;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.primarySynthDirectory = software.amazon.jsii.Kernel.get(this, "primarySynthDirectory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repositoryName = software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeCommitRemovalPolicy = software.amazon.jsii.Kernel.get(this, "codeCommitRemovalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.defaultBranchName = software.amazon.jsii.Kernel.get(this, "defaultBranchName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sonarCodeScannerConfig = software.amazon.jsii.Kernel.get(this, "sonarCodeScannerConfig", software.amazon.jsii.NativeType.forClass(software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig.class));
            this.synthShellStepPartialProps = software.amazon.jsii.Kernel.get(this, "synthShellStepPartialProps", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.ShellStepProps.class));
            this.synth = software.amazon.jsii.Kernel.get(this, "synth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.IFileSetProducer.class));
            this.assetPublishingCodeBuildDefaults = software.amazon.jsii.Kernel.get(this, "assetPublishingCodeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.cliVersion = software.amazon.jsii.Kernel.get(this, "cliVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.codeBuildDefaults = software.amazon.jsii.Kernel.get(this, "codeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.codePipeline = software.amazon.jsii.Kernel.get(this, "codePipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Pipeline.class));
            this.crossAccountKeys = software.amazon.jsii.Kernel.get(this, "crossAccountKeys", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dockerCredentials = software.amazon.jsii.Kernel.get(this, "dockerCredentials", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.DockerCredential.class)));
            this.dockerEnabledForSelfMutation = software.amazon.jsii.Kernel.get(this, "dockerEnabledForSelfMutation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dockerEnabledForSynth = software.amazon.jsii.Kernel.get(this, "dockerEnabledForSynth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.pipelineName = software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publishAssetsInParallel = software.amazon.jsii.Kernel.get(this, "publishAssetsInParallel", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.reuseCrossRegionSupportStacks = software.amazon.jsii.Kernel.get(this, "reuseCrossRegionSupportStacks", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.selfMutation = software.amazon.jsii.Kernel.get(this, "selfMutation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.selfMutationCodeBuildDefaults = software.amazon.jsii.Kernel.get(this, "selfMutationCodeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
            this.synthCodeBuildDefaults = software.amazon.jsii.Kernel.get(this, "synthCodeBuildDefaults", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.CodeBuildOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.primarySynthDirectory = java.util.Objects.requireNonNull(builder.primarySynthDirectory, "primarySynthDirectory is required");
            this.repositoryName = java.util.Objects.requireNonNull(builder.repositoryName, "repositoryName is required");
            this.codeCommitRemovalPolicy = builder.codeCommitRemovalPolicy;
            this.defaultBranchName = builder.defaultBranchName;
            this.sonarCodeScannerConfig = builder.sonarCodeScannerConfig;
            this.synthShellStepPartialProps = builder.synthShellStepPartialProps;
            this.synth = java.util.Objects.requireNonNull(builder.synth, "synth is required");
            this.assetPublishingCodeBuildDefaults = builder.assetPublishingCodeBuildDefaults;
            this.cliVersion = builder.cliVersion;
            this.codeBuildDefaults = builder.codeBuildDefaults;
            this.codePipeline = builder.codePipeline;
            this.crossAccountKeys = builder.crossAccountKeys;
            this.dockerCredentials = (java.util.List<software.amazon.awscdk.pipelines.DockerCredential>)builder.dockerCredentials;
            this.dockerEnabledForSelfMutation = builder.dockerEnabledForSelfMutation;
            this.dockerEnabledForSynth = builder.dockerEnabledForSynth;
            this.pipelineName = builder.pipelineName;
            this.publishAssetsInParallel = builder.publishAssetsInParallel;
            this.reuseCrossRegionSupportStacks = builder.reuseCrossRegionSupportStacks;
            this.selfMutation = builder.selfMutation;
            this.selfMutationCodeBuildDefaults = builder.selfMutationCodeBuildDefaults;
            this.synthCodeBuildDefaults = builder.synthCodeBuildDefaults;
        }

        @Override
        public final java.lang.String getPrimarySynthDirectory() {
            return this.primarySynthDirectory;
        }

        @Override
        public final java.lang.String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getCodeCommitRemovalPolicy() {
            return this.codeCommitRemovalPolicy;
        }

        @Override
        public final java.lang.String getDefaultBranchName() {
            return this.defaultBranchName;
        }

        @Override
        public final software.aws.awsprototypingsdk.pipeline.SonarCodeScannerConfig getSonarCodeScannerConfig() {
            return this.sonarCodeScannerConfig;
        }

        @Override
        public final software.amazon.awscdk.pipelines.ShellStepProps getSynthShellStepPartialProps() {
            return this.synthShellStepPartialProps;
        }

        @Override
        public final software.amazon.awscdk.pipelines.IFileSetProducer getSynth() {
            return this.synth;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getAssetPublishingCodeBuildDefaults() {
            return this.assetPublishingCodeBuildDefaults;
        }

        @Override
        public final java.lang.String getCliVersion() {
            return this.cliVersion;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getCodeBuildDefaults() {
            return this.codeBuildDefaults;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Pipeline getCodePipeline() {
            return this.codePipeline;
        }

        @Override
        public final java.lang.Boolean getCrossAccountKeys() {
            return this.crossAccountKeys;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.DockerCredential> getDockerCredentials() {
            return this.dockerCredentials;
        }

        @Override
        public final java.lang.Boolean getDockerEnabledForSelfMutation() {
            return this.dockerEnabledForSelfMutation;
        }

        @Override
        public final java.lang.Boolean getDockerEnabledForSynth() {
            return this.dockerEnabledForSynth;
        }

        @Override
        public final java.lang.String getPipelineName() {
            return this.pipelineName;
        }

        @Override
        public final java.lang.Boolean getPublishAssetsInParallel() {
            return this.publishAssetsInParallel;
        }

        @Override
        public final java.lang.Boolean getReuseCrossRegionSupportStacks() {
            return this.reuseCrossRegionSupportStacks;
        }

        @Override
        public final java.lang.Boolean getSelfMutation() {
            return this.selfMutation;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getSelfMutationCodeBuildDefaults() {
            return this.selfMutationCodeBuildDefaults;
        }

        @Override
        public final software.amazon.awscdk.pipelines.CodeBuildOptions getSynthCodeBuildDefaults() {
            return this.synthCodeBuildDefaults;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("primarySynthDirectory", om.valueToTree(this.getPrimarySynthDirectory()));
            data.set("repositoryName", om.valueToTree(this.getRepositoryName()));
            if (this.getCodeCommitRemovalPolicy() != null) {
                data.set("codeCommitRemovalPolicy", om.valueToTree(this.getCodeCommitRemovalPolicy()));
            }
            if (this.getDefaultBranchName() != null) {
                data.set("defaultBranchName", om.valueToTree(this.getDefaultBranchName()));
            }
            if (this.getSonarCodeScannerConfig() != null) {
                data.set("sonarCodeScannerConfig", om.valueToTree(this.getSonarCodeScannerConfig()));
            }
            if (this.getSynthShellStepPartialProps() != null) {
                data.set("synthShellStepPartialProps", om.valueToTree(this.getSynthShellStepPartialProps()));
            }
            data.set("synth", om.valueToTree(this.getSynth()));
            if (this.getAssetPublishingCodeBuildDefaults() != null) {
                data.set("assetPublishingCodeBuildDefaults", om.valueToTree(this.getAssetPublishingCodeBuildDefaults()));
            }
            if (this.getCliVersion() != null) {
                data.set("cliVersion", om.valueToTree(this.getCliVersion()));
            }
            if (this.getCodeBuildDefaults() != null) {
                data.set("codeBuildDefaults", om.valueToTree(this.getCodeBuildDefaults()));
            }
            if (this.getCodePipeline() != null) {
                data.set("codePipeline", om.valueToTree(this.getCodePipeline()));
            }
            if (this.getCrossAccountKeys() != null) {
                data.set("crossAccountKeys", om.valueToTree(this.getCrossAccountKeys()));
            }
            if (this.getDockerCredentials() != null) {
                data.set("dockerCredentials", om.valueToTree(this.getDockerCredentials()));
            }
            if (this.getDockerEnabledForSelfMutation() != null) {
                data.set("dockerEnabledForSelfMutation", om.valueToTree(this.getDockerEnabledForSelfMutation()));
            }
            if (this.getDockerEnabledForSynth() != null) {
                data.set("dockerEnabledForSynth", om.valueToTree(this.getDockerEnabledForSynth()));
            }
            if (this.getPipelineName() != null) {
                data.set("pipelineName", om.valueToTree(this.getPipelineName()));
            }
            if (this.getPublishAssetsInParallel() != null) {
                data.set("publishAssetsInParallel", om.valueToTree(this.getPublishAssetsInParallel()));
            }
            if (this.getReuseCrossRegionSupportStacks() != null) {
                data.set("reuseCrossRegionSupportStacks", om.valueToTree(this.getReuseCrossRegionSupportStacks()));
            }
            if (this.getSelfMutation() != null) {
                data.set("selfMutation", om.valueToTree(this.getSelfMutation()));
            }
            if (this.getSelfMutationCodeBuildDefaults() != null) {
                data.set("selfMutationCodeBuildDefaults", om.valueToTree(this.getSelfMutationCodeBuildDefaults()));
            }
            if (this.getSynthCodeBuildDefaults() != null) {
                data.set("synthCodeBuildDefaults", om.valueToTree(this.getSynthCodeBuildDefaults()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-prototyping-sdk.pipeline.PDKPipelineProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PDKPipelineProps.Jsii$Proxy that = (PDKPipelineProps.Jsii$Proxy) o;

            if (!primarySynthDirectory.equals(that.primarySynthDirectory)) return false;
            if (!repositoryName.equals(that.repositoryName)) return false;
            if (this.codeCommitRemovalPolicy != null ? !this.codeCommitRemovalPolicy.equals(that.codeCommitRemovalPolicy) : that.codeCommitRemovalPolicy != null) return false;
            if (this.defaultBranchName != null ? !this.defaultBranchName.equals(that.defaultBranchName) : that.defaultBranchName != null) return false;
            if (this.sonarCodeScannerConfig != null ? !this.sonarCodeScannerConfig.equals(that.sonarCodeScannerConfig) : that.sonarCodeScannerConfig != null) return false;
            if (this.synthShellStepPartialProps != null ? !this.synthShellStepPartialProps.equals(that.synthShellStepPartialProps) : that.synthShellStepPartialProps != null) return false;
            if (!synth.equals(that.synth)) return false;
            if (this.assetPublishingCodeBuildDefaults != null ? !this.assetPublishingCodeBuildDefaults.equals(that.assetPublishingCodeBuildDefaults) : that.assetPublishingCodeBuildDefaults != null) return false;
            if (this.cliVersion != null ? !this.cliVersion.equals(that.cliVersion) : that.cliVersion != null) return false;
            if (this.codeBuildDefaults != null ? !this.codeBuildDefaults.equals(that.codeBuildDefaults) : that.codeBuildDefaults != null) return false;
            if (this.codePipeline != null ? !this.codePipeline.equals(that.codePipeline) : that.codePipeline != null) return false;
            if (this.crossAccountKeys != null ? !this.crossAccountKeys.equals(that.crossAccountKeys) : that.crossAccountKeys != null) return false;
            if (this.dockerCredentials != null ? !this.dockerCredentials.equals(that.dockerCredentials) : that.dockerCredentials != null) return false;
            if (this.dockerEnabledForSelfMutation != null ? !this.dockerEnabledForSelfMutation.equals(that.dockerEnabledForSelfMutation) : that.dockerEnabledForSelfMutation != null) return false;
            if (this.dockerEnabledForSynth != null ? !this.dockerEnabledForSynth.equals(that.dockerEnabledForSynth) : that.dockerEnabledForSynth != null) return false;
            if (this.pipelineName != null ? !this.pipelineName.equals(that.pipelineName) : that.pipelineName != null) return false;
            if (this.publishAssetsInParallel != null ? !this.publishAssetsInParallel.equals(that.publishAssetsInParallel) : that.publishAssetsInParallel != null) return false;
            if (this.reuseCrossRegionSupportStacks != null ? !this.reuseCrossRegionSupportStacks.equals(that.reuseCrossRegionSupportStacks) : that.reuseCrossRegionSupportStacks != null) return false;
            if (this.selfMutation != null ? !this.selfMutation.equals(that.selfMutation) : that.selfMutation != null) return false;
            if (this.selfMutationCodeBuildDefaults != null ? !this.selfMutationCodeBuildDefaults.equals(that.selfMutationCodeBuildDefaults) : that.selfMutationCodeBuildDefaults != null) return false;
            return this.synthCodeBuildDefaults != null ? this.synthCodeBuildDefaults.equals(that.synthCodeBuildDefaults) : that.synthCodeBuildDefaults == null;
        }

        @Override
        public final int hashCode() {
            int result = this.primarySynthDirectory.hashCode();
            result = 31 * result + (this.repositoryName.hashCode());
            result = 31 * result + (this.codeCommitRemovalPolicy != null ? this.codeCommitRemovalPolicy.hashCode() : 0);
            result = 31 * result + (this.defaultBranchName != null ? this.defaultBranchName.hashCode() : 0);
            result = 31 * result + (this.sonarCodeScannerConfig != null ? this.sonarCodeScannerConfig.hashCode() : 0);
            result = 31 * result + (this.synthShellStepPartialProps != null ? this.synthShellStepPartialProps.hashCode() : 0);
            result = 31 * result + (this.synth.hashCode());
            result = 31 * result + (this.assetPublishingCodeBuildDefaults != null ? this.assetPublishingCodeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.cliVersion != null ? this.cliVersion.hashCode() : 0);
            result = 31 * result + (this.codeBuildDefaults != null ? this.codeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.codePipeline != null ? this.codePipeline.hashCode() : 0);
            result = 31 * result + (this.crossAccountKeys != null ? this.crossAccountKeys.hashCode() : 0);
            result = 31 * result + (this.dockerCredentials != null ? this.dockerCredentials.hashCode() : 0);
            result = 31 * result + (this.dockerEnabledForSelfMutation != null ? this.dockerEnabledForSelfMutation.hashCode() : 0);
            result = 31 * result + (this.dockerEnabledForSynth != null ? this.dockerEnabledForSynth.hashCode() : 0);
            result = 31 * result + (this.pipelineName != null ? this.pipelineName.hashCode() : 0);
            result = 31 * result + (this.publishAssetsInParallel != null ? this.publishAssetsInParallel.hashCode() : 0);
            result = 31 * result + (this.reuseCrossRegionSupportStacks != null ? this.reuseCrossRegionSupportStacks.hashCode() : 0);
            result = 31 * result + (this.selfMutation != null ? this.selfMutation.hashCode() : 0);
            result = 31 * result + (this.selfMutationCodeBuildDefaults != null ? this.selfMutationCodeBuildDefaults.hashCode() : 0);
            result = 31 * result + (this.synthCodeBuildDefaults != null ? this.synthCodeBuildDefaults.hashCode() : 0);
            return result;
        }
    }
}
