/**
 * <h2>PDK Nag</h2>
 * <p>
 * PDKNag ships with a helper utility that automatically configures CDKNag within your application.
 * <p>
 * <blockquote><pre>
 * const app = PDKNag.app();
 * const stack = new Stack(app, 'MyStack');
 * ...
 * </pre></blockquote>
 * <p>
 * As shown above, this will configure your application to have CDKNag run on synthesis.
 * <p>
 * By default, CDK will trigger a failure on <code>synth</code> if any errors are encountered. To relax these, run the following:
 * <p>
 * <blockquote><pre>
 * cdk synth --ignore-errors
 * </pre></blockquote>
 * <p>
 * Conversely, CDK will not fail on synth if warnings are detected. To enforce that all warnings are resolved, run the following command:
 * <p>
 * <blockquote><pre>
 * cdk synth --strict
 * </pre></blockquote>
 */
package software.aws.awsprototypingsdk.pdknag;
