/**
 * The aws-prototyping-sdk provides stable CDK and Projen constructs, allowing developers to have access to higher level abstractions than provided by the CDK or Projen alone.
 * <p>
 * For detailed documentation, please refer to the <a href="https://aws.github.io/aws-prototyping-sdk/">documentation website</a>.
 * <p>
 * <h2>Bundling</h2>
 * <p>
 * This package simply bundles various packages from the <code>&#64;aws-prototyping-sdk</code> namespace which have been marked as <code>stable</code>. As such, not all constructs or classes may be exported from this package and will need to be explicitly imported by creating a dependency on the individual packages.
 * <p>
 * To illustrate, at the time of writing the following individual packages are published:
 * <p>
 * <blockquote><pre>
 * &#64;aws-prototyping-sdk
 *         |_ pipeline       : [stable]
 *         |_ nx-monorepo    : [stable]
 *         |_ static-website : [experimental]
 *         |_ identity       : [experimental]
 * </pre></blockquote>
 * <p>
 * The aws-prototyping-sdk package will bundle all stable packages and export them as namespaces as follows:
 * <p>
 * <blockquote><pre>
 * aws-prototyping-sdk
 *         |_ pipeline
 *         |_ nx_monorepo
 * </pre></blockquote>
 * <p>
 * This means if you wanted to access the PDKPipeline which is a stable construct, you simply add a dependency on the <code>aws-prototyping-sdk</code> and import it as follows:
 * <p>
 * <blockquote><pre>
 * import { nx_monorepo, pipeline } from "aws-prototyping-sdk";
 * </pre></blockquote>
 * <p>
 * To import <code>experimental</code> constructs, a dependency on the individual package is required. In the case of <code>static-website</code>, a dependency on <code>&#64;aws-prototyping-sdk/static-website</code> is required. The constructs can then be imported as follows:
 * <p>
 * <blockquote><pre>
 * import { StaticWebsite } from "&#64;aws-prototyping-sdk/static-website";
 * </pre></blockquote>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.aws.awsprototypingsdk;
