/**
 * <h2>PDK Nag</h2>
 * <p>
 * PDKNag ships with a helper utility that automatically configures CDKNag within your application.
 * <p>
 * <blockquote><pre>
 * const app = PDKNag.app();
 * const stack = new Stack(app, 'MyStack');
 * ...
 * </pre></blockquote>
 * <p>
 * As shown above, this will configure your application to have CDKNag run on synthesis.
 * <p>
 * By default, CDK will trigger a failure on <code>synth</code> if any errors are encountered. To relax these, run the following:
 * <p>
 * <blockquote><pre>
 * cdk synth --ignore-errors
 * </pre></blockquote>
 * <p>
 * Conversely, CDK will not fail on synth if warnings are detected. To enforce that all warnings are resolved, run the following command:
 * <p>
 * <blockquote><pre>
 * cdk synth --strict
 * </pre></blockquote>
 * <p>
 * <h3>Instrumenting custom NagPacks</h3>
 * <p>
 * By default, when creating a PDKNag application the <a href="https://github.com/cdklabs/cdk-nag/blob/main/RULES.md">AwsSolutions</a> NagPack is instrumented. In order to specify custom NagPacks to instrument, you can configure the PDKApp as follows:
 * <p>
 * <blockquote><pre>
 * import { PDKNag, AwsPrototypingChecks } from "&#64;aws-prototyping-sdk/pdk-nag";
 * 
 * const app = PDKNag.app({
 *     nagPacks: [new AwsPrototypingChecks()]
 * });
 * </pre></blockquote>
 * <p>
 * In this example, the <a href="https://github.com/aws/aws-prototyping-sdk/blob/mainline/packages/pdk-nag/src/packs/README.md">AwsPrototypingChecks</a> NagPack has been configured to run instead of the default. Multiple NagPacks can also be instrumented by adding NagPack instances to the <code>nagPacks</code> array;
 */
package software.aws.awsprototypingsdk.pdknag;
