/*
 * Decompiled with CFR 0.152.
 */
package se.laz.casual.jca.inbound.handler.service.javaee;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import se.laz.casual.api.flags.ErrorState;
import se.laz.casual.api.flags.TransactionState;
import se.laz.casual.api.service.ServiceInfo;
import se.laz.casual.internal.thread.ThreadClassLoaderTool;
import se.laz.casual.jca.inbound.handler.HandlerException;
import se.laz.casual.jca.inbound.handler.InboundRequest;
import se.laz.casual.jca.inbound.handler.InboundResponse;
import se.laz.casual.jca.inbound.handler.buffer.BufferHandler;
import se.laz.casual.jca.inbound.handler.buffer.BufferHandlerFactory;
import se.laz.casual.jca.inbound.handler.buffer.ServiceCallInfo;
import se.laz.casual.jca.inbound.handler.service.ServiceHandler;
import se.laz.casual.jca.inbound.handler.service.extension.ServiceHandlerExtension;
import se.laz.casual.jca.inbound.handler.service.extension.ServiceHandlerExtensionContext;
import se.laz.casual.jca.inbound.handler.service.extension.ServiceHandlerExtensionFactory;

@Stateless
public class JavaeeServiceHandler
implements ServiceHandler {
    private static final Logger LOG = Logger.getLogger(JavaeeServiceHandler.class.getName());
    private Context context;

    public boolean canHandleService(String serviceName) {
        return this.isServiceAvailable(serviceName);
    }

    public boolean isServiceAvailable(String serviceName) {
        try {
            this.loadService(serviceName);
            return true;
        }
        catch (NamingException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundResponse invokeService(InboundRequest request) {
        InboundResponse inboundResponse;
        LOG.finest(() -> "Request received: " + request);
        ThreadClassLoaderTool tool = new ThreadClassLoaderTool();
        ServiceHandlerExtension serviceHandlerExtension = ServiceHandlerExtensionFactory.getExtension((String)Remote.class.getName());
        ServiceHandlerExtensionContext extensionContext = null;
        try {
            Object r = this.loadService(request.getServiceName());
            BufferHandler bufferHandler = BufferHandlerFactory.getHandler((String)request.getBuffer().getType());
            tool.loadClassLoader(r);
            extensionContext = serviceHandlerExtension.before(request, bufferHandler);
            InboundResponse response = this.callService(r, request, bufferHandler, serviceHandlerExtension, extensionContext);
            inboundResponse = serviceHandlerExtension.handleSuccess(extensionContext, response);
        }
        catch (Throwable e) {
            InboundResponse inboundResponse2;
            try {
                LOG.log(Level.WARNING, e, () -> "Error invoking service: " + e.getMessage());
                InboundResponse response = InboundResponse.createBuilder().errorState(ErrorState.TPESVCERR).transactionState(TransactionState.ROLLBACK_ONLY).build();
                inboundResponse2 = serviceHandlerExtension.handleError(extensionContext, request, response, e);
            }
            catch (Throwable throwable) {
                serviceHandlerExtension.after(extensionContext);
                tool.revertClassLoader();
                throw throwable;
            }
            serviceHandlerExtension.after(extensionContext);
            tool.revertClassLoader();
            return inboundResponse2;
        }
        serviceHandlerExtension.after(extensionContext);
        tool.revertClassLoader();
        return inboundResponse;
    }

    public ServiceInfo getServiceInfo(String serviceName) {
        if (!this.canHandleService(serviceName)) {
            throw new HandlerException("Service could not be found, should control with canHandle() first.");
        }
        return ServiceInfo.of((String)serviceName);
    }

    private Object loadService(String jndiName) throws NamingException {
        Context c = this.getContext();
        Object r = c.lookup(jndiName);
        LOG.finest(() -> "Found " + r.getClass() + " : " + r);
        return r;
    }

    private InboundResponse callService(Object r, InboundRequest payload, BufferHandler bufferHandler, ServiceHandlerExtension serviceHandlerExtension, ServiceHandlerExtensionContext extensionContext) throws Throwable {
        Proxy p = (Proxy)r;
        ServiceCallInfo serviceCallInfo = bufferHandler.fromRequest(p, null, payload);
        Method method = (Method)serviceCallInfo.getMethod().orElseThrow(() -> new HandlerException("Buffer did not provided required details about the method end point."));
        Object[] params = serviceHandlerExtension.convertRequestParams(extensionContext, serviceCallInfo.getParams());
        Object result = method.invoke((Object)p, params);
        LOG.finest(() -> "Result: " + result);
        return bufferHandler.toResponse(serviceCallInfo, result);
    }

    Context getContext() throws NamingException {
        if (this.context == null) {
            this.context = new InitialContext();
        }
        return this.context;
    }

    void setContext(Context context) {
        this.context = context;
    }
}

