/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.plugin.mvc;

import com.alibaba.nacos.api.exception.NacosException;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.DOceanPlugin;
import com.xiaomi.youpin.docean.common.NetUtils;
import com.xiaomi.youpin.docean.plugin.IPlugin;
import com.xiaomi.youpin.docean.plugin.config.Config;
import com.xiaomi.youpin.docean.plugin.nacos.NacosNaming;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DOceanPlugin(order=200)
public class MvcPlugin
implements IPlugin {
    private static final Logger log = LoggerFactory.getLogger(MvcPlugin.class);
    private String serviceName;
    private String ip;
    private int port;

    public void init(Set<? extends Class<?>> classSet, Ioc ioc) {
        String host;
        log.info("mvc plugin init");
        Config config = (Config)ioc.getBean(Config.class);
        this.serviceName = config.get("app_name", "");
        this.ip = host = System.getenv("host.ip") == null ? NetUtils.getLocalHost() : System.getenv("host.ip");
        this.port = Integer.parseInt(config.get("http_port", "80"));
        NacosNaming nn = (NacosNaming)ioc.getBean(NacosNaming.class.getName(), null);
        if (null != nn) {
            try {
                nn.registerInstance(this.serviceName, this.ip, this.port);
            }
            catch (NacosException e) {
                log.error(e.getMessage());
            }
        }
    }

    public void destory(Ioc ioc) {
        NacosNaming nn = (NacosNaming)ioc.getBean(NacosNaming.class.getName(), null);
        if (null != nn) {
            try {
                nn.deregisterInstance(this.serviceName, this.ip, this.port);
            }
            catch (NacosException e) {
                log.error(e.getMessage());
            }
        }
    }
}

