/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core.utils;

import java.math.BigDecimal;
import ru.tinkoff.piapi.contract.v1.MoneyValue;
import ru.tinkoff.piapi.contract.v1.Quotation;

public class MapperUtils {
    public static Quotation bigDecimalToQuotation(BigDecimal value) {
        return Quotation.newBuilder().setUnits(MapperUtils.getUnits(value)).setNano(MapperUtils.getNano(value)).build();
    }

    public static MoneyValue bigDecimalToMoneyValue(BigDecimal value, String currency) {
        return MoneyValue.newBuilder().setUnits(MapperUtils.getUnits(value)).setNano(MapperUtils.getNano(value)).setCurrency(MapperUtils.toLowerCaseNullable(currency)).build();
    }

    public static long getUnits(BigDecimal value) {
        return value != null ? value.longValue() : 0L;
    }

    public static int getNano(BigDecimal value) {
        return value != null ? value.remainder(BigDecimal.ONE).multiply(BigDecimal.valueOf(1000000000L)).intValue() : 0;
    }

    private static String toLowerCaseNullable(String value) {
        return value != null ? value.toLowerCase() : "";
    }

    public static MoneyValue bigDecimalToMoneyValue(BigDecimal value) {
        return MapperUtils.bigDecimalToMoneyValue(value, null);
    }

    public static BigDecimal quotationToBigDecimal(Quotation value) {
        if (value == null) {
            return null;
        }
        return MapperUtils.mapUnitsAndNanos(value.getUnits(), value.getNano());
    }

    public static BigDecimal moneyValueToBigDecimal(MoneyValue value) {
        if (value == null) {
            return null;
        }
        return MapperUtils.mapUnitsAndNanos(value.getUnits(), value.getNano());
    }

    public static BigDecimal mapUnitsAndNanos(long units, int nanos) {
        if (units == 0L && nanos == 0) {
            return BigDecimal.ZERO;
        }
        return BigDecimal.valueOf(units).add(BigDecimal.valueOf(nanos, 9));
    }
}

