/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core.utils;

import io.grpc.stub.StreamObserver;
import io.smallrye.mutiny.subscription.MultiEmitter;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class Helpers {
    public static <T> CompletableFuture<T> wrapWithFuture(Consumer<StreamObserver<T>> callPerformer) {
        CompletableFuture cf = new CompletableFuture();
        callPerformer.accept(Helpers.mkStreamObserverWithFuture(cf));
        return cf;
    }

    private static <T> StreamObserver<T> mkStreamObserverWithFuture(final CompletableFuture<T> cf) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                cf.complete(value);
            }

            public void onError(Throwable t) {
                cf.completeExceptionally(t);
            }

            public void onCompleted() {
            }
        };
    }

    public static <T> StreamObserver<T> wrapEmitterWithStreamObserver(final MultiEmitter<? super T> emitter) {
        return new StreamObserver<T>(){

            public void onNext(T value) {
                emitter.emit(value);
            }

            public void onError(Throwable t) {
                emitter.fail(t);
            }

            public void onCompleted() {
                emitter.complete();
            }
        };
    }

    public static String preprocessInputOrderId(String orderId) {
        int maxLength = Math.min(orderId.length(), 36);
        return orderId.isBlank() ? orderId.trim() : orderId.substring(0, maxLength);
    }
}

