/*
 * Decompiled with CFR 0.152.
 */
package ru.tinkoff.piapi.core.utils;

import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class DateUtils {
    private static final ZoneId DEFAULT_ZONE_ID = ZoneId.of("Etc/GMT");
    private static final String PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ZoneOffset DEFAULT_ZONE_OFFSET = ZoneOffset.UTC;

    public static Timestamp epochToTimestamp(Long epochSeconds) {
        return Timestamp.newBuilder().setSeconds(epochSeconds.longValue()).build();
    }

    public static Timestamp offsetDateTimeToTimestamp(OffsetDateTime offsetDateTime) {
        Instant instant = offsetDateTime.toInstant();
        return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    public static LocalDate epochSecondToLocalDate(Timestamp timestamp) {
        return Instant.ofEpochMilli(timestamp.getSeconds() * 1000L).atZone(DEFAULT_ZONE_OFFSET).toLocalDate();
    }

    public static Long offsetDateTimeToLong(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return offsetDateTime.toInstant().getEpochSecond();
    }

    public static Timestamp instantToTimestamp(Instant i) {
        return Timestamp.newBuilder().setSeconds(i.getEpochSecond()).setNanos(i.getNano()).build();
    }

    public static Instant timestampToInstant(Timestamp t) {
        return Instant.ofEpochSecond(t.getSeconds(), t.getNanos());
    }

    public static String epochMillisToString(long epochMillis) {
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(epochMillis).atZone(DEFAULT_ZONE_ID);
        return zonedDateTime.format(DateTimeFormatter.ofPattern(PATTERN));
    }

    public static String timestampToString(Timestamp timestamp) {
        return DateUtils.epochMillisToString(timestamp.getSeconds() * 1000L);
    }
}

